/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.PagerUtils;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.TDDLHint;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallContext;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallSqlTableStat;
import com.alibaba.druid.wall.WallUpdateCheckItem;
import com.alibaba.druid.wall.spi.WallVisitorUtils;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;
import java.util.List;

public interface WallVisitor
extends SQLASTVisitor {
    public WallConfig getConfig();

    public WallProvider getProvider();

    public List<Violation> getViolations();

    public void addViolation(Violation var1);

    public boolean isDenyTable(String var1);

    default public String toSQL(SQLObject obj) {
        return SQLUtils.toSQLString(obj, this.getDbType());
    }

    public boolean isSqlModified();

    public void setSqlModified(boolean var1);

    public DbType getDbType();

    public boolean isSqlEndOfComment();

    public void setSqlEndOfComment(boolean var1);

    public void addWallUpdateCheckItem(WallUpdateCheckItem var1);

    public List<WallUpdateCheckItem> getUpdateCheckItems();

    @Override
    default public boolean visit(SQLPropertyExpr x) {
        WallVisitorUtils.check(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLInListExpr x) {
        WallVisitorUtils.check(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLBinaryOpExpr x) {
        return WallVisitorUtils.check(this, x);
    }

    @Override
    default public boolean visit(SQLMethodInvokeExpr x) {
        WallVisitorUtils.checkFunction(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLSelectQueryBlock x) {
        WallVisitorUtils.checkSelelct(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLSelectGroupByClause x) {
        WallVisitorUtils.checkHaving(this, x.getHaving());
        return true;
    }

    @Override
    default public boolean visit(SQLSelectItem x) {
        WallVisitorUtils.check(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLJoinTableSource x) {
        WallVisitorUtils.check(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLCreateTableStatement x) {
        WallVisitorUtils.check(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLAlterTableStatement x) {
        WallVisitorUtils.check(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLDropTableStatement x) {
        WallVisitorUtils.check(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLUpdateStatement x) {
        WallVisitorUtils.initWallTopStatementContext();
        WallVisitorUtils.checkUpdate(this, x);
        return true;
    }

    @Override
    default public void endVisit(SQLUpdateStatement x) {
        WallVisitorUtils.clearWallTopStatementContext();
    }

    @Override
    default public boolean visit(SQLInsertStatement x) {
        WallVisitorUtils.initWallTopStatementContext();
        WallVisitorUtils.checkInsert(this, x);
        return true;
    }

    @Override
    default public void endVisit(SQLInsertStatement x) {
        WallVisitorUtils.clearWallTopStatementContext();
    }

    @Override
    default public boolean visit(SQLDeleteStatement x) {
        WallVisitorUtils.checkDelete(this, x);
        return true;
    }

    @Override
    default public void preVisit(SQLObject x) {
        WallVisitorUtils.preVisitCheck(this, x);
    }

    @Override
    default public boolean visit(SQLSelectStatement x) {
        WallConfig config = this.getConfig();
        if (!config.isSelelctAllow()) {
            this.getViolations().add(new IllegalSQLObjectViolation(1002, "select not allow", this.toSQL(x)));
            return false;
        }
        WallVisitorUtils.initWallTopStatementContext();
        int selectLimit = config.getSelectLimit();
        if (selectLimit >= 0) {
            SQLSelect select = x.getSelect();
            PagerUtils.limit(select, this.getDbType(), 0, selectLimit, true);
            this.setSqlModified(true);
        }
        return true;
    }

    @Override
    default public void endVisit(SQLSelectStatement x) {
        WallVisitorUtils.clearWallTopStatementContext();
    }

    @Override
    default public boolean visit(SQLExprTableSource x) {
        WallVisitorUtils.check(this, x);
        return !(x.getExpr() instanceof SQLName);
    }

    @Override
    default public boolean visit(SQLIdentifierExpr x) {
        WallConfig config = this.getConfig();
        String name = x.getName();
        name = WallVisitorUtils.form(name);
        if (config.isVariantCheck() && config.getDenyVariants().contains(name)) {
            this.getViolations().add(new IllegalSQLObjectViolation(2003, "variable not allow : " + name, this.toSQL(x)));
        }
        return true;
    }

    @Override
    default public boolean visit(SQLUnionQuery x) {
        return WallVisitorUtils.checkUnion(this, x);
    }

    @Override
    default public void endVisit(SQLDeleteStatement x) {
        WallVisitorUtils.clearWallTopStatementContext();
    }

    @Override
    default public boolean visit(SQLLimit x) {
        if (x.getRowCount() instanceof SQLNumericLiteralExpr) {
            WallContext context = WallContext.current();
            int rowCount = ((SQLNumericLiteralExpr)x.getRowCount()).getNumber().intValue();
            if (rowCount == 0) {
                if (context != null) {
                    context.incrementWarnings();
                }
                if (!this.getProvider().getConfig().isLimitZeroAllow()) {
                    this.getViolations().add(new IllegalSQLObjectViolation(2200, "limit row 0", this.toSQL(x)));
                }
            }
        }
        return true;
    }

    @Override
    default public boolean visit(SQLCreateTriggerStatement x) {
        return false;
    }

    @Override
    default public boolean visit(SQLSetStatement x) {
        return false;
    }

    @Override
    default public boolean visit(SQLCallStatement x) {
        return false;
    }

    @Override
    default public boolean visit(SQLCommentHint x) {
        if (x instanceof TDDLHint) {
            return false;
        }
        WallVisitorUtils.check(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLShowCreateTableStatement x) {
        WallSqlTableStat tableStat;
        String tableName = x.getName().getSimpleName();
        WallContext context = WallContext.current();
        if (context != null && (tableStat = context.getTableStat(tableName)) != null) {
            tableStat.incrementShowCount();
        }
        return false;
    }
}

