/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.backups;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.backups.FailoverData;
import com.alibaba.nacos.client.naming.backups.FailoverDataSource;
import com.alibaba.nacos.client.naming.backups.FailoverSwitch;
import com.alibaba.nacos.client.naming.cache.InstancesDiffer;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.naming.event.InstancesChangeEvent;
import com.alibaba.nacos.client.naming.event.InstancesDiff;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class FailoverReactor
implements Closeable {
    private Map<String, ServiceInfo> serviceMap = new ConcurrentHashMap<String, ServiceInfo>();
    private boolean failoverSwitchEnable;
    private final ServiceInfoHolder serviceInfoHolder;
    private final ScheduledExecutorService executorService;
    private final InstancesDiffer instancesDiffer;
    private FailoverDataSource failoverDataSource;
    private String notifierEventScope;

    public FailoverReactor(ServiceInfoHolder serviceInfoHolder, String notifierEventScope) {
        this.serviceInfoHolder = serviceInfoHolder;
        this.notifierEventScope = notifierEventScope;
        this.instancesDiffer = new InstancesDiffer();
        Collection dataSources = NacosServiceLoader.load(FailoverDataSource.class);
        Iterator iterator = dataSources.iterator();
        if (iterator.hasNext()) {
            FailoverDataSource dataSource;
            this.failoverDataSource = dataSource = (FailoverDataSource)iterator.next();
            LogUtils.NAMING_LOGGER.info("FailoverDataSource type is {}", dataSource.getClass());
        }
        this.executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.naming.failover"));
        this.init();
    }

    public void init() {
        this.executorService.scheduleWithFixedDelay(new FailoverSwitchRefresher(), 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    public boolean isFailoverSwitch() {
        return this.failoverSwitchEnable;
    }

    public boolean isFailoverSwitch(String serviceName) {
        return this.failoverSwitchEnable && this.serviceMap.containsKey(serviceName) && this.serviceMap.get(serviceName).ipCount() > 0;
    }

    public ServiceInfo getService(String key) {
        ServiceInfo serviceInfo = this.serviceMap.get(key);
        if (serviceInfo == null) {
            serviceInfo = new ServiceInfo();
            serviceInfo.setName(key);
        }
        return serviceInfo;
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executorService, (Logger)LogUtils.NAMING_LOGGER);
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }

    private void failoverServiceCntMetrics() {
        try {
            for (Map.Entry<String, ServiceInfo> entry : this.serviceMap.entrySet()) {
                String serviceName = entry.getKey();
                ArrayList<ImmutableTag> tags = new ArrayList<ImmutableTag>();
                tags.add(new ImmutableTag("service_name", serviceName));
                if (Metrics.globalRegistry.find("nacos_naming_client_failover_instances").tags(tags).gauge() != null) continue;
                Gauge.builder((String)"nacos_naming_client_failover_instances", () -> this.serviceMap.get(serviceName).ipCount()).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
            }
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.info("[NA] registerFailoverServiceCnt fail.", (Throwable)e);
        }
    }

    private void failoverServiceCntMetricsClear() {
        try {
            for (Map.Entry<String, ServiceInfo> entry : this.serviceMap.entrySet()) {
                Gauge gauge = Metrics.globalRegistry.find("nacos_naming_client_failover_instances").tag("service_name", entry.getKey()).gauge();
                if (gauge == null) continue;
                Metrics.globalRegistry.remove((Meter)gauge);
            }
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.info("[NA] registerFailoverServiceCnt fail.", (Throwable)e);
        }
    }

    class FailoverSwitchRefresher
    implements Runnable {
        FailoverSwitchRefresher() {
        }

        @Override
        public void run() {
            try {
                FailoverSwitch fSwitch = FailoverReactor.this.failoverDataSource.getSwitch();
                if (fSwitch == null) {
                    FailoverReactor.this.failoverSwitchEnable = false;
                    return;
                }
                if (fSwitch.getEnabled() != FailoverReactor.this.failoverSwitchEnable) {
                    LogUtils.NAMING_LOGGER.info("failover switch changed, new: {}", (Object)fSwitch.getEnabled());
                }
                if (fSwitch.getEnabled()) {
                    ConcurrentHashMap<String, ServiceInfo> failoverMap = new ConcurrentHashMap<String, ServiceInfo>(200);
                    Map<String, FailoverData> failoverData = FailoverReactor.this.failoverDataSource.getFailoverData();
                    for (Map.Entry<String, FailoverData> entry : failoverData.entrySet()) {
                        ServiceInfo newService = (ServiceInfo)entry.getValue().getData();
                        ServiceInfo oldService = (ServiceInfo)FailoverReactor.this.serviceMap.get(entry.getKey());
                        InstancesDiff diff = FailoverReactor.this.instancesDiffer.doDiff(oldService, newService);
                        if (diff.hasDifferent()) {
                            LogUtils.NAMING_LOGGER.info("[NA] failoverdata isChangedServiceInfo. newService:{}", (Object)JacksonUtils.toJson((Object)newService));
                            NotifyCenter.publishEvent((Event)new InstancesChangeEvent(FailoverReactor.this.notifierEventScope, newService.getName(), newService.getGroupName(), newService.getClusters(), newService.getHosts(), diff));
                        }
                        failoverMap.put(entry.getKey(), (ServiceInfo)entry.getValue().getData());
                    }
                    if (failoverMap.size() > 0) {
                        FailoverReactor.this.failoverServiceCntMetrics();
                        FailoverReactor.this.serviceMap = failoverMap;
                    }
                    FailoverReactor.this.failoverSwitchEnable = true;
                    return;
                }
                if (FailoverReactor.this.failoverSwitchEnable && !fSwitch.getEnabled()) {
                    Map<String, ServiceInfo> serviceInfoMap = FailoverReactor.this.serviceInfoHolder.getServiceInfoMap();
                    for (Map.Entry entry : FailoverReactor.this.serviceMap.entrySet()) {
                        InstancesDiff diff;
                        ServiceInfo oldService = (ServiceInfo)entry.getValue();
                        ServiceInfo newService = serviceInfoMap.get(entry.getKey());
                        if (newService == null || !(diff = FailoverReactor.this.instancesDiffer.doDiff(oldService, newService)).hasDifferent()) continue;
                        NotifyCenter.publishEvent((Event)new InstancesChangeEvent(FailoverReactor.this.notifierEventScope, newService.getName(), newService.getGroupName(), newService.getClusters(), newService.getHosts(), diff));
                    }
                    FailoverReactor.this.serviceMap.clear();
                    FailoverReactor.this.failoverSwitchEnable = false;
                    FailoverReactor.this.failoverServiceCntMetricsClear();
                }
            }
            catch (Exception e) {
                LogUtils.NAMING_LOGGER.error("FailoverSwitchRefresher run err", (Throwable)e);
            }
        }
    }
}

