/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/billing.proto

package com.alibaba.nacos.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * Billing related configuration of the service.
 * The following example shows how to configure monitored resources and metrics
 * for billing, `consumer_destinations` is the only supported destination and
 * the monitored resources need at least one label key
 * `cloud.googleapis.com/location` to indicate the location of the billing
 * usage, using different monitored resources between monitoring and billing is
 * recommended so they can be evolved independently:
 *     monitored_resources:
 *     - type: library.googleapis.com/billing_branch
 *       labels:
 *       - key: cloud.googleapis.com/location
 *         description: |
 *           Predefined label to support billing location restriction.
 *       - key: city
 *         description: |
 *           Custom label to define the city where the library branch is located
 *           in.
 *       - key: name
 *         description: Custom label to define the name of the library branch.
 *     metrics:
 *     - name: library.googleapis.com/book/borrowed_count
 *       metric_kind: DELTA
 *       value_type: INT64
 *       unit: "1"
 *     billing:
 *       consumer_destinations:
 *       - monitored_resource: library.googleapis.com/billing_branch
 *         metrics:
 *         - library.googleapis.com/book/borrowed_count
 * </pre>
 *
 * Protobuf type {@code google.api.Billing}
 */
public final class Billing extends com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.Billing)
    BillingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Billing.newBuilder() to construct.
  private Billing(com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Billing() {
    consumerDestinations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Billing();
  }

  @java.lang.Override
  public final com.alibaba.nacos.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.BillingProto.internal_static_google_api_Billing_descriptor;
  }

  @java.lang.Override
  protected com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.BillingProto.internal_static_google_api_Billing_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.alibaba.nacos.shaded.com.google.api.Billing.class, com.alibaba.nacos.shaded.com.google.api.Billing.Builder.class);
  }

  public interface BillingDestinationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.Billing.BillingDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     *
     * @return The monitoredResource.
     */
    java.lang.String getMonitoredResource();
    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     *
     * @return The bytes for monitoredResource.
     */
    com.alibaba.nacos.shaded.com.google.protobuf.ByteString getMonitoredResourceBytes();

    /**
     *
     *
     * <pre>
     * Names of the metrics to report to this billing destination.
     * Each name must be defined in
     * [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return A list containing the metrics.
     */
    java.util.List<java.lang.String> getMetricsList();
    /**
     *
     *
     * <pre>
     * Names of the metrics to report to this billing destination.
     * Each name must be defined in
     * [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return The count of metrics.
     */
    int getMetricsCount();
    /**
     *
     *
     * <pre>
     * Names of the metrics to report to this billing destination.
     * Each name must be defined in
     * [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The metrics at the given index.
     */
    java.lang.String getMetrics(int index);
    /**
     *
     *
     * <pre>
     * Names of the metrics to report to this billing destination.
     * Each name must be defined in
     * [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metrics at the given index.
     */
    com.alibaba.nacos.shaded.com.google.protobuf.ByteString getMetricsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration of a specific billing destination (Currently only support
   * bill against consumer project).
   * </pre>
   *
   * Protobuf type {@code google.api.Billing.BillingDestination}
   */
  public static final class BillingDestination extends com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.api.Billing.BillingDestination)
      BillingDestinationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BillingDestination.newBuilder() to construct.
    private BillingDestination(com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BillingDestination() {
      monitoredResource_ = "";
      metrics_ = com.alibaba.nacos.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BillingDestination();
    }

    @java.lang.Override
    public final com.alibaba.nacos.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.BillingProto
          .internal_static_google_api_Billing_BillingDestination_descriptor;
    }

    @java.lang.Override
    protected com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.BillingProto
          .internal_static_google_api_Billing_BillingDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.class,
              com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder.class);
    }

    public static final int MONITORED_RESOURCE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object monitoredResource_ = "";
    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     *
     * @return The monitoredResource.
     */
    @java.lang.Override
    public java.lang.String getMonitoredResource() {
      java.lang.Object ref = monitoredResource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        monitoredResource_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     *
     * @return The bytes for monitoredResource.
     */
    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getMonitoredResourceBytes() {
      java.lang.Object ref = monitoredResource_;
      if (ref instanceof java.lang.String) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
            com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        monitoredResource_ = b;
        return b;
      } else {
        return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      }
    }

    public static final int METRICS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.alibaba.nacos.shaded.com.google.protobuf.LazyStringList metrics_;
    /**
     *
     *
     * <pre>
     * Names of the metrics to report to this billing destination.
     * Each name must be defined in
     * [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return A list containing the metrics.
     */
    public com.alibaba.nacos.shaded.com.google.protobuf.ProtocolStringList getMetricsList() {
      return metrics_;
    }
    /**
     *
     *
     * <pre>
     * Names of the metrics to report to this billing destination.
     * Each name must be defined in
     * [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return The count of metrics.
     */
    public int getMetricsCount() {
      return metrics_.size();
    }
    /**
     *
     *
     * <pre>
     * Names of the metrics to report to this billing destination.
     * Each name must be defined in
     * [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The metrics at the given index.
     */
    public java.lang.String getMetrics(int index) {
      return metrics_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Names of the metrics to report to this billing destination.
     * Each name must be defined in
     * [Service.metrics][google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metrics at the given index.
     */
    public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getMetricsBytes(int index) {
      return metrics_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.alibaba.nacos.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(monitoredResource_)) {
        com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, monitoredResource_);
      }
      for (int i = 0; i < metrics_.size(); i++) {
        com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metrics_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(monitoredResource_)) {
        size += com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, monitoredResource_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < metrics_.size(); i++) {
          dataSize += computeStringSizeNoTag(metrics_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getMetricsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.api.Billing.BillingDestination)) {
        return super.equals(obj);
      }
      com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination other =
          (com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination) obj;

      if (!getMonitoredResource().equals(other.getMonitoredResource())) return false;
      if (!getMetricsList().equals(other.getMetricsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MONITORED_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoredResource().hashCode();
      if (getMetricsCount() > 0) {
        hash = (37 * hash) + METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getMetricsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseFrom(java.nio.ByteBuffer data)
        throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseFrom(
        java.nio.ByteBuffer data, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseFrom(
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString data)
        throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseFrom(
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString data,
        com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseFrom(byte[] data)
        throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseFrom(
        byte[] data, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseFrom(
        java.io.InputStream input, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseDelimitedFrom(
        java.io.InputStream input, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseFrom(
        com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination parseFrom(
        com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input,
        com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration of a specific billing destination (Currently only support
     * bill against consumer project).
     * </pre>
     *
     * Protobuf type {@code google.api.Billing.BillingDestination}
     */
    public static final class Builder
        extends com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.Billing.BillingDestination)
        com.google.api.Billing.BillingDestinationOrBuilder {
      public static final com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.api.BillingProto
            .internal_static_google_api_Billing_BillingDestination_descriptor;
      }

      @java.lang.Override
      protected com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.BillingProto
            .internal_static_google_api_Billing_BillingDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.class,
                com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder.class);
      }

      // Construct using com.google.api.Billing.BillingDestination.newBuilder()
      private Builder() {}

      private Builder(com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        monitoredResource_ = "";
        metrics_ = com.alibaba.nacos.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.api.BillingProto
            .internal_static_google_api_Billing_BillingDestination_descriptor;
      }

      @java.lang.Override
      public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination getDefaultInstanceForType() {
        return com.google.api.Billing.BillingDestination.getDefaultInstance();
      }

      @java.lang.Override
      public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination build() {
        com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination buildPartial() {
        com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination result =
            new com.google.api.Billing.BillingDestination(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination result) {
        if (((bitField0_ & 0x00000002) != 0)) {
          metrics_ = metrics_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.metrics_ = metrics_;
      }

      private void buildPartial0(com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.monitoredResource_ = monitoredResource_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.alibaba.nacos.shaded.com.google.protobuf.Message other) {
        if (other instanceof com.google.api.Billing.BillingDestination) {
          return mergeFrom((com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination other) {
        if (other == com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.getDefaultInstance()) return this;
        if (!other.getMonitoredResource().isEmpty()) {
          monitoredResource_ = other.monitoredResource_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input,
          com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  monitoredResource_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureMetricsIsMutable();
                  metrics_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object monitoredResource_ = "";
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       *
       * @return The monitoredResource.
       */
      public java.lang.String getMonitoredResource() {
        java.lang.Object ref = monitoredResource_;
        if (!(ref instanceof java.lang.String)) {
          com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          monitoredResource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       *
       * @return The bytes for monitoredResource.
       */
      public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getMonitoredResourceBytes() {
        java.lang.Object ref = monitoredResource_;
        if (ref instanceof String) {
          com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
              com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          monitoredResource_ = b;
          return b;
        } else {
          return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       *
       * @param value The monitoredResource to set.
       * @return This builder for chaining.
       */
      public Builder setMonitoredResource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        monitoredResource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMonitoredResource() {
        monitoredResource_ = getDefaultInstance().getMonitoredResource();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       *
       * @param value The bytes for monitoredResource to set.
       * @return This builder for chaining.
       */
      public Builder setMonitoredResourceBytes(com.alibaba.nacos.shaded.com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        monitoredResource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.alibaba.nacos.shaded.com.google.protobuf.LazyStringList metrics_ =
          com.alibaba.nacos.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureMetricsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          metrics_ = new com.google.protobuf.LazyStringArrayList(metrics_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * Names of the metrics to report to this billing destination.
       * Each name must be defined in
       * [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @return A list containing the metrics.
       */
      public com.alibaba.nacos.shaded.com.google.protobuf.ProtocolStringList getMetricsList() {
        return metrics_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Names of the metrics to report to this billing destination.
       * Each name must be defined in
       * [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @return The count of metrics.
       */
      public int getMetricsCount() {
        return metrics_.size();
      }
      /**
       *
       *
       * <pre>
       * Names of the metrics to report to this billing destination.
       * Each name must be defined in
       * [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The metrics at the given index.
       */
      public java.lang.String getMetrics(int index) {
        return metrics_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Names of the metrics to report to this billing destination.
       * Each name must be defined in
       * [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the metrics at the given index.
       */
      public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getMetricsBytes(int index) {
        return metrics_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Names of the metrics to report to this billing destination.
       * Each name must be defined in
       * [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The metrics to set.
       * @return This builder for chaining.
       */
      public Builder setMetrics(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the metrics to report to this billing destination.
       * Each name must be defined in
       * [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param value The metrics to add.
       * @return This builder for chaining.
       */
      public Builder addMetrics(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the metrics to report to this billing destination.
       * Each name must be defined in
       * [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param values The metrics to add.
       * @return This builder for chaining.
       */
      public Builder addAllMetrics(java.lang.Iterable<java.lang.String> values) {
        ensureMetricsIsMutable();
        com.alibaba.nacos.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the metrics to report to this billing destination.
       * Each name must be defined in
       * [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetrics() {
        metrics_ = com.alibaba.nacos.shaded.com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the metrics to report to this billing destination.
       * Each name must be defined in
       * [Service.metrics][google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param value The bytes of the metrics to add.
       * @return This builder for chaining.
       */
      public Builder addMetricsBytes(com.alibaba.nacos.shaded.com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.alibaba.nacos.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.alibaba.nacos.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.api.Billing.BillingDestination)
    }

    // @@protoc_insertion_point(class_scope:google.api.Billing.BillingDestination)
    private static final com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.api.Billing.BillingDestination();
    }

    public static com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.alibaba.nacos.shaded.com.google.protobuf.Parser<BillingDestination> PARSER =
        new com.google.protobuf.AbstractParser<BillingDestination>() {
          @java.lang.Override
          public BillingDestination parsePartialFrom(
              com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input,
              com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.alibaba.nacos.shaded.com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.alibaba.nacos.shaded.com.google.protobuf.Parser<BillingDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.protobuf.Parser<BillingDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CONSUMER_DESTINATIONS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination> consumerDestinations_;
  /**
   *
   *
   * <pre>
   * Billing configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations per service, each one must have
   * a different monitored resource type. A metric can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination> getConsumerDestinationsList() {
    return consumerDestinations_;
  }
  /**
   *
   *
   * <pre>
   * Billing configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations per service, each one must have
   * a different monitored resource type. A metric can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestinationOrBuilder>
      getConsumerDestinationsOrBuilderList() {
    return consumerDestinations_;
  }
  /**
   *
   *
   * <pre>
   * Billing configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations per service, each one must have
   * a different monitored resource type. A metric can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
   */
  @java.lang.Override
  public int getConsumerDestinationsCount() {
    return consumerDestinations_.size();
  }
  /**
   *
   *
   * <pre>
   * Billing configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations per service, each one must have
   * a different monitored resource type. A metric can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
   */
  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination getConsumerDestinations(int index) {
    return consumerDestinations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Billing configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations per service, each one must have
   * a different monitored resource type. A metric can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
   */
  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestinationOrBuilder getConsumerDestinationsOrBuilder(
      int index) {
    return consumerDestinations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.alibaba.nacos.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < consumerDestinations_.size(); i++) {
      output.writeMessage(8, consumerDestinations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < consumerDestinations_.size(); i++) {
      size +=
          com.alibaba.nacos.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(8, consumerDestinations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.Billing)) {
      return super.equals(obj);
    }
    com.alibaba.nacos.shaded.com.google.api.Billing other = (com.alibaba.nacos.shaded.com.google.api.Billing) obj;

    if (!getConsumerDestinationsList().equals(other.getConsumerDestinationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getConsumerDestinationsCount() > 0) {
      hash = (37 * hash) + CONSUMER_DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerDestinationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseFrom(java.nio.ByteBuffer data)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseFrom(
      java.nio.ByteBuffer data, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseFrom(com.alibaba.nacos.shaded.com.google.protobuf.ByteString data)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseFrom(
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString data,
      com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseFrom(byte[] data)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseFrom(
      byte[] data, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseFrom(
      java.io.InputStream input, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseDelimitedFrom(
      java.io.InputStream input, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseFrom(com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing parseFrom(
      com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input,
      com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.alibaba.nacos.shaded.com.google.api.Billing prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Billing related configuration of the service.
   * The following example shows how to configure monitored resources and metrics
   * for billing, `consumer_destinations` is the only supported destination and
   * the monitored resources need at least one label key
   * `cloud.googleapis.com/location` to indicate the location of the billing
   * usage, using different monitored resources between monitoring and billing is
   * recommended so they can be evolved independently:
   *     monitored_resources:
   *     - type: library.googleapis.com/billing_branch
   *       labels:
   *       - key: cloud.googleapis.com/location
   *         description: |
   *           Predefined label to support billing location restriction.
   *       - key: city
   *         description: |
   *           Custom label to define the city where the library branch is located
   *           in.
   *       - key: name
   *         description: Custom label to define the name of the library branch.
   *     metrics:
   *     - name: library.googleapis.com/book/borrowed_count
   *       metric_kind: DELTA
   *       value_type: INT64
   *       unit: "1"
   *     billing:
   *       consumer_destinations:
   *       - monitored_resource: library.googleapis.com/billing_branch
   *         metrics:
   *         - library.googleapis.com/book/borrowed_count
   * </pre>
   *
   * Protobuf type {@code google.api.Billing}
   */
  public static final class Builder extends com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.Billing)
      com.google.api.BillingOrBuilder {
    public static final com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.BillingProto.internal_static_google_api_Billing_descriptor;
    }

    @java.lang.Override
    protected com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.BillingProto.internal_static_google_api_Billing_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.alibaba.nacos.shaded.com.google.api.Billing.class, com.alibaba.nacos.shaded.com.google.api.Billing.Builder.class);
    }

    // Construct using com.google.api.Billing.newBuilder()
    private Builder() {}

    private Builder(com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinations_ = java.util.Collections.emptyList();
      } else {
        consumerDestinations_ = null;
        consumerDestinationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.BillingProto.internal_static_google_api_Billing_descriptor;
    }

    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.api.Billing getDefaultInstanceForType() {
      return com.google.api.Billing.getDefaultInstance();
    }

    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.api.Billing build() {
      com.alibaba.nacos.shaded.com.google.api.Billing result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.api.Billing buildPartial() {
      com.alibaba.nacos.shaded.com.google.api.Billing result = new com.google.api.Billing(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.alibaba.nacos.shaded.com.google.api.Billing result) {
      if (consumerDestinationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          consumerDestinations_ = java.util.Collections.unmodifiableList(consumerDestinations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.consumerDestinations_ = consumerDestinations_;
      } else {
        result.consumerDestinations_ = consumerDestinationsBuilder_.build();
      }
    }

    private void buildPartial0(com.alibaba.nacos.shaded.com.google.api.Billing result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.alibaba.nacos.shaded.com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Billing) {
        return mergeFrom((com.alibaba.nacos.shaded.com.google.api.Billing) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.alibaba.nacos.shaded.com.google.api.Billing other) {
      if (other == com.alibaba.nacos.shaded.com.google.api.Billing.getDefaultInstance()) return this;
      if (consumerDestinationsBuilder_ == null) {
        if (!other.consumerDestinations_.isEmpty()) {
          if (consumerDestinations_.isEmpty()) {
            consumerDestinations_ = other.consumerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureConsumerDestinationsIsMutable();
            consumerDestinations_.addAll(other.consumerDestinations_);
          }
          onChanged();
        }
      } else {
        if (!other.consumerDestinations_.isEmpty()) {
          if (consumerDestinationsBuilder_.isEmpty()) {
            consumerDestinationsBuilder_.dispose();
            consumerDestinationsBuilder_ = null;
            consumerDestinations_ = other.consumerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            consumerDestinationsBuilder_ =
                com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConsumerDestinationsFieldBuilder()
                    : null;
          } else {
            consumerDestinationsBuilder_.addAllMessages(other.consumerDestinations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input,
        com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 66:
              {
                com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination m =
                    input.readMessage(
                        com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.parser(), extensionRegistry);
                if (consumerDestinationsBuilder_ == null) {
                  ensureConsumerDestinationsIsMutable();
                  consumerDestinations_.add(m);
                } else {
                  consumerDestinationsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination> consumerDestinations_ =
        java.util.Collections.emptyList();

    private void ensureConsumerDestinationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        consumerDestinations_ =
            new java.util.ArrayList<com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination>(
                consumerDestinations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.alibaba.nacos.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Billing.BillingDestination,
            com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder,
            com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestinationOrBuilder>
        consumerDestinationsBuilder_;

    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public java.util.List<com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination> getConsumerDestinationsList() {
      if (consumerDestinationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(consumerDestinations_);
      } else {
        return consumerDestinationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public int getConsumerDestinationsCount() {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.size();
      } else {
        return consumerDestinationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination getConsumerDestinations(int index) {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.get(index);
      } else {
        return consumerDestinationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public Builder setConsumerDestinations(
        int index, com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.set(index, value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public Builder setConsumerDestinations(
        int index, com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.set(index, builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public Builder addConsumerDestinations(com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public Builder addConsumerDestinations(
        int index, com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(index, value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public Builder addConsumerDestinations(
        com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public Builder addConsumerDestinations(
        int index, com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(index, builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public Builder addAllConsumerDestinations(
        java.lang.Iterable<? extends com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination> values) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        com.alibaba.nacos.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, consumerDestinations_);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public Builder clearConsumerDestinations() {
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        consumerDestinationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public Builder removeConsumerDestinations(int index) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.remove(index);
        onChanged();
      } else {
        consumerDestinationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder getConsumerDestinationsBuilder(
        int index) {
      return getConsumerDestinationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestinationOrBuilder getConsumerDestinationsOrBuilder(
        int index) {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.get(index);
      } else {
        return consumerDestinationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public java.util.List<? extends com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestinationOrBuilder>
        getConsumerDestinationsOrBuilderList() {
      if (consumerDestinationsBuilder_ != null) {
        return consumerDestinationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(consumerDestinations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder addConsumerDestinationsBuilder() {
      return getConsumerDestinationsFieldBuilder()
          .addBuilder(com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder addConsumerDestinationsBuilder(
        int index) {
      return getConsumerDestinationsFieldBuilder()
          .addBuilder(index, com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Billing configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations per service, each one must have
     * a different monitored resource type. A metric can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Billing.BillingDestination consumer_destinations = 8;</code>
     */
    public java.util.List<com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder>
        getConsumerDestinationsBuilderList() {
      return getConsumerDestinationsFieldBuilder().getBuilderList();
    }

    private com.alibaba.nacos.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Billing.BillingDestination,
            com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder,
            com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestinationOrBuilder>
        getConsumerDestinationsFieldBuilder() {
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.Billing.BillingDestination,
                com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestination.Builder,
                com.alibaba.nacos.shaded.com.google.api.Billing.BillingDestinationOrBuilder>(
                consumerDestinations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        consumerDestinations_ = null;
      }
      return consumerDestinationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.alibaba.nacos.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.alibaba.nacos.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.Billing)
  }

  // @@protoc_insertion_point(class_scope:google.api.Billing)
  private static final com.alibaba.nacos.shaded.com.google.api.Billing DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.Billing();
  }

  public static com.alibaba.nacos.shaded.com.google.api.Billing getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.alibaba.nacos.shaded.com.google.protobuf.Parser<Billing> PARSER =
      new com.google.protobuf.AbstractParser<Billing>() {
        @java.lang.Override
        public Billing parsePartialFrom(
            com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input,
            com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.alibaba.nacos.shaded.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.alibaba.nacos.shaded.com.google.protobuf.Parser<Billing> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.protobuf.Parser<Billing> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.api.Billing getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
