/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/quota.proto

package com.alibaba.nacos.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * `QuotaLimit` defines a specific limit that applies over a specified duration
 * for a limit type. There can be at most one limit for a duration and limit
 * type combination defined within a `QuotaGroup`.
 * </pre>
 *
 * Protobuf type {@code google.api.QuotaLimit}
 */
public final class QuotaLimit extends com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.QuotaLimit)
    QuotaLimitOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QuotaLimit.newBuilder() to construct.
  private QuotaLimit(com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QuotaLimit() {
    name_ = "";
    description_ = "";
    duration_ = "";
    metric_ = "";
    unit_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QuotaLimit();
  }

  @java.lang.Override
  public final com.alibaba.nacos.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.alibaba.nacos.shaded.com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 10:
        return internalGetValues();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.alibaba.nacos.shaded.com.google.api.QuotaLimit.class, com.alibaba.nacos.shaded.com.google.api.QuotaLimit.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the quota limit.
   * The name must be provided, and it must be unique within the service. The
   * name can only include alphanumeric characters as well as '-'.
   * The maximum length of the limit name is 64 characters.
   * </pre>
   *
   * <code>string name = 6;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the quota limit.
   * The name must be provided, and it must be unique within the service. The
   * name can only include alphanumeric characters as well as '-'.
   * The maximum length of the limit name is 64 characters.
   * </pre>
   *
   * <code>string name = 6;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
          com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. User-visible, extended description for this quota limit.
   * Should be used only when more context is needed to understand this limit
   * than provided by the limit's display name (see: `display_name`).
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. User-visible, extended description for this quota limit.
   * Should be used only when more context is needed to understand this limit
   * than provided by the limit's display name (see: `display_name`).
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
          com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_LIMIT_FIELD_NUMBER = 3;
  private long defaultLimit_ = 0L;
  /**
   *
   *
   * <pre>
   * Default number of tokens that can be consumed during the specified
   * duration. This is the number of tokens assigned when a client
   * application developer activates the service for his/her project.
   * Specifying a value of 0 will block all requests. This can be used if you
   * are provisioning quota to selected consumers and blocking others.
   * Similarly, a value of -1 will indicate an unlimited quota. No other
   * negative values are allowed.
   * Used by group-based quotas only.
   * </pre>
   *
   * <code>int64 default_limit = 3;</code>
   *
   * @return The defaultLimit.
   */
  @java.lang.Override
  public long getDefaultLimit() {
    return defaultLimit_;
  }

  public static final int MAX_LIMIT_FIELD_NUMBER = 4;
  private long maxLimit_ = 0L;
  /**
   *
   *
   * <pre>
   * Maximum number of tokens that can be consumed during the specified
   * duration. Client application developers can override the default limit up
   * to this maximum. If specified, this value cannot be set to a value less
   * than the default limit. If not specified, it is set to the default limit.
   * To allow clients to apply overrides with no upper bound, set this to -1,
   * indicating unlimited maximum quota.
   * Used by group-based quotas only.
   * </pre>
   *
   * <code>int64 max_limit = 4;</code>
   *
   * @return The maxLimit.
   */
  @java.lang.Override
  public long getMaxLimit() {
    return maxLimit_;
  }

  public static final int FREE_TIER_FIELD_NUMBER = 7;
  private long freeTier_ = 0L;
  /**
   *
   *
   * <pre>
   * Free tier value displayed in the Developers Console for this limit.
   * The free tier is the number of tokens that will be subtracted from the
   * billed amount when billing is enabled.
   * This field can only be set on a limit with duration "1d", in a billable
   * group; it is invalid on any other limit. If this field is not set, it
   * defaults to 0, indicating that there is no free tier for this service.
   * Used by group-based quotas only.
   * </pre>
   *
   * <code>int64 free_tier = 7;</code>
   *
   * @return The freeTier.
   */
  @java.lang.Override
  public long getFreeTier() {
    return freeTier_;
  }

  public static final int DURATION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object duration_ = "";
  /**
   *
   *
   * <pre>
   * Duration of this limit in textual notation. Must be "100s" or "1d".
   * Used by group-based quotas only.
   * </pre>
   *
   * <code>string duration = 5;</code>
   *
   * @return The duration.
   */
  @java.lang.Override
  public java.lang.String getDuration() {
    java.lang.Object ref = duration_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      duration_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Duration of this limit in textual notation. Must be "100s" or "1d".
   * Used by group-based quotas only.
   * </pre>
   *
   * <code>string duration = 5;</code>
   *
   * @return The bytes for duration.
   */
  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getDurationBytes() {
    java.lang.Object ref = duration_;
    if (ref instanceof java.lang.String) {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
          com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      duration_ = b;
      return b;
    } else {
      return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRIC_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metric_ = "";
  /**
   *
   *
   * <pre>
   * The name of the metric this quota limit applies to. The quota limits with
   * the same metric will be checked together during runtime. The metric must be
   * defined within the service config.
   * </pre>
   *
   * <code>string metric = 8;</code>
   *
   * @return The metric.
   */
  @java.lang.Override
  public java.lang.String getMetric() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metric_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the metric this quota limit applies to. The quota limits with
   * the same metric will be checked together during runtime. The metric must be
   * defined within the service config.
   * </pre>
   *
   * <code>string metric = 8;</code>
   *
   * @return The bytes for metric.
   */
  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getMetricBytes() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
          com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metric_ = b;
      return b;
    } else {
      return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNIT_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object unit_ = "";
  /**
   *
   *
   * <pre>
   * Specify the unit of the quota limit. It uses the same syntax as
   * [Metric.unit][]. The supported unit kinds are determined by the quota
   * backend system.
   * Here are some examples:
   * * "1/min/{project}" for quota per minute per project.
   * Note: the order of unit components is insignificant.
   * The "1" at the beginning is required to follow the metric unit syntax.
   * </pre>
   *
   * <code>string unit = 9;</code>
   *
   * @return The unit.
   */
  @java.lang.Override
  public java.lang.String getUnit() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      unit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specify the unit of the quota limit. It uses the same syntax as
   * [Metric.unit][]. The supported unit kinds are determined by the quota
   * backend system.
   * Here are some examples:
   * * "1/min/{project}" for quota per minute per project.
   * Note: the order of unit components is insignificant.
   * The "1" at the beginning is required to follow the metric unit syntax.
   * </pre>
   *
   * <code>string unit = 9;</code>
   *
   * @return The bytes for unit.
   */
  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getUnitBytes() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
          com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      unit_ = b;
      return b;
    } else {
      return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUES_FIELD_NUMBER = 10;

  private static final class ValuesDefaultEntryHolder {
    static final com.alibaba.nacos.shaded.com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> defaultEntry =
        com.alibaba.nacos.shaded.com.google.protobuf.MapEntry.<java.lang.String, java.lang.Long>newDefaultInstance(
            com.alibaba.nacos.shaded.com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_ValuesEntry_descriptor,
            com.alibaba.nacos.shaded.com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.alibaba.nacos.shaded.com.google.protobuf.WireFormat.FieldType.INT64,
            0L);
  }

  @SuppressWarnings("serial")
  private com.alibaba.nacos.shaded.com.google.protobuf.MapField<java.lang.String, java.lang.Long> values_;

  private com.alibaba.nacos.shaded.com.google.protobuf.MapField<java.lang.String, java.lang.Long> internalGetValues() {
    if (values_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ValuesDefaultEntryHolder.defaultEntry);
    }
    return values_;
  }

  public int getValuesCount() {
    return internalGetValues().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Tiered limit values. You must specify this as a key:value pair, with an
   * integer value that is the maximum number of requests allowed for the
   * specified unit. Currently only STANDARD is supported.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; values = 10;</code>
   */
  @java.lang.Override
  public boolean containsValues(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetValues().getMap().containsKey(key);
  }
  /** Use {@link #getValuesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Long> getValues() {
    return getValuesMap();
  }
  /**
   *
   *
   * <pre>
   * Tiered limit values. You must specify this as a key:value pair, with an
   * integer value that is the maximum number of requests allowed for the
   * specified unit. Currently only STANDARD is supported.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; values = 10;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Long> getValuesMap() {
    return internalGetValues().getMap();
  }
  /**
   *
   *
   * <pre>
   * Tiered limit values. You must specify this as a key:value pair, with an
   * integer value that is the maximum number of requests allowed for the
   * specified unit. Currently only STANDARD is supported.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; values = 10;</code>
   */
  @java.lang.Override
  public long getValuesOrDefault(java.lang.String key, long defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Long> map = internalGetValues().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Tiered limit values. You must specify this as a key:value pair, with an
   * integer value that is the maximum number of requests allowed for the
   * specified unit. Currently only STANDARD is supported.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; values = 10;</code>
   */
  @java.lang.Override
  public long getValuesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Long> map = internalGetValues().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User-visible display name for this limit.
   * Optional. If not set, the UI will provide a default display name based on
   * the quota configuration. This field can be used to override the default
   * display name generated from the configuration.
   * </pre>
   *
   * <code>string display_name = 12;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-visible display name for this limit.
   * Optional. If not set, the UI will provide a default display name based on
   * the quota configuration. This field can be used to override the default
   * display name generated from the configuration.
   * </pre>
   *
   * <code>string display_name = 12;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
          com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.alibaba.nacos.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (defaultLimit_ != 0L) {
      output.writeInt64(3, defaultLimit_);
    }
    if (maxLimit_ != 0L) {
      output.writeInt64(4, maxLimit_);
    }
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(duration_)) {
      com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 5, duration_);
    }
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 6, name_);
    }
    if (freeTier_ != 0L) {
      output.writeInt64(7, freeTier_);
    }
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 8, metric_);
    }
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 9, unit_);
    }
    com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetValues(), ValuesDefaultEntryHolder.defaultEntry, 10);
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 12, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (defaultLimit_ != 0L) {
      size += com.alibaba.nacos.shaded.com.google.protobuf.CodedOutputStream.computeInt64Size(3, defaultLimit_);
    }
    if (maxLimit_ != 0L) {
      size += com.alibaba.nacos.shaded.com.google.protobuf.CodedOutputStream.computeInt64Size(4, maxLimit_);
    }
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(duration_)) {
      size += com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(5, duration_);
    }
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(6, name_);
    }
    if (freeTier_ != 0L) {
      size += com.alibaba.nacos.shaded.com.google.protobuf.CodedOutputStream.computeInt64Size(7, freeTier_);
    }
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      size += com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(8, metric_);
    }
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      size += com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(9, unit_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Long> entry :
        internalGetValues().getMap().entrySet()) {
      com.alibaba.nacos.shaded.com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> values__ =
          ValuesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.alibaba.nacos.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(10, values__);
    }
    if (!com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(12, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.QuotaLimit)) {
      return super.equals(obj);
    }
    com.alibaba.nacos.shaded.com.google.api.QuotaLimit other = (com.alibaba.nacos.shaded.com.google.api.QuotaLimit) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getDefaultLimit() != other.getDefaultLimit()) return false;
    if (getMaxLimit() != other.getMaxLimit()) return false;
    if (getFreeTier() != other.getFreeTier()) return false;
    if (!getDuration().equals(other.getDuration())) return false;
    if (!getMetric().equals(other.getMetric())) return false;
    if (!getUnit().equals(other.getUnit())) return false;
    if (!internalGetValues().equals(other.internalGetValues())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + DEFAULT_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDefaultLimit());
    hash = (37 * hash) + MAX_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxLimit());
    hash = (37 * hash) + FREE_TIER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFreeTier());
    hash = (37 * hash) + DURATION_FIELD_NUMBER;
    hash = (53 * hash) + getDuration().hashCode();
    hash = (37 * hash) + METRIC_FIELD_NUMBER;
    hash = (53 * hash) + getMetric().hashCode();
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUnit().hashCode();
    if (!internalGetValues().getMap().isEmpty()) {
      hash = (37 * hash) + VALUES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetValues().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseFrom(java.nio.ByteBuffer data)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseFrom(
      java.nio.ByteBuffer data, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseFrom(com.alibaba.nacos.shaded.com.google.protobuf.ByteString data)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseFrom(
      com.alibaba.nacos.shaded.com.google.protobuf.ByteString data,
      com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseFrom(byte[] data)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseFrom(
      byte[] data, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseFrom(
      java.io.InputStream input, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseDelimitedFrom(
      java.io.InputStream input, com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseFrom(com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit parseFrom(
      com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input,
      com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.alibaba.nacos.shaded.com.google.api.QuotaLimit prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `QuotaLimit` defines a specific limit that applies over a specified duration
   * for a limit type. There can be at most one limit for a duration and limit
   * type combination defined within a `QuotaGroup`.
   * </pre>
   *
   * Protobuf type {@code google.api.QuotaLimit}
   */
  public static final class Builder extends com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.QuotaLimit)
      com.google.api.QuotaLimitOrBuilder {
    public static final com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.alibaba.nacos.shaded.com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 10:
          return internalGetValues();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.alibaba.nacos.shaded.com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 10:
          return internalGetMutableValues();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.alibaba.nacos.shaded.com.google.api.QuotaLimit.class, com.alibaba.nacos.shaded.com.google.api.QuotaLimit.Builder.class);
    }

    // Construct using com.google.api.QuotaLimit.newBuilder()
    private Builder() {}

    private Builder(com.alibaba.nacos.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      defaultLimit_ = 0L;
      maxLimit_ = 0L;
      freeTier_ = 0L;
      duration_ = "";
      metric_ = "";
      unit_ = "";
      internalGetMutableValues().clear();
      displayName_ = "";
      return this;
    }

    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.QuotaProto.internal_static_google_api_QuotaLimit_descriptor;
    }

    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.api.QuotaLimit getDefaultInstanceForType() {
      return com.google.api.QuotaLimit.getDefaultInstance();
    }

    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.api.QuotaLimit build() {
      com.alibaba.nacos.shaded.com.google.api.QuotaLimit result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.alibaba.nacos.shaded.com.google.api.QuotaLimit buildPartial() {
      com.alibaba.nacos.shaded.com.google.api.QuotaLimit result = new com.google.api.QuotaLimit(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.alibaba.nacos.shaded.com.google.api.QuotaLimit result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.defaultLimit_ = defaultLimit_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.maxLimit_ = maxLimit_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.freeTier_ = freeTier_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.duration_ = duration_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.metric_ = metric_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.unit_ = unit_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.values_ = internalGetValues();
        result.values_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.displayName_ = displayName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.alibaba.nacos.shaded.com.google.protobuf.Message other) {
      if (other instanceof com.google.api.QuotaLimit) {
        return mergeFrom((com.alibaba.nacos.shaded.com.google.api.QuotaLimit) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.alibaba.nacos.shaded.com.google.api.QuotaLimit other) {
      if (other == com.alibaba.nacos.shaded.com.google.api.QuotaLimit.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getDefaultLimit() != 0L) {
        setDefaultLimit(other.getDefaultLimit());
      }
      if (other.getMaxLimit() != 0L) {
        setMaxLimit(other.getMaxLimit());
      }
      if (other.getFreeTier() != 0L) {
        setFreeTier(other.getFreeTier());
      }
      if (!other.getDuration().isEmpty()) {
        duration_ = other.duration_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getMetric().isEmpty()) {
        metric_ = other.metric_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getUnit().isEmpty()) {
        unit_ = other.unit_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      internalGetMutableValues().mergeFrom(other.internalGetValues());
      bitField0_ |= 0x00000100;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input,
        com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                defaultLimit_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                maxLimit_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                duration_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 50
            case 56:
              {
                freeTier_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 56
            case 66:
              {
                metric_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                unit_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                com.alibaba.nacos.shaded.com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> values__ =
                    input.readMessage(
                        ValuesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableValues()
                    .getMutableMap()
                    .put(values__.getKey(), values__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 98:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the quota limit.
     * The name must be provided, and it must be unique within the service. The
     * name can only include alphanumeric characters as well as '-'.
     * The maximum length of the limit name is 64 characters.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the quota limit.
     * The name must be provided, and it must be unique within the service. The
     * name can only include alphanumeric characters as well as '-'.
     * The maximum length of the limit name is 64 characters.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return The bytes for name.
     */
    public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
            com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the quota limit.
     * The name must be provided, and it must be unique within the service. The
     * name can only include alphanumeric characters as well as '-'.
     * The maximum length of the limit name is 64 characters.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the quota limit.
     * The name must be provided, and it must be unique within the service. The
     * name can only include alphanumeric characters as well as '-'.
     * The maximum length of the limit name is 64 characters.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the quota limit.
     * The name must be provided, and it must be unique within the service. The
     * name can only include alphanumeric characters as well as '-'.
     * The maximum length of the limit name is 64 characters.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.alibaba.nacos.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. User-visible, extended description for this quota limit.
     * Should be used only when more context is needed to understand this limit
     * than provided by the limit's display name (see: `display_name`).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-visible, extended description for this quota limit.
     * Should be used only when more context is needed to understand this limit
     * than provided by the limit's display name (see: `display_name`).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
            com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-visible, extended description for this quota limit.
     * Should be used only when more context is needed to understand this limit
     * than provided by the limit's display name (see: `display_name`).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-visible, extended description for this quota limit.
     * Should be used only when more context is needed to understand this limit
     * than provided by the limit's display name (see: `display_name`).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-visible, extended description for this quota limit.
     * Should be used only when more context is needed to understand this limit
     * than provided by the limit's display name (see: `display_name`).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.alibaba.nacos.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long defaultLimit_;
    /**
     *
     *
     * <pre>
     * Default number of tokens that can be consumed during the specified
     * duration. This is the number of tokens assigned when a client
     * application developer activates the service for his/her project.
     * Specifying a value of 0 will block all requests. This can be used if you
     * are provisioning quota to selected consumers and blocking others.
     * Similarly, a value of -1 will indicate an unlimited quota. No other
     * negative values are allowed.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 default_limit = 3;</code>
     *
     * @return The defaultLimit.
     */
    @java.lang.Override
    public long getDefaultLimit() {
      return defaultLimit_;
    }
    /**
     *
     *
     * <pre>
     * Default number of tokens that can be consumed during the specified
     * duration. This is the number of tokens assigned when a client
     * application developer activates the service for his/her project.
     * Specifying a value of 0 will block all requests. This can be used if you
     * are provisioning quota to selected consumers and blocking others.
     * Similarly, a value of -1 will indicate an unlimited quota. No other
     * negative values are allowed.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 default_limit = 3;</code>
     *
     * @param value The defaultLimit to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLimit(long value) {

      defaultLimit_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default number of tokens that can be consumed during the specified
     * duration. This is the number of tokens assigned when a client
     * application developer activates the service for his/her project.
     * Specifying a value of 0 will block all requests. This can be used if you
     * are provisioning quota to selected consumers and blocking others.
     * Similarly, a value of -1 will indicate an unlimited quota. No other
     * negative values are allowed.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 default_limit = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultLimit() {
      bitField0_ = (bitField0_ & ~0x00000004);
      defaultLimit_ = 0L;
      onChanged();
      return this;
    }

    private long maxLimit_;
    /**
     *
     *
     * <pre>
     * Maximum number of tokens that can be consumed during the specified
     * duration. Client application developers can override the default limit up
     * to this maximum. If specified, this value cannot be set to a value less
     * than the default limit. If not specified, it is set to the default limit.
     * To allow clients to apply overrides with no upper bound, set this to -1,
     * indicating unlimited maximum quota.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 max_limit = 4;</code>
     *
     * @return The maxLimit.
     */
    @java.lang.Override
    public long getMaxLimit() {
      return maxLimit_;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of tokens that can be consumed during the specified
     * duration. Client application developers can override the default limit up
     * to this maximum. If specified, this value cannot be set to a value less
     * than the default limit. If not specified, it is set to the default limit.
     * To allow clients to apply overrides with no upper bound, set this to -1,
     * indicating unlimited maximum quota.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 max_limit = 4;</code>
     *
     * @param value The maxLimit to set.
     * @return This builder for chaining.
     */
    public Builder setMaxLimit(long value) {

      maxLimit_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of tokens that can be consumed during the specified
     * duration. Client application developers can override the default limit up
     * to this maximum. If specified, this value cannot be set to a value less
     * than the default limit. If not specified, it is set to the default limit.
     * To allow clients to apply overrides with no upper bound, set this to -1,
     * indicating unlimited maximum quota.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 max_limit = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxLimit() {
      bitField0_ = (bitField0_ & ~0x00000008);
      maxLimit_ = 0L;
      onChanged();
      return this;
    }

    private long freeTier_;
    /**
     *
     *
     * <pre>
     * Free tier value displayed in the Developers Console for this limit.
     * The free tier is the number of tokens that will be subtracted from the
     * billed amount when billing is enabled.
     * This field can only be set on a limit with duration "1d", in a billable
     * group; it is invalid on any other limit. If this field is not set, it
     * defaults to 0, indicating that there is no free tier for this service.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 free_tier = 7;</code>
     *
     * @return The freeTier.
     */
    @java.lang.Override
    public long getFreeTier() {
      return freeTier_;
    }
    /**
     *
     *
     * <pre>
     * Free tier value displayed in the Developers Console for this limit.
     * The free tier is the number of tokens that will be subtracted from the
     * billed amount when billing is enabled.
     * This field can only be set on a limit with duration "1d", in a billable
     * group; it is invalid on any other limit. If this field is not set, it
     * defaults to 0, indicating that there is no free tier for this service.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 free_tier = 7;</code>
     *
     * @param value The freeTier to set.
     * @return This builder for chaining.
     */
    public Builder setFreeTier(long value) {

      freeTier_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free tier value displayed in the Developers Console for this limit.
     * The free tier is the number of tokens that will be subtracted from the
     * billed amount when billing is enabled.
     * This field can only be set on a limit with duration "1d", in a billable
     * group; it is invalid on any other limit. If this field is not set, it
     * defaults to 0, indicating that there is no free tier for this service.
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>int64 free_tier = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFreeTier() {
      bitField0_ = (bitField0_ & ~0x00000010);
      freeTier_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object duration_ = "";
    /**
     *
     *
     * <pre>
     * Duration of this limit in textual notation. Must be "100s" or "1d".
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>string duration = 5;</code>
     *
     * @return The duration.
     */
    public java.lang.String getDuration() {
      java.lang.Object ref = duration_;
      if (!(ref instanceof java.lang.String)) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        duration_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Duration of this limit in textual notation. Must be "100s" or "1d".
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>string duration = 5;</code>
     *
     * @return The bytes for duration.
     */
    public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getDurationBytes() {
      java.lang.Object ref = duration_;
      if (ref instanceof String) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
            com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        duration_ = b;
        return b;
      } else {
        return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Duration of this limit in textual notation. Must be "100s" or "1d".
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>string duration = 5;</code>
     *
     * @param value The duration to set.
     * @return This builder for chaining.
     */
    public Builder setDuration(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      duration_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration of this limit in textual notation. Must be "100s" or "1d".
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>string duration = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDuration() {
      duration_ = getDefaultInstance().getDuration();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration of this limit in textual notation. Must be "100s" or "1d".
     * Used by group-based quotas only.
     * </pre>
     *
     * <code>string duration = 5;</code>
     *
     * @param value The bytes for duration to set.
     * @return This builder for chaining.
     */
    public Builder setDurationBytes(com.alibaba.nacos.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      duration_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object metric_ = "";
    /**
     *
     *
     * <pre>
     * The name of the metric this quota limit applies to. The quota limits with
     * the same metric will be checked together during runtime. The metric must be
     * defined within the service config.
     * </pre>
     *
     * <code>string metric = 8;</code>
     *
     * @return The metric.
     */
    public java.lang.String getMetric() {
      java.lang.Object ref = metric_;
      if (!(ref instanceof java.lang.String)) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metric_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the metric this quota limit applies to. The quota limits with
     * the same metric will be checked together during runtime. The metric must be
     * defined within the service config.
     * </pre>
     *
     * <code>string metric = 8;</code>
     *
     * @return The bytes for metric.
     */
    public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getMetricBytes() {
      java.lang.Object ref = metric_;
      if (ref instanceof String) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
            com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metric_ = b;
        return b;
      } else {
        return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the metric this quota limit applies to. The quota limits with
     * the same metric will be checked together during runtime. The metric must be
     * defined within the service config.
     * </pre>
     *
     * <code>string metric = 8;</code>
     *
     * @param value The metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetric(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metric_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the metric this quota limit applies to. The quota limits with
     * the same metric will be checked together during runtime. The metric must be
     * defined within the service config.
     * </pre>
     *
     * <code>string metric = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetric() {
      metric_ = getDefaultInstance().getMetric();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the metric this quota limit applies to. The quota limits with
     * the same metric will be checked together during runtime. The metric must be
     * defined within the service config.
     * </pre>
     *
     * <code>string metric = 8;</code>
     *
     * @param value The bytes for metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetricBytes(com.alibaba.nacos.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metric_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object unit_ = "";
    /**
     *
     *
     * <pre>
     * Specify the unit of the quota limit. It uses the same syntax as
     * [Metric.unit][]. The supported unit kinds are determined by the quota
     * backend system.
     * Here are some examples:
     * * "1/min/{project}" for quota per minute per project.
     * Note: the order of unit components is insignificant.
     * The "1" at the beginning is required to follow the metric unit syntax.
     * </pre>
     *
     * <code>string unit = 9;</code>
     *
     * @return The unit.
     */
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (!(ref instanceof java.lang.String)) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the unit of the quota limit. It uses the same syntax as
     * [Metric.unit][]. The supported unit kinds are determined by the quota
     * backend system.
     * Here are some examples:
     * * "1/min/{project}" for quota per minute per project.
     * Note: the order of unit components is insignificant.
     * The "1" at the beginning is required to follow the metric unit syntax.
     * </pre>
     *
     * <code>string unit = 9;</code>
     *
     * @return The bytes for unit.
     */
    public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof String) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
            com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the unit of the quota limit. It uses the same syntax as
     * [Metric.unit][]. The supported unit kinds are determined by the quota
     * backend system.
     * Here are some examples:
     * * "1/min/{project}" for quota per minute per project.
     * Note: the order of unit components is insignificant.
     * The "1" at the beginning is required to follow the metric unit syntax.
     * </pre>
     *
     * <code>string unit = 9;</code>
     *
     * @param value The unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      unit_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the unit of the quota limit. It uses the same syntax as
     * [Metric.unit][]. The supported unit kinds are determined by the quota
     * backend system.
     * Here are some examples:
     * * "1/min/{project}" for quota per minute per project.
     * Note: the order of unit components is insignificant.
     * The "1" at the beginning is required to follow the metric unit syntax.
     * </pre>
     *
     * <code>string unit = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnit() {
      unit_ = getDefaultInstance().getUnit();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the unit of the quota limit. It uses the same syntax as
     * [Metric.unit][]. The supported unit kinds are determined by the quota
     * backend system.
     * Here are some examples:
     * * "1/min/{project}" for quota per minute per project.
     * Note: the order of unit components is insignificant.
     * The "1" at the beginning is required to follow the metric unit syntax.
     * </pre>
     *
     * <code>string unit = 9;</code>
     *
     * @param value The bytes for unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnitBytes(com.alibaba.nacos.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      unit_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.alibaba.nacos.shaded.com.google.protobuf.MapField<java.lang.String, java.lang.Long> values_;

    private com.alibaba.nacos.shaded.com.google.protobuf.MapField<java.lang.String, java.lang.Long> internalGetValues() {
      if (values_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ValuesDefaultEntryHolder.defaultEntry);
      }
      return values_;
    }

    private com.alibaba.nacos.shaded.com.google.protobuf.MapField<java.lang.String, java.lang.Long>
        internalGetMutableValues() {
      if (values_ == null) {
        values_ = com.alibaba.nacos.shaded.com.google.protobuf.MapField.newMapField(ValuesDefaultEntryHolder.defaultEntry);
      }
      if (!values_.isMutable()) {
        values_ = values_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return values_;
    }

    public int getValuesCount() {
      return internalGetValues().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Tiered limit values. You must specify this as a key:value pair, with an
     * integer value that is the maximum number of requests allowed for the
     * specified unit. Currently only STANDARD is supported.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */
    @java.lang.Override
    public boolean containsValues(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetValues().getMap().containsKey(key);
    }
    /** Use {@link #getValuesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getValues() {
      return getValuesMap();
    }
    /**
     *
     *
     * <pre>
     * Tiered limit values. You must specify this as a key:value pair, with an
     * integer value that is the maximum number of requests allowed for the
     * specified unit. Currently only STANDARD is supported.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Long> getValuesMap() {
      return internalGetValues().getMap();
    }
    /**
     *
     *
     * <pre>
     * Tiered limit values. You must specify this as a key:value pair, with an
     * integer value that is the maximum number of requests allowed for the
     * specified unit. Currently only STANDARD is supported.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */
    @java.lang.Override
    public long getValuesOrDefault(java.lang.String key, long defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetValues().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Tiered limit values. You must specify this as a key:value pair, with an
     * integer value that is the maximum number of requests allowed for the
     * specified unit. Currently only STANDARD is supported.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */
    @java.lang.Override
    public long getValuesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetValues().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearValues() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableValues().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tiered limit values. You must specify this as a key:value pair, with an
     * integer value that is the maximum number of requests allowed for the
     * specified unit. Currently only STANDARD is supported.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */
    public Builder removeValues(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableValues().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getMutableValues() {
      bitField0_ |= 0x00000100;
      return internalGetMutableValues().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Tiered limit values. You must specify this as a key:value pair, with an
     * integer value that is the maximum number of requests allowed for the
     * specified unit. Currently only STANDARD is supported.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */
    public Builder putValues(java.lang.String key, long value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableValues().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tiered limit values. You must specify this as a key:value pair, with an
     * integer value that is the maximum number of requests allowed for the
     * specified unit. Currently only STANDARD is supported.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; values = 10;</code>
     */
    public Builder putAllValues(java.util.Map<java.lang.String, java.lang.Long> values) {
      internalGetMutableValues().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User-visible display name for this limit.
     * Optional. If not set, the UI will provide a default display name based on
     * the quota configuration. This field can be used to override the default
     * display name generated from the configuration.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString bs = (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-visible display name for this limit.
     * Optional. If not set, the UI will provide a default display name based on
     * the quota configuration. This field can be used to override the default
     * display name generated from the configuration.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     *
     * @return The bytes for displayName.
     */
    public com.alibaba.nacos.shaded.com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.alibaba.nacos.shaded.com.google.protobuf.ByteString b =
            com.alibaba.nacos.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.alibaba.nacos.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-visible display name for this limit.
     * Optional. If not set, the UI will provide a default display name based on
     * the quota configuration. This field can be used to override the default
     * display name generated from the configuration.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-visible display name for this limit.
     * Optional. If not set, the UI will provide a default display name based on
     * the quota configuration. This field can be used to override the default
     * display name generated from the configuration.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-visible display name for this limit.
     * Optional. If not set, the UI will provide a default display name based on
     * the quota configuration. This field can be used to override the default
     * display name generated from the configuration.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.alibaba.nacos.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.alibaba.nacos.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.alibaba.nacos.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.QuotaLimit)
  }

  // @@protoc_insertion_point(class_scope:google.api.QuotaLimit)
  private static final com.alibaba.nacos.shaded.com.google.api.QuotaLimit DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.QuotaLimit();
  }

  public static com.alibaba.nacos.shaded.com.google.api.QuotaLimit getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.alibaba.nacos.shaded.com.google.protobuf.Parser<QuotaLimit> PARSER =
      new com.google.protobuf.AbstractParser<QuotaLimit>() {
        @java.lang.Override
        public QuotaLimit parsePartialFrom(
            com.alibaba.nacos.shaded.com.google.protobuf.CodedInputStream input,
            com.alibaba.nacos.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.alibaba.nacos.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.alibaba.nacos.shaded.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.alibaba.nacos.shaded.com.google.protobuf.Parser<QuotaLimit> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.protobuf.Parser<QuotaLimit> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.alibaba.nacos.shaded.com.google.api.QuotaLimit getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
