/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.lock;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.lock.LockService;
import com.alibaba.nacos.api.lock.model.LockInstance;
import com.alibaba.nacos.client.constant.Constants;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.lock.remote.grpc.LockGrpcClient;
import com.alibaba.nacos.client.naming.core.NamingServerListManager;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientManager;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NacosLockService
implements LockService {
    private final LockGrpcClient lockGrpcClient;
    private final SecurityProxy securityProxy;
    private ScheduledExecutorService executorService;

    public NacosLockService(Properties properties) throws NacosException {
        NacosClientProperties nacosClientProperties = NacosClientProperties.PROTOTYPE.derive(properties);
        NamingServerListManager serverListManager = new NamingServerListManager(properties);
        serverListManager.start();
        this.securityProxy = new SecurityProxy(serverListManager, NamingHttpClientManager.getInstance().getNacosRestTemplate());
        this.initSecurityProxy(nacosClientProperties);
        this.lockGrpcClient = new LockGrpcClient(nacosClientProperties, (ServerListFactory)((Object)serverListManager), this.securityProxy);
    }

    private void initSecurityProxy(NacosClientProperties properties) {
        this.executorService = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setName("com.alibaba.nacos.client.lock.security");
            t.setDaemon(true);
            return t;
        });
        Properties nacosClientPropertiesView = properties.asProperties();
        this.securityProxy.login(nacosClientPropertiesView);
        this.executorService.scheduleWithFixedDelay(() -> this.securityProxy.login(nacosClientPropertiesView), 0L, Constants.Security.SECURITY_INFO_REFRESH_INTERVAL_MILLS, TimeUnit.MILLISECONDS);
    }

    @Override
    public Boolean lock(LockInstance instance) throws NacosException {
        return instance.lock(this);
    }

    @Override
    public Boolean unLock(LockInstance instance) throws NacosException {
        return instance.unLock(this);
    }

    @Override
    public Boolean remoteTryLock(LockInstance instance) throws NacosException {
        return this.lockGrpcClient.lock(instance);
    }

    @Override
    public Boolean remoteReleaseLock(LockInstance instance) throws NacosException {
        return this.lockGrpcClient.unLock(instance);
    }

    @Override
    public void shutdown() throws NacosException {
        this.lockGrpcClient.shutdown();
        if (null != this.executorService) {
            this.executorService.shutdown();
        }
    }
}

