/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.common.remote.TlsConfig;
import com.alibaba.nacos.common.remote.client.RpcClientTlsConfig;
import com.alibaba.nacos.common.remote.client.RpcClientTlsConfigFactory;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClientConfig;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class DefaultGrpcClientConfig
implements GrpcClientConfig {
    private String name;
    private final int retryTimes;
    private final long timeOutMills;
    private final long connectionKeepAlive;
    private final long channelKeepAliveTimeout;
    private final long threadPoolKeepAlive;
    private final int threadPoolCoreSize;
    private final int threadPoolMaxSize;
    private final long serverCheckTimeOut;
    private final int threadPoolQueueSize;
    private final int maxInboundMessageSize;
    private final int channelKeepAlive;
    private final int healthCheckRetryTimes;
    private final long healthCheckTimeOut;
    private final long capabilityNegotiationTimeout;
    private final boolean allowCoreThreadTimeOut;
    private final Map<String, String> labels;
    private RpcClientTlsConfig tlsConfig = new RpcClientTlsConfig();

    private DefaultGrpcClientConfig(Builder builder) {
        this.name = builder.name;
        this.retryTimes = builder.retryTimes;
        this.timeOutMills = builder.timeOutMills;
        this.connectionKeepAlive = builder.connectionKeepAlive;
        this.threadPoolKeepAlive = builder.threadPoolKeepAlive;
        this.threadPoolCoreSize = builder.threadPoolCoreSize;
        this.threadPoolMaxSize = builder.threadPoolMaxSize;
        this.serverCheckTimeOut = builder.serverCheckTimeOut;
        this.threadPoolQueueSize = builder.threadPoolQueueSize;
        this.maxInboundMessageSize = builder.maxInboundMessageSize;
        this.channelKeepAlive = builder.channelKeepAlive;
        this.healthCheckRetryTimes = builder.healthCheckRetryTimes;
        this.healthCheckTimeOut = builder.healthCheckTimeOut;
        this.channelKeepAliveTimeout = builder.channelKeepAliveTimeout;
        this.capabilityNegotiationTimeout = builder.capabilityNegotiationTimeout;
        this.allowCoreThreadTimeOut = builder.allowCoreThreadTimeOut;
        this.labels = builder.labels;
        this.labels.put("tls.enable", "false");
        if (Objects.nonNull(builder.tlsConfig)) {
            this.tlsConfig = builder.tlsConfig;
            if (Objects.nonNull(builder.tlsConfig.getEnableTls()) && builder.tlsConfig.getEnableTls().booleanValue()) {
                this.labels.put("tls.enable", "true");
            }
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int retryTimes() {
        return this.retryTimes;
    }

    @Override
    public long timeOutMills() {
        return this.timeOutMills;
    }

    @Override
    public long connectionKeepAlive() {
        return this.connectionKeepAlive;
    }

    @Override
    public int threadPoolCoreSize() {
        return this.threadPoolCoreSize;
    }

    @Override
    public int threadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public long threadPoolKeepAlive() {
        return this.threadPoolKeepAlive;
    }

    @Override
    public long serverCheckTimeOut() {
        return this.serverCheckTimeOut;
    }

    @Override
    public int threadPoolQueueSize() {
        return this.threadPoolQueueSize;
    }

    @Override
    public int maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    @Override
    public int channelKeepAlive() {
        return this.channelKeepAlive;
    }

    @Override
    public long channelKeepAliveTimeout() {
        return this.channelKeepAliveTimeout;
    }

    @Override
    public TlsConfig tlsConfig() {
        return this.tlsConfig;
    }

    @Override
    public void setTlsConfig(RpcClientTlsConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long capabilityNegotiationTimeout() {
        return this.capabilityNegotiationTimeout;
    }

    @Override
    public boolean allowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    @Override
    public int healthCheckRetryTimes() {
        return this.healthCheckRetryTimes;
    }

    @Override
    public long healthCheckTimeOut() {
        return this.healthCheckTimeOut;
    }

    @Override
    public Map<String, String> labels() {
        return this.labels;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private int retryTimes = 3;
        private long timeOutMills = 3000L;
        private long connectionKeepAlive = 5000L;
        private long threadPoolKeepAlive = 10000L;
        private int threadPoolCoreSize = ThreadUtils.getSuitableThreadCount(2);
        private int threadPoolMaxSize = ThreadUtils.getSuitableThreadCount(8);
        private long serverCheckTimeOut = 3000L;
        private int threadPoolQueueSize = 10000;
        private int maxInboundMessageSize = 0xA00000;
        private int channelKeepAlive = 360000;
        private long channelKeepAliveTimeout = TimeUnit.SECONDS.toMillis(20L);
        private int healthCheckRetryTimes = 3;
        private long healthCheckTimeOut = 3000L;
        private long capabilityNegotiationTimeout = 5000L;
        private boolean allowCoreThreadTimeOut = false;
        private final Map<String, String> labels = new HashMap<String, String>();
        private RpcClientTlsConfig tlsConfig = new RpcClientTlsConfig();

        private Builder() {
        }

        public Builder buildSdkFromProperties(Properties properties) {
            RpcClientTlsConfig tlsConfig = RpcClientTlsConfigFactory.getInstance().createSdkConfig(properties);
            return this.fromProperties(properties, tlsConfig);
        }

        public Builder buildClusterFromProperties(Properties properties) {
            RpcClientTlsConfig tlsConfig = RpcClientTlsConfigFactory.getInstance().createClusterConfig(properties);
            return this.fromProperties(properties, tlsConfig);
        }

        public Builder fromProperties(Properties properties, RpcClientTlsConfig tlsConfig) {
            if (properties.containsKey("nacos.remote.client.grpc.name")) {
                this.name = properties.getProperty("nacos.remote.client.grpc.name");
            }
            if (properties.containsKey("nacos.remote.client.grpc.retry.times")) {
                this.retryTimes = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.retry.times"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.timeout")) {
                this.timeOutMills = Long.parseLong(properties.getProperty("nacos.remote.client.grpc.timeout"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.connect.keep.alive")) {
                this.connectionKeepAlive = Long.parseLong(properties.getProperty("nacos.remote.client.grpc.connect.keep.alive"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.pool.alive")) {
                this.threadPoolKeepAlive = Long.parseLong(properties.getProperty("nacos.remote.client.grpc.pool.alive"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.pool.core.size")) {
                this.threadPoolCoreSize = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.pool.core.size"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.pool.max.size")) {
                this.threadPoolMaxSize = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.pool.max.size"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.server.check.timeout")) {
                this.serverCheckTimeOut = Long.parseLong(properties.getProperty("nacos.remote.client.grpc.server.check.timeout"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.queue.size")) {
                this.threadPoolQueueSize = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.queue.size"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.maxinbound.message.size")) {
                this.maxInboundMessageSize = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.maxinbound.message.size"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.channel.keep.alive")) {
                this.channelKeepAlive = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.channel.keep.alive"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.channel.capability.negotiation.timeout")) {
                this.capabilityNegotiationTimeout = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.channel.capability.negotiation.timeout"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.health.retry")) {
                this.healthCheckRetryTimes = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.health.retry"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.health.timeout")) {
                this.healthCheckTimeOut = Long.parseLong(properties.getProperty("nacos.remote.client.grpc.health.timeout"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.channel.keep.alive.timeout")) {
                this.channelKeepAliveTimeout = Integer.parseInt(properties.getProperty("nacos.remote.client.grpc.channel.keep.alive.timeout"));
            }
            if (properties.containsKey("nacos.remote.client.grpc.pool.core.timeout")) {
                this.allowCoreThreadTimeOut = Boolean.parseBoolean(properties.getProperty("nacos.remote.client.grpc.pool.core.timeout"));
            }
            this.tlsConfig = tlsConfig;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setRetryTimes(int retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public Builder setTimeOutMills(long timeOutMills) {
            this.timeOutMills = timeOutMills;
            return this;
        }

        public Builder setConnectionKeepAlive(long connectionKeepAlive) {
            this.connectionKeepAlive = connectionKeepAlive;
            return this;
        }

        public Builder setThreadPoolKeepAlive(Long threadPoolKeepAlive) {
            this.threadPoolKeepAlive = threadPoolKeepAlive;
            return this;
        }

        public Builder setThreadPoolCoreSize(Integer threadPoolCoreSize) {
            if (!Objects.isNull(threadPoolCoreSize)) {
                this.threadPoolCoreSize = threadPoolCoreSize;
            }
            return this;
        }

        public Builder setThreadPoolMaxSize(Integer threadPoolMaxSize) {
            if (!Objects.isNull(threadPoolMaxSize)) {
                this.threadPoolMaxSize = threadPoolMaxSize;
            }
            return this;
        }

        public Builder setServerCheckTimeOut(Long serverCheckTimeOut) {
            this.serverCheckTimeOut = serverCheckTimeOut;
            return this;
        }

        public Builder setThreadPoolQueueSize(int threadPoolQueueSize) {
            this.threadPoolQueueSize = threadPoolQueueSize;
            return this;
        }

        public Builder setMaxInboundMessageSize(int maxInboundMessageSize) {
            this.maxInboundMessageSize = maxInboundMessageSize;
            return this;
        }

        public Builder setChannelKeepAlive(int channelKeepAlive) {
            this.channelKeepAlive = channelKeepAlive;
            return this;
        }

        public Builder setChannelKeepAliveTimeout(int channelKeepAliveTimeout) {
            this.channelKeepAliveTimeout = channelKeepAliveTimeout;
            return this;
        }

        public Builder setCapabilityNegotiationTimeout(long capabilityNegotiationTimeout) {
            this.capabilityNegotiationTimeout = capabilityNegotiationTimeout;
            return this;
        }

        public Builder setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
            return this;
        }

        public Builder setHealthCheckRetryTimes(int healthCheckRetryTimes) {
            this.healthCheckRetryTimes = healthCheckRetryTimes;
            return this;
        }

        public Builder setHealthCheckTimeOut(long healthCheckTimeOut) {
            this.healthCheckTimeOut = healthCheckTimeOut;
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels.putAll(labels);
            return this;
        }

        public Builder setTlsConfig(RpcClientTlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public GrpcClientConfig build() {
            return new DefaultGrpcClientConfig(this);
        }
    }
}

