/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.anno.CacheConsts;
import com.alicp.jetcache.anno.method.CacheInvokeContext;
import com.alicp.jetcache.anno.support.CacheAnnoConfig;
import com.alicp.jetcache.anno.support.CacheInvalidateAnnoConfig;
import com.alicp.jetcache.anno.support.CacheThreadLocal;
import com.alicp.jetcache.anno.support.CacheUpdateAnnoConfig;
import com.alicp.jetcache.anno.support.CachedAnnoConfig;
import com.alicp.jetcache.anno.support.ConfigMap;
import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.anno.support.PenetrationProtectConfig;
import com.alicp.jetcache.template.QuickConfig;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheContext {
    private static Logger logger = LoggerFactory.getLogger(CacheContext.class);
    private static ThreadLocal<CacheThreadLocal> cacheThreadLocal = new ThreadLocal<CacheThreadLocal>(){

        @Override
        protected CacheThreadLocal initialValue() {
            return new CacheThreadLocal();
        }
    };
    private ConfigProvider configProvider;
    private GlobalCacheConfig globalCacheConfig;
    private CacheManager cacheManager;

    public CacheContext(CacheManager cacheManager, ConfigProvider configProvider, GlobalCacheConfig globalCacheConfig) {
        this.cacheManager = cacheManager;
        this.globalCacheConfig = globalCacheConfig;
        this.configProvider = configProvider;
    }

    public CacheInvokeContext createCacheInvokeContext(ConfigMap configMap) {
        CacheInvokeContext c = this.newCacheInvokeContext();
        c.setCacheFunction((cic, cac) -> this.createOrGetCache((CacheInvokeContext)cic, (CacheAnnoConfig)cac, configMap));
        return c;
    }

    private Cache createOrGetCache(CacheInvokeContext invokeContext, CacheAnnoConfig cacheAnnoConfig, ConfigMap configMap) {
        Cache cache = cacheAnnoConfig.getCache();
        if (cache != null) {
            return cache;
        }
        if (cacheAnnoConfig instanceof CachedAnnoConfig) {
            cache = this.createCacheByCachedConfig((CachedAnnoConfig)cacheAnnoConfig, invokeContext);
        } else if ((cacheAnnoConfig instanceof CacheInvalidateAnnoConfig || cacheAnnoConfig instanceof CacheUpdateAnnoConfig) && (cache = this.cacheManager.getCache(cacheAnnoConfig.getArea(), cacheAnnoConfig.getName())) == null) {
            CachedAnnoConfig cac = configMap.getByCacheName(cacheAnnoConfig.getArea(), cacheAnnoConfig.getName());
            if (cac == null) {
                String message = "can't find cache definition with area=" + cacheAnnoConfig.getArea() + " name=" + cacheAnnoConfig.getName() + ", specified in " + cacheAnnoConfig.getDefineMethod();
                CacheConfigException e = new CacheConfigException(message);
                logger.error("Cache operation aborted because can't find cached definition", (Throwable)e);
                return null;
            }
            cache = this.createCacheByCachedConfig(cac, invokeContext);
        }
        cacheAnnoConfig.setCache(cache);
        return cache;
    }

    private Cache createCacheByCachedConfig(CachedAnnoConfig ac, CacheInvokeContext invokeContext) {
        String area = ac.getArea();
        String cacheName = ac.getName();
        if (CacheConsts.isUndefined((String)cacheName)) {
            cacheName = this.configProvider.createCacheNameGenerator(invokeContext.getHiddenPackages()).generateCacheName(invokeContext.getMethod(), invokeContext.getTargetObject());
        }
        Cache cache = this.__createOrGetCache(ac, area, cacheName);
        return cache;
    }

    public Cache __createOrGetCache(CachedAnnoConfig cac, String area, String cacheName) {
        QuickConfig.Builder b = QuickConfig.newBuilder((String)area, (String)cacheName);
        TimeUnit timeUnit = cac.getTimeUnit();
        if (cac.getExpire() > 0L) {
            b.expire(Duration.ofMillis(timeUnit.toMillis(cac.getExpire())));
        }
        if (cac.getLocalExpire() > 0L) {
            b.localExpire(Duration.ofMillis(timeUnit.toMillis(cac.getLocalExpire())));
        }
        if (cac.getLocalLimit() > 0) {
            b.localLimit(Integer.valueOf(cac.getLocalLimit()));
        }
        b.cacheType(cac.getCacheType());
        b.syncLocal(Boolean.valueOf(cac.isSyncLocal()));
        if (!CacheConsts.isUndefined((String)cac.getKeyConvertor())) {
            b.keyConvertor(this.configProvider.parseKeyConvertor(cac.getKeyConvertor()));
        }
        if (!CacheConsts.isUndefined((String)cac.getSerialPolicy())) {
            b.valueEncoder(this.configProvider.parseValueEncoder(cac.getSerialPolicy()));
            b.valueDecoder(this.configProvider.parseValueDecoder(cac.getSerialPolicy()));
        }
        b.cacheNullValue(Boolean.valueOf(cac.isCacheNullValue()));
        b.useAreaInPrefix(Boolean.valueOf(this.globalCacheConfig.isAreaInCacheName()));
        PenetrationProtectConfig ppc = cac.getPenetrationProtectConfig();
        if (ppc != null) {
            b.penetrationProtect(Boolean.valueOf(ppc.isPenetrationProtect()));
            b.penetrationProtectTimeout(ppc.getPenetrationProtectTimeout());
        }
        b.refreshPolicy(cac.getRefreshPolicy());
        return this.cacheManager.getOrCreateCache(b.build());
    }

    protected CacheInvokeContext newCacheInvokeContext() {
        return new CacheInvokeContext();
    }

    public static <T> T enableCache(Supplier<T> callback) {
        CacheThreadLocal var = cacheThreadLocal.get();
        try {
            var.setEnabledCount(var.getEnabledCount() + 1);
            T t = callback.get();
            return t;
        }
        finally {
            var.setEnabledCount(var.getEnabledCount() - 1);
        }
    }

    protected static void enable() {
        CacheThreadLocal var = cacheThreadLocal.get();
        var.setEnabledCount(var.getEnabledCount() + 1);
    }

    protected static void disable() {
        CacheThreadLocal var = cacheThreadLocal.get();
        var.setEnabledCount(var.getEnabledCount() - 1);
    }

    protected static boolean isEnabled() {
        return cacheThreadLocal.get().getEnabledCount() > 0;
    }
}

