/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.core.auth.ServiceSignature;
import com.alicloud.openservices.tablestore.core.utils.Base64;
import com.alicloud.openservices.tablestore.core.utils.Bytes;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacSHA256Signature
implements ServiceSignature {
    private static final String ALGORITHM = "HmacSHA256";
    private static final Object LOCK;
    private static Mac macInstance;
    private Mac mac;

    public HmacSHA256Signature(byte[] key) {
        try {
            try {
                this.mac = (Mac)macInstance.clone();
            }
            catch (CloneNotSupportedException e) {
                this.mac = Mac.getInstance(ALGORITHM);
            }
            this.mac.init(new SecretKeySpec(key, ALGORITHM));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Unsupported algorithm: HmacSHA256", ex);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public void updateUTF8String(String data) {
        this.update(Bytes.toBytes(data));
    }

    @Override
    public void update(byte[] data) {
        this.mac.update(data);
    }

    @Override
    public void update(byte data) {
        this.mac.update(data);
    }

    @Override
    public String computeSignature() {
        byte[] signature = this.mac.doFinal();
        return Base64.toBase64String(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = LOCK = new Object();
        synchronized (object) {
            if (macInstance == null) {
                try {
                    macInstance = Mac.getInstance(ALGORITHM);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

