/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.auth.HmacSHA1Signature;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.http.OTSUri;
import com.alicloud.openservices.tablestore.core.http.ResponseHandler;
import com.alicloud.openservices.tablestore.core.http.ResponseMessage;
import com.alicloud.openservices.tablestore.core.utils.Bytes;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTSValidationResponseHandler
implements ResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OTSValidationResponseHandler.class);
    private ServiceCredentials credentials;
    private OTSUri uri;

    public OTSValidationResponseHandler(ServiceCredentials credentials, OTSUri uri) {
        Preconditions.checkNotNull(credentials);
        Preconditions.checkNotNull(uri);
        this.credentials = credentials;
        this.uri = uri;
    }

    @Override
    public void handle(ResponseMessage responseData) throws ClientException {
        Map<String, String> headers = responseData.getLowerCaseHeadersMap();
        if (!headers.containsKey("x-ots-contentmd5")) {
            throw new ClientException("MissingHeader: x-ots-contentmd5");
        }
        if (!headers.containsKey("x-ots-contenttype")) {
            throw new ClientException("MissingHeader: x-ots-contenttype");
        }
        if (!headers.containsKey("authorization")) {
            throw new ClientException("MissingHeader: authorization");
        }
        StringBuilder strToSign = new StringBuilder(1000);
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.putAll(headers);
        for (Map.Entry entry : sortedMap.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (!key.startsWith("x-ots-")) continue;
            strToSign.append(key);
            strToSign.append(':');
            strToSign.append(val);
            strToSign.append('\n');
        }
        strToSign.append('/');
        strToSign.append(this.uri.getAction());
        HmacSHA1Signature signer = new HmacSHA1Signature(Bytes.toBytes(this.credentials.getAccessKeySecret()));
        signer.updateUTF8String(strToSign.toString());
        String actualSign = signer.computeSignature();
        String authHeader = headers.get("authorization");
        int posSign = authHeader.indexOf(actualSign);
        if (posSign < 0) {
            LOG.error("Validate response authorization failed, cannot find signature. headers:{}, accessKeyId:{}, computedSign:{}", new Object[]{headers, this.credentials.getAccessKeyId(), actualSign});
            throw new ClientException("\u8fd4\u56de\u7ed3\u679c\u6388\u6743\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25\u3002");
        }
        if (posSign == 0 || authHeader.charAt(posSign - 1) != ':') {
            LOG.error("Validate response authorization failed, cannot find separator ':'. headers:{}, accessKeyId:{}, computedSign:{}", new Object[]{headers, this.credentials.getAccessKeyId(), actualSign});
            throw new ClientException("\u8fd4\u56de\u7ed3\u679c\u6388\u6743\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25\u3002");
        }
        if (posSign + actualSign.length() != authHeader.length()) {
            LOG.error("Validate response authorization failed, signature is not the last part of authHeader. headers:{}, accessKeyId:{}, computedSign:{}", new Object[]{headers, this.credentials.getAccessKeyId(), actualSign});
            throw new ClientException("\u8fd4\u56de\u7ed3\u679c\u6388\u6743\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25\u3002");
        }
    }
}

