/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.ecosystem;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.ecosystem.CatalogManager;
import com.alicloud.openservices.tablestore.ecosystem.ComputeParameters;
import com.alicloud.openservices.tablestore.ecosystem.Filter;
import com.alicloud.openservices.tablestore.ecosystem.ICatalogManager;
import com.alicloud.openservices.tablestore.ecosystem.ITablestoreSplit;
import com.alicloud.openservices.tablestore.ecosystem.ITablestoreSplitManager;
import com.alicloud.openservices.tablestore.ecosystem.LeftMatchResult;
import com.alicloud.openservices.tablestore.ecosystem.SearchInfo;
import com.alicloud.openservices.tablestore.ecosystem.TableCatalog;
import com.alicloud.openservices.tablestore.ecosystem.TablestoreSplit;
import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeResponse;
import com.alicloud.openservices.tablestore.model.ComputeSplitsRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.SearchIndexSplitsOptions;
import com.alicloud.openservices.tablestore.model.Split;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.FieldSchema;
import com.alicloud.openservices.tablestore.model.search.FieldType;
import com.alicloud.openservices.tablestore.model.search.IndexSchema;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTablestoreSplitManager
implements ITablestoreSplitManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTablestoreSplitManager.class);
    private ICatalogManager manager;
    private static final AtomicBoolean enableSplitCache = new AtomicBoolean(true);
    private static final Map<String, ComputeSplitsBySizeResponse> splitsCache = new ConcurrentHashMap<String, ComputeSplitsBySizeResponse>();

    public DefaultTablestoreSplitManager(SyncClient client) {
        this.manager = new CatalogManager(client);
    }

    public static void setEnableSplitCache(boolean enableSplitCache) {
        DefaultTablestoreSplitManager.enableSplitCache.set(enableSplitCache);
    }

    @Override
    public List<ITablestoreSplit> generateTablestoreSplits(SyncClient client, Filter filter, String tableName, ComputeParameters parameter, List<String> requiredColumns) {
        TableCatalog catalog = this.manager.getTableCatalog(tableName);
        if (catalog == null) {
            throw new InvalidParameterException("table does not exist");
        }
        ArrayList<ITablestoreSplit> tableSplits = new ArrayList<ITablestoreSplit>();
        LeftMatchResult calculateResult = new LeftMatchResult(tableName, catalog.getTableMeta());
        if (parameter.getComputeMode() == ComputeParameters.ComputeMode.Auto) {
            calculateResult = this.calculateComputeMode(client, catalog, filter, parameter, requiredColumns);
        }
        if (parameter.getComputeMode() == ComputeParameters.ComputeMode.KV) {
            List<Split> rawSplits = this.getTableSplits(client, calculateResult.getTableName(), parameter);
            for (Split rawSplit : rawSplits) {
                TablestoreSplit split = new TablestoreSplit(TablestoreSplit.SplitType.KeyValue, filter, requiredColumns);
                split.setKvSplit(rawSplit);
                split.setKvTableMeta(calculateResult.getTableMeta());
                split.setTableName(tableName);
                split.setSplitName(calculateResult.getTableName());
                if (!split.checkIfMatchTheFilter(filter)) continue;
                tableSplits.add(split);
            }
        } else if (parameter.getComputeMode() == ComputeParameters.ComputeMode.Search) {
            if (parameter.getSearchIndexName() != null) {
                DescribeSearchIndexRequest request = new DescribeSearchIndexRequest();
                request.setTableName(tableName);
                request.setIndexName(parameter.getSearchIndexName());
                DescribeSearchIndexResponse response = client.describeSearchIndex(request);
                IndexSchema schema = response.getSchema();
                ArrayList<String> geoFieldList = new ArrayList<String>();
                for (FieldSchema fieldSchema : schema.getFieldSchemas()) {
                    if (fieldSchema.getFieldType() != FieldType.GEO_POINT) continue;
                    geoFieldList.add(fieldSchema.getFieldName());
                }
                ComputeSplitsRequest computeSplitsRequest = new ComputeSplitsRequest();
                computeSplitsRequest.setTableName(tableName);
                computeSplitsRequest.setSplitsOptions(new SearchIndexSplitsOptions(parameter.getSearchIndexName()));
                ComputeSplitsResponse computeSplitsResponse = client.computeSplits(computeSplitsRequest);
                byte[] sessionId = computeSplitsResponse.getSessionId();
                int splitsSize = computeSplitsResponse.getSplitsSize();
                if (parameter.getMaxSplitsCount() > 0 && parameter.getMaxSplitsCount() < splitsSize) {
                    splitsSize = parameter.getMaxSplitsCount();
                }
                for (int i = 0; i < splitsSize; ++i) {
                    TablestoreSplit split = new TablestoreSplit(TablestoreSplit.SplitType.SearchIndex, filter, requiredColumns, sessionId, i, splitsSize, geoFieldList);
                    SearchInfo info = new SearchInfo(parameter.getSearchIndexName(), catalog.getSearchSchema().get(0));
                    split.setSearchInfo(info);
                    split.setTableName(tableName);
                    split.setSplitName(parameter.getSearchIndexName());
                    tableSplits.add(split);
                }
            } else {
                TablestoreSplit split = new TablestoreSplit(TablestoreSplit.SplitType.SearchIndex, filter, requiredColumns);
                SearchInfo info = new SearchInfo(catalog.getSearchNames().get(0), catalog.getSearchSchema().get(0));
                split.setSearchInfo(info);
                split.setTableName(tableName);
                split.setSplitName(catalog.getSearchNames().get(0));
                tableSplits.add(split);
            }
        }
        return tableSplits;
    }

    private String formatSplitsCacheKey(String instanceName, String tableName, ComputeParameters parameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(instanceName).append("_");
        sb.append(tableName).append("_");
        sb.append(parameter.getMaxSplitsCount()).append("_");
        sb.append(parameter.getSplitSizeInMBs());
        return sb.toString();
    }

    public List<Split> getTableSplits(SyncClient client, String tableName, ComputeParameters parameter) {
        String key = this.formatSplitsCacheKey(client.getInstanceName(), tableName, parameter);
        if (enableSplitCache.get() && splitsCache.containsKey(key)) {
            LOG.info("Load splits from cache, key: {}", (Object)key);
            return splitsCache.get(key).getSplits();
        }
        ComputeSplitsBySizeRequest request = new ComputeSplitsBySizeRequest();
        request.setTableName(tableName);
        request.setSplitPointLimit(parameter.getMaxSplitsCount());
        request.setSplitSizeInByte(parameter.getSplitSizeInMBs(), 0x100000L);
        ComputeSplitsBySizeResponse response = client.computeSplitsBySize(request);
        LOG.info("ComputeSplitsBySize, request param: [{}, {}], resp split size: {}", new Object[]{parameter.getMaxSplitsCount(), parameter.getSplitSizeInMBs(), response.getSplits().size()});
        if (enableSplitCache.get()) {
            splitsCache.put(key, response);
        }
        return response.getSplits();
    }

    public LeftMatchResult calculateComputeMode(SyncClient client, TableCatalog catalog, Filter filter, ComputeParameters parameter, List<String> requiredColumns) {
        LeftMatchResult mainTableResult;
        LeftMatchResult bestTableResult = mainTableResult = this.calculateKvLeftMatchResult(filter, catalog.getTableMeta());
        for (TableMeta meta : catalog.getIndexMetaList()) {
            LeftMatchResult indexResult = this.calculateKvLeftMatchResult(filter, meta);
            if (indexResult.getCount() > bestTableResult.getCount()) {
                bestTableResult = indexResult;
            }
            if (bestTableResult.getCount() != meta.getPrimaryKeyList().size()) continue;
            break;
        }
        if (catalog.getSearchSchema().size() > 0 && bestTableResult.getCount() == 0 && this.isSearchIndexMatchTheFilter(catalog.getSearchSchema(), requiredColumns).booleanValue()) {
            parameter.setComputeMode(ComputeParameters.ComputeMode.Search);
            return new LeftMatchResult(catalog.getSearchNames().get(0), null);
        }
        parameter.setComputeMode(ComputeParameters.ComputeMode.KV);
        return bestTableResult;
    }

    private Boolean isSearchIndexMatchTheFilter(List<IndexSchema> indexSchemas, List<String> requiredColumns) {
        boolean indexMatched = true;
        block0: for (IndexSchema schema : indexSchemas) {
            for (String requireColumn : requiredColumns) {
                if (this.isSearchIndexMatchTheFilter(requireColumn, schema)) continue;
                indexMatched = false;
                continue block0;
            }
        }
        return indexMatched;
    }

    private boolean isSearchIndexMatchTheFilter(String columnName, IndexSchema schema) {
        for (FieldSchema field : schema.getFieldSchemas()) {
            if (!field.getFieldName().equals(columnName) || !field.isStore().booleanValue() || !field.isIndex().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private LeftMatchResult calculateKvLeftMatchResult(Filter filter, TableMeta meta) {
        ArrayList<LeftMatchResult> resultCollection;
        if (filter.isNested()) {
            resultCollection = new ArrayList<LeftMatchResult>();
            for (Filter subFilter : filter.getSubFilters()) {
                LeftMatchResult tempResult;
                if (subFilter.isNested()) {
                    tempResult = this.calculateKvLeftMatchResult(subFilter, meta);
                    resultCollection.add(tempResult);
                    continue;
                }
                tempResult = DefaultTablestoreSplitManager.buildMatchResult(subFilter, meta);
                resultCollection.add(tempResult);
            }
        } else {
            return DefaultTablestoreSplitManager.buildMatchResult(filter, meta);
        }
        LeftMatchResult result = this.buildMatchResult(resultCollection, filter.getLogicOperator());
        return result;
    }

    private static LeftMatchResult buildMatchResult(Filter filter, TableMeta meta) {
        int index = 0;
        for (PrimaryKeySchema pk : meta.getPrimaryKeyList()) {
            if (filter.getCompareOperator() == Filter.CompareOperator.EMPTY_FILTER) {
                return new LeftMatchResult(meta.getTableName(), meta);
            }
            if (filter.getColumnName().equals(pk.getName()) && DefaultTablestoreSplitManager.isTypeMatched(pk.getType(), filter.getColumnValue().getType())) {
                ArrayList<String> temp = new ArrayList<String>();
                temp.add(pk.getName());
                boolean canAppend = false;
                if (filter.getCompareOperator() == Filter.CompareOperator.EQUAL) {
                    canAppend = true;
                }
                LeftMatchResult tempResult = new LeftMatchResult(meta.getTableName(), temp, canAppend, index, meta);
                return tempResult;
            }
            ++index;
        }
        return new LeftMatchResult(meta.getTableName(), meta);
    }

    private static boolean isTypeMatched(PrimaryKeyType pkType, ColumnType columnType) {
        return pkType == PrimaryKeyType.STRING && columnType == ColumnType.STRING || pkType == PrimaryKeyType.INTEGER && columnType == ColumnType.INTEGER || pkType == PrimaryKeyType.BINARY && columnType == ColumnType.BINARY;
    }

    private LeftMatchResult seekMatchResult(List<LeftMatchResult> collection, int starPos) {
        int maxLength = 0;
        LeftMatchResult longestResult = null;
        for (LeftMatchResult result : collection) {
            if (result.getBeginPkIndex() != starPos) continue;
            if (result.getCount() > maxLength) {
                maxLength = result.getCount();
                longestResult = result;
                continue;
            }
            if (result.getCount() != maxLength || result.getCount() <= 0 || !result.getCanAppendNewKey()) continue;
            maxLength = result.getCount();
            longestResult = result;
        }
        return longestResult;
    }

    private LeftMatchResult buildMatchResult(List<LeftMatchResult> collection, Filter.LogicOperator lo) {
        if (lo == Filter.LogicOperator.OR) {
            LeftMatchResult current = collection.get(0);
            for (LeftMatchResult result : collection) {
                if (result.getCount() >= current.getCount()) continue;
                current = result;
            }
            return current;
        }
        if (lo == Filter.LogicOperator.AND) {
            LeftMatchResult last = collection.get(0);
            int starPos = 0;
            LeftMatchResult current = this.seekMatchResult(collection, starPos);
            while (current != null) {
                if (starPos == 0) {
                    last = new LeftMatchResult();
                    current.copyTo(last);
                } else {
                    last.append(current.getLeftMatchKeyList());
                    last.setCanAppendNewKey(current.getCanAppendNewKey());
                }
                starPos += current.getCount();
                if (!current.getCanAppendNewKey()) break;
                current = this.seekMatchResult(collection, starPos);
            }
            return last;
        }
        return collection.get(0);
    }
}

