/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.sql;

import com.alicloud.openservices.tablestore.core.protocol.sql.flatbuffers.BytesValue;
import com.alicloud.openservices.tablestore.core.protocol.sql.flatbuffers.ColumnValues;
import com.alicloud.openservices.tablestore.core.protocol.sql.flatbuffers.ComplexColumnTypeInfo;
import com.alicloud.openservices.tablestore.core.protocol.sql.flatbuffers.RLEStringValues;
import com.alicloud.openservices.tablestore.core.protocol.sql.flatbuffers.SQLResponseColumn;
import com.alicloud.openservices.tablestore.core.protocol.sql.flatbuffers.SQLResponseColumns;
import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.sql.SQLColumnSchema;
import com.alicloud.openservices.tablestore.model.sql.SQLRows;
import com.alicloud.openservices.tablestore.model.sql.SQLTableMeta;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;

public class SQLRowsFBsColumnBased
implements SQLRows {
    private SQLTableMeta sqlTableMeta;
    private String[] columnNames;
    private byte[] columnTypes;
    private ColumnValues[] columnValues;
    private RLEStringValues[] rleStringValues;
    private ComplexColumnTypeInfo[] columnComplexTypeInfos;
    private long rowCount;
    private long columnCount;

    public SQLRowsFBsColumnBased(SQLResponseColumns columns) {
        this.columnNames = new String[columns.columnsLength()];
        this.columnTypes = new byte[columns.columnsLength()];
        this.columnValues = new ColumnValues[columns.columnsLength()];
        this.rleStringValues = new RLEStringValues[columns.columnsLength()];
        this.columnComplexTypeInfos = new ComplexColumnTypeInfo[columns.columnsLength()];
        for (int i = 0; i < columns.columnsLength(); ++i) {
            SQLResponseColumn column = columns.columns(i);
            this.columnNames[i] = column.columnName();
            this.columnTypes[i] = column.columnType();
            this.columnValues[i] = column.columnValue();
            this.rleStringValues[i] = this.columnValues[i].rleStringValues();
            this.columnComplexTypeInfos[i] = column.columnComplexTypeInfo();
        }
        this.rowCount = columns.rowCount();
        this.columnCount = columns.columnsLength();
        this.sqlTableMeta = this.resolveSQLTableMetaFromColumns();
    }

    private SQLTableMeta resolveSQLTableMetaFromColumns() {
        ArrayList<SQLColumnSchema> schema = new ArrayList<SQLColumnSchema>();
        HashMap<String, Integer> columnsMap = new HashMap<String, Integer>();
        int i = 0;
        while ((long)i < this.columnCount) {
            schema.add(new SQLColumnSchema(this.columnNames[i], this.convertColumnType(this.columnTypes[i], this.columnComplexTypeInfos[i].columnLogicType())));
            columnsMap.put(this.columnNames[i], i);
            ++i;
        }
        return new SQLTableMeta(schema, columnsMap);
    }

    private ColumnType convertColumnType(byte columnType, byte logicType) {
        switch (columnType) {
            case 1: {
                return ColumnType.INTEGER;
            }
            case 2: {
                return ColumnType.BOOLEAN;
            }
            case 3: {
                return ColumnType.DOUBLE;
            }
            case 4: 
            case 6: {
                return ColumnType.STRING;
            }
            case 5: {
                return ColumnType.BINARY;
            }
            case 7: {
                switch (logicType) {
                    case 1: {
                        return ColumnType.DATETIME;
                    }
                    case 3: {
                        return ColumnType.TIME;
                    }
                    case 2: {
                        return ColumnType.DATE;
                    }
                }
                throw new UnsupportedOperationException("not supported Logic type in flatbuffers: " + logicType);
            }
        }
        throw new UnsupportedOperationException("not supported column type in flatbuffers: " + columnType);
    }

    @Override
    public SQLTableMeta getSQLTableMeta() {
        return this.sqlTableMeta;
    }

    @Override
    public long rowCount() {
        return this.rowCount;
    }

    @Override
    public long columnCount() {
        return this.columnCount;
    }

    @Override
    public Object get(int rowIndex, int columnIndex) {
        if ((long)rowIndex >= this.rowCount() || rowIndex < 0) {
            throw new IllegalStateException("Row index " + columnIndex + " out of range");
        }
        if ((long)columnIndex >= this.columnCount || columnIndex < 0) {
            throw new IllegalStateException("Column index " + columnIndex + " out of range");
        }
        byte columnType = this.columnTypes[columnIndex];
        byte logicType = this.columnComplexTypeInfos[columnIndex].columnLogicType();
        byte encodingType = this.columnComplexTypeInfos[columnIndex].columnEncodeType();
        ColumnValues columnValue = this.columnValues[columnIndex];
        switch (columnType) {
            case 1: {
                if (columnValue.isNullvalues(rowIndex)) {
                    return null;
                }
                return columnValue.longValues(rowIndex);
            }
            case 2: {
                if (columnValue.isNullvalues(rowIndex)) {
                    return null;
                }
                return columnValue.boolValues(rowIndex);
            }
            case 3: {
                if (columnValue.isNullvalues(rowIndex)) {
                    return null;
                }
                return columnValue.doubleValues(rowIndex);
            }
            case 4: {
                if (columnValue.isNullvalues(rowIndex)) {
                    return null;
                }
                return columnValue.stringValues(rowIndex);
            }
            case 5: {
                if (columnValue.isNullvalues(rowIndex)) {
                    return null;
                }
                BytesValue bytesValue = columnValue.binaryValues(rowIndex);
                return bytesValue.valueAsByteBuffer().duplicate();
            }
            case 6: {
                if (columnValue.isNullvalues(rowIndex)) {
                    return null;
                }
                RLEStringValues rleStringValue = this.rleStringValues[columnIndex];
                return this.resolveRLEString(rleStringValue, rowIndex);
            }
            case 7: {
                switch (logicType) {
                    case 1: {
                        if (encodingType != 1) {
                            throw new UnsupportedOperationException("encoding Type need to be: 1 , but get: " + encodingType);
                        }
                        if (columnValue.isNullvalues(rowIndex)) {
                            return null;
                        }
                        return this.resolveDateTime(columnValue.longValues(rowIndex));
                    }
                    case 3: {
                        if (encodingType != 1) {
                            throw new UnsupportedOperationException("encoding Type need to be: 1 , but get: " + encodingType);
                        }
                        if (columnValue.isNullvalues(rowIndex)) {
                            return null;
                        }
                        return this.resolveTime(columnValue.longValues(rowIndex));
                    }
                    case 2: {
                        if (encodingType != 1) {
                            throw new UnsupportedOperationException("encoding Type need to be: 1 , but get: " + encodingType);
                        }
                        if (columnValue.isNullvalues(rowIndex)) {
                            return null;
                        }
                        return this.resolveDate(columnValue.longValues(rowIndex));
                    }
                }
                throw new UnsupportedOperationException("not supported Logic type in flatbuffers: " + logicType);
            }
        }
        throw new UnsupportedOperationException("not supported column type in flatbuffers: " + columnType);
    }

    private String resolveRLEString(RLEStringValues rleStringValue, int rowIndex) {
        return rleStringValue.array(rleStringValue.indexMapping(rowIndex));
    }

    private ZonedDateTime resolveDateTime(long ts) {
        return Instant.ofEpochSecond(ts / 1000000L, (int)(ts % 1000000L) * 1000).atZone(ZoneOffset.UTC);
    }

    private Duration resolveTime(long nanos) {
        return Duration.ofNanos(nanos);
    }

    private LocalDate resolveDate(long ts) {
        return Instant.ofEpochSecond(ts).atZone(ZoneOffset.UTC).toLocalDate();
    }
}

