/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.timeseries;

import com.alicloud.openservices.tablestore.core.utils.CalculateHelper;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesKey;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class TimeseriesRow {
    private TimeseriesKey timeseriesKey;
    private long timeInUs = -1L;
    private final SortedMap<String, ColumnValue> fields = new TreeMap<String, ColumnValue>();

    public TimeseriesRow(TimeseriesKey timeseriesKey) {
        this.timeseriesKey = timeseriesKey;
    }

    public TimeseriesRow(TimeseriesKey timeseriesKey, long timeInUs) {
        this.timeseriesKey = timeseriesKey;
        this.timeInUs = timeInUs;
    }

    public int getTimeseriesRowDataSize() {
        int totalSize = 0;
        totalSize += 8;
        totalSize += CalculateHelper.calcStringSizeInBytes(this.timeseriesKey.getMeasurementName());
        totalSize += CalculateHelper.calcStringSizeInBytes(this.timeseriesKey.getDataSource());
        for (Map.Entry<String, String> entry : this.timeseriesKey.getTags().entrySet()) {
            totalSize += CalculateHelper.calcStringSizeInBytes(entry.getKey());
            totalSize += CalculateHelper.calcStringSizeInBytes(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            totalSize += ((ColumnValue)entry.getValue()).getDataSize() + CalculateHelper.calcStringSizeInBytes(entry.getKey());
        }
        return totalSize;
    }

    public TimeseriesKey getTimeseriesKey() {
        return this.timeseriesKey;
    }

    public void setTimeseriesKey(TimeseriesKey timeseriesKey) {
        this.timeseriesKey = timeseriesKey;
    }

    public long getTimeInUs() {
        return this.timeInUs;
    }

    public void setTimeInUs(long timeInUs) {
        Preconditions.checkArgument(timeInUs >= 0L, "time can not be negative");
        this.timeInUs = timeInUs;
    }

    public SortedMap<String, ColumnValue> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, ColumnValue> fields) {
        this.fields.clear();
        this.fields.putAll(fields);
    }

    public void addField(String key, ColumnValue value) {
        this.fields.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeseriesRow that = (TimeseriesRow)o;
        return Objects.equal((Object)this.timeseriesKey, (Object)that.timeseriesKey) && Objects.equal((Object)this.timeInUs, (Object)that.timeInUs) && Objects.equal(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.timeseriesKey, this.timeInUs, this.fields});
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

