/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.query;

import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.search.query.MatchPhraseQuery;
import com.alicloud.openservices.tablestore.model.search.query.MatchQuery;
import com.alicloud.openservices.tablestore.model.search.query.PrefixQuery;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.RangeQuery;
import com.alicloud.openservices.tablestore.model.search.query.TermQuery;
import com.alicloud.openservices.tablestore.model.search.query.TermsQuery;
import com.alicloud.openservices.tablestore.model.search.query.WildcardQuery;
import com.alicloud.openservices.tablestore.timeline.query.Condition;
import com.alicloud.openservices.tablestore.timeline.utils.Preconditions;

public class Field
implements Condition {
    private String name;
    private Query query;

    protected Field(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    private void checkQueryConflict(boolean allowRepeatSet, Class clazz) {
        Preconditions.checkArgument(this.query == null || allowRepeatSet && clazz.isInstance(this.query), "Condition set conflict.");
    }

    public Field equals(String value) {
        return this.equals(ColumnValue.fromString(value));
    }

    public Field equals(long value) {
        return this.equals(ColumnValue.fromLong(value));
    }

    public Field equals(double value) {
        return this.equals(ColumnValue.fromDouble(value));
    }

    public Field equals(boolean value) {
        return this.equals(ColumnValue.fromBoolean(value));
    }

    public Field in(String ... values) {
        ColumnValue[] cvs = new ColumnValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            cvs[i] = ColumnValue.fromString(values[i]);
        }
        return this.in(cvs);
    }

    public Field in(long ... values) {
        ColumnValue[] cvs = new ColumnValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            cvs[i] = ColumnValue.fromLong(values[i]);
        }
        return this.in(cvs);
    }

    public Field in(double ... values) {
        ColumnValue[] cvs = new ColumnValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            cvs[i] = ColumnValue.fromDouble(values[i]);
        }
        return this.in(cvs);
    }

    private Field in(ColumnValue[] cvs) {
        this.checkQueryConflict(false, null);
        TermsQuery query = new TermsQuery();
        query.setFieldName(this.name);
        for (ColumnValue cv : cvs) {
            query.addTerm(cv);
        }
        this.query = query;
        return this;
    }

    private Field equals(ColumnValue value) {
        this.checkQueryConflict(false, null);
        TermQuery query = new TermQuery();
        query.setFieldName(this.name);
        query.setTerm(value);
        this.query = query;
        return this;
    }

    public Field match(String text) {
        this.checkQueryConflict(false, null);
        MatchQuery query = new MatchQuery();
        query.setFieldName(this.name);
        query.setText(text);
        this.query = query;
        return this;
    }

    public Field matchPhrase(String text) {
        this.checkQueryConflict(false, null);
        MatchPhraseQuery query = new MatchPhraseQuery();
        query.setFieldName(this.name);
        query.setText(text);
        this.query = query;
        return this;
    }

    public Field startsWith(String prefix) {
        this.checkQueryConflict(false, null);
        PrefixQuery query = new PrefixQuery();
        query.setFieldName(this.name);
        query.setPrefix(prefix);
        this.query = query;
        return this;
    }

    public Field matchWildcard(String wildcard) {
        this.checkQueryConflict(false, null);
        WildcardQuery query = new WildcardQuery();
        query.setFieldName(this.name);
        query.setValue(wildcard);
        this.query = query;
        return this;
    }

    private Field range(ColumnValue from, boolean fromSet, boolean includeFrom, ColumnValue to, boolean toSet, boolean includeTo) {
        RangeQuery query;
        if (this.query != null && this.query instanceof RangeQuery) {
            query = (RangeQuery)this.query;
        } else {
            this.checkQueryConflict(true, RangeQuery.class);
            query = new RangeQuery();
        }
        query.setFieldName(this.name);
        if (fromSet) {
            query.setFrom(from);
            query.setIncludeLower(includeFrom);
        }
        if (toSet) {
            query.setTo(to);
            query.setIncludeUpper(includeTo);
        }
        Preconditions.checkArgument(query.getFrom() == null || query.getTo() == null || query.getFrom().getType() == query.getTo().getType(), "The value of range boundary must be in the same type.");
        this.query = query;
        return this;
    }

    public Field greaterThan(long start) {
        return this.range(ColumnValue.fromLong(start), true, false, null, false, false);
    }

    public Field greaterEqual(long start) {
        return this.range(ColumnValue.fromLong(start), true, true, null, false, false);
    }

    public Field lessThan(long end) {
        return this.range(null, false, false, ColumnValue.fromLong(end), true, false);
    }

    public Field lessEqual(long end) {
        return this.range(null, false, false, ColumnValue.fromLong(end), true, true);
    }

    public Field greaterThan(String start) {
        return this.range(ColumnValue.fromString(start), true, false, null, false, false);
    }

    public Field greaterEqual(String start) {
        return this.range(ColumnValue.fromString(start), true, true, null, false, false);
    }

    public Field lessThan(String end) {
        return this.range(null, false, false, ColumnValue.fromString(end), true, false);
    }

    public Field lessEqual(String end) {
        return this.range(null, false, false, ColumnValue.fromString(end), true, true);
    }

    public Field greaterThan(double start) {
        return this.range(ColumnValue.fromDouble(start), true, false, null, false, false);
    }

    public Field greaterEqual(double start) {
        return this.range(ColumnValue.fromDouble(start), true, true, null, false, false);
    }

    public Field lessThan(double end) {
        return this.range(null, false, false, ColumnValue.fromDouble(end), true, false);
    }

    public Field lessEqual(double end) {
        return this.range(null, false, false, ColumnValue.fromDouble(end), true, true);
    }

    public Field withQuery(Query query) {
        this.query = query;
        return this;
    }
}

