/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeserieswriter.manager;

import com.alicloud.openservices.tablestore.AsyncTimeseriesClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesKey;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesTableRow;
import com.alicloud.openservices.tablestore.timeserieswriter.callback.TimeseriesCallbackFactory;
import com.alicloud.openservices.tablestore.timeserieswriter.callback.TimeseriesFlushCallbackFactory;
import com.alicloud.openservices.tablestore.timeserieswriter.callback.TimeseriesRowResult;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesBucketConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesWriterConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.group.TimeseriesRowWithGroup;
import com.alicloud.openservices.tablestore.timeserieswriter.handle.TimeseriesWriterHandleStatistics;
import com.alicloud.openservices.tablestore.timeserieswriter.manager.TimeseriesRequestManager;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeseriesBaseRequestManager
implements TimeseriesRequestManager {
    private Logger logger = LoggerFactory.getLogger(TimeseriesBaseRequestManager.class);
    protected AsyncTimeseriesClientInterface ots;
    protected TimeseriesBucketConfig timeseriesBucketConfig;
    protected TimeseriesWriterConfig timeseriesWriterConfig;
    protected Semaphore callbackSemaphore;
    protected TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> callback;
    protected Executor executor;
    protected TimeseriesWriterHandleStatistics timeseriesWriterHandleStatistics;
    protected Semaphore bucketSemaphore;
    protected TimeseriesCallbackFactory callbackFactory;
    protected List<TimeseriesRowWithGroup> timeseriesRowWithGroups = new LinkedList<TimeseriesRowWithGroup>();
    protected int totalSize;
    protected int totalRowsCount;
    protected boolean allowDuplicatedRowInBatchRequest;
    protected ConcurrentSkipListSet<TimeseriesKey> sendingTimeseriesKeys = new ConcurrentSkipListSet();

    public TimeseriesBaseRequestManager(AsyncTimeseriesClientInterface ots, TimeseriesWriterConfig timeseriesWriterConfig, TimeseriesBucketConfig timeseriesBucketConfig, Executor executor, TimeseriesWriterHandleStatistics timeseriesWriterHandleStatistics, TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> callback, Semaphore callbackSemaphore, Semaphore bucketSemaphore) {
        this.ots = ots;
        this.timeseriesWriterConfig = timeseriesWriterConfig;
        this.timeseriesBucketConfig = timeseriesBucketConfig;
        this.executor = executor;
        this.timeseriesWriterHandleStatistics = timeseriesWriterHandleStatistics;
        this.callback = callback;
        this.callbackSemaphore = callbackSemaphore;
        this.bucketSemaphore = bucketSemaphore;
        this.totalSize = 0;
        this.totalRowsCount = 0;
        this.allowDuplicatedRowInBatchRequest = timeseriesBucketConfig.isAllowDuplicateRowInBatchRequest();
        this.callbackFactory = new TimeseriesFlushCallbackFactory(ots, callbackSemaphore, callback, executor, timeseriesWriterHandleStatistics, timeseriesBucketConfig, bucketSemaphore);
    }

    @Override
    public boolean appendTimeseriesRow(TimeseriesRowWithGroup timeseriesRowWithGroup) {
        try {
            if (this.totalSize + timeseriesRowWithGroup.timeseriesTableRow.getTimeseriesRow().getTimeseriesRowDataSize() > this.timeseriesWriterConfig.getMaxBatchSize()) {
                return false;
            }
            if (this.totalRowsCount >= this.timeseriesWriterConfig.getMaxBatchRowsCount()) {
                return false;
            }
            if (!this.allowDuplicatedRowInBatchRequest) {
                if (this.sendingTimeseriesKeys.contains(timeseriesRowWithGroup.timeseriesTableRow.getTimeseriesRow().getTimeseriesKey())) {
                    return false;
                }
                this.sendingTimeseriesKeys.add(timeseriesRowWithGroup.timeseriesTableRow.getTimeseriesRow().getTimeseriesKey());
            }
            this.timeseriesRowWithGroups.add(timeseriesRowWithGroup);
            this.totalSize += timeseriesRowWithGroup.timeseriesTableRow.getTimeseriesRow().getTimeseriesRowDataSize();
            ++this.totalRowsCount;
            return true;
        }
        catch (Exception e) {
            this.logger.error("Failed while append TimeseriesRow:", (Throwable)e);
            return false;
        }
    }

    @Override
    public int getTotalRowsCount() {
        return this.totalRowsCount;
    }

    @Override
    public void clear() {
        this.timeseriesRowWithGroups.clear();
        this.sendingTimeseriesKeys.clear();
        this.totalSize = 0;
        this.totalRowsCount = 0;
    }
}

