/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer.retry;

import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.writer.retry.BaseWriterRetryStrategy;
import java.util.concurrent.TimeUnit;

public class CertainCodeRetryStrategy
extends BaseWriterRetryStrategy {
    public CertainCodeRetryStrategy() {
        super(10L, TimeUnit.SECONDS);
    }

    public CertainCodeRetryStrategy(long timeout, TimeUnit unit) {
        super(timeout, unit);
    }

    @Override
    public RetryStrategy clone() {
        return new CertainCodeRetryStrategy(this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    protected boolean retryNotMatterActions(String errorCode) {
        return "OTSInternalServerError".equals(errorCode) || "OTSRequestTimeout".equals(errorCode) || "OTSPartitionUnavailable".equals(errorCode) || "OTSTableNotReady".equals(errorCode) || "OTSRowOperationConflict".equals(errorCode) || "OTSTimeout".equals(errorCode) || "OTSServerUnavailable".equals(errorCode) || "OTSServerBusy".equals(errorCode);
    }

    @Override
    public boolean shouldRetry(Exception ex) {
        return super.shouldRetry(ex);
    }

    @Override
    public long nextPause(String action, Exception ex) {
        return super.nextPause(action, ex);
    }
}

