/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.taircpc;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.taircpc.factory.CpcBuilderFactory;
import com.aliyun.tair.taircpc.params.CpcArrayMultiData;
import com.aliyun.tair.taircpc.params.CpcData;
import com.aliyun.tair.taircpc.params.CpcMultiArrayUpdateParams;
import com.aliyun.tair.taircpc.params.CpcMultiUpdateParams;
import com.aliyun.tair.taircpc.params.CpcUpdateParams;
import com.aliyun.tair.taircpc.results.Update2JudResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;

public class TairCpcPipeline
extends Pipeline {
    public TairCpcPipeline(Jedis jedis) {
        super(jedis);
    }

    public Response<Double> cpcEstimate(String key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCESTIMATE).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcEstimate(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCESTIMATE).add(key), BuilderFactory.DOUBLE));
    }

    public Response<String> cpcMUpdate(ArrayList<CpcData> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getKey() == null) {
                throw new IllegalArgumentException("ERR:The key is null");
            }
            if (key.getItem() != null) continue;
            throw new IllegalArgumentException("ERR:The value is null");
        }
        CpcMultiUpdateParams keyList = new CpcMultiUpdateParams();
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCMUPDATE).addObjects((Object[])keyList.getByteParams(keys)), BuilderFactory.STRING));
    }

    public Response<List<Double>> cpcMUpdate2Est(ArrayList<CpcData> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getKey() == null) {
                throw new IllegalArgumentException("ERR:The key is null");
            }
            if (key.getItem() != null) continue;
            throw new IllegalArgumentException("ERR:The value is null");
        }
        CpcMultiUpdateParams keyList = new CpcMultiUpdateParams();
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCMUPDATE2EST).addObjects((Object[])keyList.getByteParams(keys)), CpcBuilderFactory.CPCUPDATE2EST_MULTI_RESULT));
    }

    public Response<HashMap<String, Double>> cpcMUpdate2EstWithKey(ArrayList<CpcData> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getKey() != null) continue;
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getItem() != null) continue;
            throw new IllegalArgumentException("ERR:The value is null");
        }
        CpcMultiUpdateParams keyList = new CpcMultiUpdateParams();
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCMUPDATE2ESTWITHKEY).addObjects((Object[])keyList.getByteParams(keys)), CpcBuilderFactory.CPCUPDATE2ESTWITHKEY_MULTI_RESULT));
    }

    public Response<List<Update2JudResult>> cpcMUpdate2Jud(ArrayList<CpcData> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getKey() != null) continue;
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcData key : keys) {
            if (key.getItem() != null) continue;
            throw new IllegalArgumentException("ERR:The value is null");
        }
        CpcMultiUpdateParams keyList = new CpcMultiUpdateParams();
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCMUPDATE2JUD).addObjects((Object[])keyList.getByteParams(keys)), CpcBuilderFactory.CPCUPDATE2JUD_MULTI_RESULT));
    }

    public Response<String> cpcUpdate(String key, String item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE).add(key).add(item), BuilderFactory.STRING));
    }

    public Response<String> cpcUpdate(byte[] key, byte[] item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE).add(key).add(item), BuilderFactory.STRING));
    }

    public Response<String> cpcUpdate(String key, String item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)item))), BuilderFactory.STRING));
    }

    public Response<String> cpcUpdate(byte[] key, byte[] item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE).addObjects((Object[])params.getByteParams(key, item)), BuilderFactory.STRING));
    }

    public Response<Update2JudResult> cpcUpdate2Jud(String key, String item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE2JUD).add(key).add(item), CpcBuilderFactory.CPCUPDATE2JUD_RESULT));
    }

    public Response<Update2JudResult> cpcUpdate2Jud(byte[] key, byte[] item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE2JUD).add(key).add(item), CpcBuilderFactory.CPCUPDATE2JUD_RESULT));
    }

    public Response<Update2JudResult> cpcUpdate2Jud(String key, String item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE2JUD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)item))), CpcBuilderFactory.CPCUPDATE2JUD_RESULT));
    }

    public Response<Update2JudResult> cpcUpdate2Jud(byte[] key, byte[] item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE2JUD).addObjects((Object[])params.getByteParams(key, item)), CpcBuilderFactory.CPCUPDATE2JUD_RESULT));
    }

    public Response<Double> cpcUpdate2Est(String key, String item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE2EST).add(key).add(item), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcUpdate2Est(byte[] key, byte[] item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE2EST).add(key).add(item), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcUpdate2Est(String key, String item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE2EST).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)item))), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcUpdate2Est(byte[] key, byte[] item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCUPDATE2EST).addObjects((Object[])params.getByteParams(key, item)), BuilderFactory.DOUBLE));
    }

    public Response<String> cpcArrayUpdate(String key, long timestamp, String item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE).add(key).add(String.valueOf(timestamp)).add(item), BuilderFactory.STRING));
    }

    public Response<String> cpcArrayUpdate(byte[] key, long timestamp, byte[] item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE).add(key).add(Protocol.toByteArray((long)timestamp)).add(item), BuilderFactory.STRING));
    }

    public Response<String> cpcArrayUpdate(String key, long timestamp, String item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), SafeEncoder.encode((String)item))), BuilderFactory.STRING));
    }

    public Response<String> cpcArrayUpdate(byte[] key, long timestamp, byte[] item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)timestamp), item)), BuilderFactory.STRING));
    }

    public Response<Double> cpcArrayUpdate2Est(String key, long timestamp, String item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2EST).add(key).add(String.valueOf(timestamp)).add(item), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcArrayUpdate2Est(byte[] key, long timestamp, byte[] item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2EST).add(key).add(Protocol.toByteArray((long)timestamp)).add(item), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcArrayUpdate2Est(String key, long timestamp, String item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2EST).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), SafeEncoder.encode((String)item))), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcArrayUpdate2Est(byte[] key, long timestamp, byte[] item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2EST).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)timestamp), item)), BuilderFactory.DOUBLE));
    }

    public Response<Update2JudResult> cpcArrayUpdate2Jud(String key, long timestamp, String item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2JUD).add(key).add(String.valueOf(timestamp)).add(item), CpcBuilderFactory.CPCUPDATE2JUD_RESULT));
    }

    public Response<Update2JudResult> cpcArrayUpdate2Jud(byte[] key, long timestamp, byte[] item) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2JUD).add(key).add(Protocol.toByteArray((long)timestamp)).add(item), CpcBuilderFactory.CPCUPDATE2JUD_RESULT));
    }

    public Response<Update2JudResult> cpcArrayUpdate2Jud(String key, long timestamp, String item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2JUD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), SafeEncoder.encode((String)item))), CpcBuilderFactory.CPCUPDATE2JUD_RESULT));
    }

    public Response<Update2JudResult> cpcArrayUpdate2Jud(byte[] key, long timestamp, byte[] item, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        if (item == null) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYUPDATE2JUD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)timestamp), item)), CpcBuilderFactory.CPCUPDATE2JUD_RESULT));
    }

    public Response<Double> cpcArrayEstimate(String key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATE).add(key).add(String.valueOf(timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcArrayEstimate(byte[] key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATE).add(key).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<List<Double>> cpcArrayEstimateRange(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGE).add(key).add(String.valueOf(starttime)).add(String.valueOf(endtime)), CpcBuilderFactory.CPCARRAY_ESTIMATE_RANGE_RESULT));
    }

    public Response<List<Double>> cpcArrayEstimateRange(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_ESTIMATE_RANGE_RESULT));
    }

    public Response<Double> cpcArrayEstimateRangeSum(String key, long timestamp, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGESUM).add(key).add(String.valueOf(timestamp)).add(String.valueOf(range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcArrayEstimateRangeSum(byte[] key, long timestamp, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGESUM).add(key).add(Protocol.toByteArray((long)timestamp)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcArrayEstimateRangeMerge(String key, long timestamp, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGEMERGE).add(key).add(String.valueOf(timestamp)).add(String.valueOf(range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcArrayEstimateRangeMerge(byte[] key, long timestamp, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATERANGEMERGE).add(key).add(Protocol.toByteArray((long)timestamp)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public int getSlot(String key) {
        return JedisClusterCRC16.getSlot((String)key);
    }

    public Response<Double> cpcArrayEstimateTimeMerge(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATETIMEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> cpcArrayEstimateTimeMerge(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CPCARRAYESTIMATETIMEMERGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumAdd(String key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMADD).add(key).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumAdd(byte[] key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMADD).add(key).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumAdd(String key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumAdd(byte[] key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumSet(String key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMSET).add(key).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumSet(byte[] key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMSET).add(key).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumSet(String key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMSET).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumSet(byte[] key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMSET).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumGet(String key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMGET).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumGet(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMGET).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumArrayAdd(String key, long timestamp, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYADD).add(key).add(String.valueOf(timestamp)).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumArrayAdd(byte[] key, long timestamp, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYADD).add(key).add(Protocol.toByteArray((long)timestamp)).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumArrayAdd(String key, long timestamp, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumArrayAdd(byte[] key, long timestamp, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumArrayGet(String key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYGET).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumArrayGet(byte[] key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYGET).add(key).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<List<Double>> sumArrayGetRange(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYGETRANGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<List<Double>> sumArrayGetRange(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYGETRANGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<Double> sumArrayGetRangeTimeMerge(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYGETTIMEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYGETTIMEMERGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumArrayGetRangeMerge(String key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYGETRANGEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> sumArrayGetRangeMerge(byte[] key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SUMARRAYGETRANGEMERGE).add(key).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxAdd(String key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXADD).add(key).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxAdd(byte[] key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXADD).add(key).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxAdd(String key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxAdd(byte[] key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxSet(String key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXSET).add(key).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxSet(byte[] key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXSET).add(key).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxSet(String key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXSET).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxSet(byte[] key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXSET).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxGet(String key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXGET).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxGet(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXGET).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxArrayAdd(String key, long timestamp, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYADD).add(key).add(String.valueOf(timestamp)).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxArrayAdd(byte[] key, long timestamp, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYADD).add(key).add(Protocol.toByteArray((long)timestamp)).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxArrayAdd(String key, long timestamp, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxArrayAdd(byte[] key, long timestamp, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxArrayGet(String key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYGET).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxArrayGet(byte[] key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYGET).add(key).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<List<Double>> maxArrayGetRange(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYGETRANGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<List<Double>> maxArrayGetRange(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYGETRANGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<Double> maxArrayGetRangeTimeMerge(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYGETTIMEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYGETTIMEMERGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxArrayGetRangeMerge(String key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYGETRANGEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> maxArrayGetRangeMerge(byte[] key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MAXARRAYGETRANGEMERGE).add(key).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minAdd(String key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINADD).add(key).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minAdd(byte[] key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINADD).add(key).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minAdd(String key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> minAdd(byte[] key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> minSet(String key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINSET).add(key).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minSet(byte[] key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINSET).add(key).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minSet(String key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINSET).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> minSet(byte[] key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINSET).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> minGet(String key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINGET).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> minGet(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINGET).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> minArrayAdd(String key, long timestamp, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYADD).add(key).add(String.valueOf(timestamp)).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minArrayAdd(byte[] key, long timestamp, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYADD).add(key).add(Protocol.toByteArray((long)timestamp)).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minArrayAdd(String key, long timestamp, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> minArrayAdd(byte[] key, long timestamp, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> minArrayGet(String key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYGET).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minArrayGet(byte[] key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYGET).add(key).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<List<Double>> minArrayGetRange(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYGETRANGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<List<Double>> minArrayGetRange(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYGETRANGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<Double> minArrayGetRangeTimeMerge(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYGETTIMEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYGETTIMEMERGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minArrayGetRangeMerge(String key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYGETRANGEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> minArrayGetRangeMerge(byte[] key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.MINARRAYGETRANGEMERGE).add(key).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<String> firstAdd(String key, String content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTADD).add(key).add(content).add(String.valueOf(value)), BuilderFactory.STRING));
    }

    public Response<String> firstAdd(byte[] key, byte[] content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTADD).add(key).add(content).add(Protocol.toByteArray((double)value)), BuilderFactory.STRING));
    }

    public Response<String> firstAdd(String key, String content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> firstAdd(byte[] key, byte[] content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTADD).addObjects((Object[])params.getByteParams(key, content, Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> firstSet(String key, String content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTSET).add(key).add(content).add(String.valueOf(value)), BuilderFactory.STRING));
    }

    public Response<String> firstSet(byte[] key, byte[] content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTSET).add(key).add(content).add(Protocol.toByteArray((double)value)), BuilderFactory.STRING));
    }

    public Response<String> firstSet(String key, String content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTSET).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> firstSet(byte[] key, byte[] content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTSET).addObjects((Object[])params.getByteParams(key, content, Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> firstGet(String key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTGET).add(key), BuilderFactory.STRING));
    }

    public Response<String> firstGet(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTGET).add(key), BuilderFactory.STRING));
    }

    public Response<String> firstArrayAdd(String key, long timestamp, String content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTARRAYADD).add(key).add(String.valueOf(timestamp)).add(content).add(String.valueOf(value)), BuilderFactory.STRING));
    }

    public Response<String> firstArrayAdd(byte[] key, long timestamp, byte[] content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTARRAYADD).add(key).add(Protocol.toByteArray((long)timestamp)).add(content).add(Protocol.toByteArray((double)value)), BuilderFactory.STRING));
    }

    public Response<String> firstArrayAdd(String key, long timestamp, String content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTARRAYADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> firstArrayAdd(byte[] key, long timestamp, byte[] content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTARRAYADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)timestamp), content, Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> firstArrayGet(String key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTARRAYGET).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.STRING));
    }

    public Response<String> firstArrayGet(byte[] key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTARRAYGET).add(key).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.STRING));
    }

    public Response<String> firstArrayGetRangeTimeMerge(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTARRAYGETTIMEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.STRING));
    }

    public Response<String> firstArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTARRAYGETTIMEMERGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.STRING));
    }

    public Response<String> firstArrayGetRangeMerge(String key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTARRAYGETRANGEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.STRING));
    }

    public Response<String> firstArrayGetRangeMerge(byte[] key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.FIRSTARRAYGETRANGEMERGE).add(key).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.STRING));
    }

    public Response<String> lastAdd(String key, String content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTADD).add(key).add(content).add(String.valueOf(value)), BuilderFactory.STRING));
    }

    public Response<String> lastAdd(byte[] key, byte[] content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTADD).add(key).add(content).add(Protocol.toByteArray((double)value)), BuilderFactory.STRING));
    }

    public Response<String> lastAdd(String key, String content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> lastAdd(byte[] key, byte[] content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTADD).addObjects((Object[])params.getByteParams(key, content, Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> lastSet(String key, String content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTSET).add(key).add(content).add(String.valueOf(value)), BuilderFactory.STRING));
    }

    public Response<String> lastSet(byte[] key, byte[] content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTSET).add(key).add(content).add(Protocol.toByteArray((double)value)), BuilderFactory.STRING));
    }

    public Response<String> lastSet(String key, String content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTSET).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> lastSet(byte[] key, byte[] content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTSET).addObjects((Object[])params.getByteParams(key, content, Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> lastGet(String key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTGET).add(key), BuilderFactory.STRING));
    }

    public Response<String> lastGet(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTGET).add(key), BuilderFactory.STRING));
    }

    public Response<String> lastArrayAdd(String key, long timestamp, String content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTARRAYADD).add(key).add(String.valueOf(timestamp)).add(content).add(String.valueOf(value)), BuilderFactory.STRING));
    }

    public Response<String> lastArrayAdd(byte[] key, long timestamp, byte[] content, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTARRAYADD).add(key).add(Protocol.toByteArray((long)timestamp)).add(content).add(Protocol.toByteArray((double)value)), BuilderFactory.STRING));
    }

    public Response<String> lastArrayAdd(String key, long timestamp, String content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTARRAYADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), SafeEncoder.encode((String)content), Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> lastArrayAdd(byte[] key, long timestamp, byte[] content, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTARRAYADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)timestamp), content, Protocol.toByteArray((double)value))), BuilderFactory.STRING));
    }

    public Response<String> lastArrayGet(String key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTARRAYGET).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.STRING));
    }

    public Response<String> lastArrayGet(byte[] key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTARRAYGET).add(key).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.STRING));
    }

    public Response<String> lastArrayGetRangeTimeMerge(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTARRAYGETTIMEEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.STRING));
    }

    public Response<String> lastArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTARRAYGETTIMEEMERGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.STRING));
    }

    public Response<String> lastArrayGetRangeMerge(String key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTARRAYGETRANGEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.STRING));
    }

    public Response<String> lastArrayGetRangeMerge(byte[] key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.LASTARRAYGETRANGEMERGE).add(key).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.STRING));
    }

    public Response<Double> avgAdd(String key, long count, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGADD).add(key).add(String.valueOf(count)).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgAdd(byte[] key, long count, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGADD).add(key).add(Protocol.toByteArray((long)count)).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgAdd(String key, long count, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)count), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgAdd(byte[] key, long count, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)count), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgSet(String key, long count, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGSET).add(key).add(String.valueOf(count)).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgSet(byte[] key, long count, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGSET).add(key).add(Protocol.toByteArray((long)count)).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgSet(String key, long count, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGSET).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)count), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgSet(byte[] key, long count, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGSET).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)count), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgGet(String key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGGET).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgGet(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGGET).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgArrayAdd(String key, long timestamp, long count, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYADD).add(key).add(String.valueOf(timestamp)).add(String.valueOf(count)).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgArrayAdd(byte[] key, long timestamp, long count, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYADD).add(key).add(Protocol.toByteArray((long)timestamp)).add(Protocol.toByteArray((long)count)).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgArrayAdd(String key, long timestamp, long count, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), Protocol.toByteArray((long)count), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgArrayAdd(byte[] key, long timestamp, long count, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((long)count), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgArrayGet(String key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYGET).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgArrayGet(byte[] key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYGET).add(key).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<List<Double>> avgArrayGetRange(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYGETRANGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<List<Double>> avgArrayGetRange(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYGETRANGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<Double> avgArrayGetRangeTimeMerge(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYGETTIMEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYGETTIMEMERGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgArrayGetRangeMerge(String key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYGETRANGEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> avgArrayGetRangeMerge(byte[] key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.AVGARRAYGETRANGEMERGE).add(key).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevAdd(String key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVADD).add(key).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevAdd(byte[] key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVADD).add(key).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevAdd(String key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevAdd(byte[] key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevSet(String key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVSET).add(key).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevSet(byte[] key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVSET).add(key).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevSet(String key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVSET).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevSet(byte[] key, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVSET).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevGet(String key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVGET).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevGet(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVGET).add(key), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevArrayAdd(String key, long timestamp, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYADD).add(key).add(String.valueOf(timestamp)).add(String.valueOf(value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevArrayAdd(byte[] key, long timestamp, double value) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYADD).add(key).add(Protocol.toByteArray((long)timestamp)).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevArrayAdd(String key, long timestamp, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevArrayAdd(byte[] key, long timestamp, double value, CpcUpdateParams params) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYADD).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)timestamp), Protocol.toByteArray((double)value))), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevArrayGet(String key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYGET).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevArrayGet(byte[] key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYGET).add(key).add(Protocol.toByteArray((long)timestamp)), BuilderFactory.DOUBLE));
    }

    public Response<List<Double>> stddevArrayGetRange(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYGETRANGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<List<Double>> stddevArrayGetRange(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYGETRANGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<Double> stddevArrayGetRangeTimeMerge(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYGETTIMEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevArrayGetRangeTimeMerge(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYGETTIMEMERGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevArrayGetRangeMerge(String key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYGETRANGEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<Double> stddevArrayGetRangeMerge(byte[] key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.STDDEVARRAYGETRANGEMERGE).add(key).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), BuilderFactory.DOUBLE));
    }

    public Response<Object> sketchesGet(String key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SKETCHESGET).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)timestamp)), CpcBuilderFactory.SKETCHES_GET_RESULT));
    }

    public Response<Object> sketchesGet(byte[] key, long timestamp) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SKETCHESGET).add(key).add(Protocol.toByteArray((long)timestamp)), CpcBuilderFactory.SKETCHES_GET_RESULT));
    }

    public Response<Object> sketchesGetRangeMerge(String key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SKETCHESRANGEMERGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), CpcBuilderFactory.SKETCHES_GET_RESULT));
    }

    public Response<Object> sketchesGetRangeMerge(byte[] key, long endtime, long range) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SKETCHESRANGEMERGE).add(key).add(Protocol.toByteArray((long)endtime)).add(Protocol.toByteArray((long)range)), CpcBuilderFactory.SKETCHES_GET_RESULT));
    }

    public Response<List<Double>> sketchesGetRange(String key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SKETCHESRANGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<List<Double>> sketchesGetRange(byte[] key, long starttime, long endtime) {
        if (key == null) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SKETCHESRANGE).add(key).add(Protocol.toByteArray((long)starttime)).add(Protocol.toByteArray((long)endtime)), CpcBuilderFactory.CPCARRAY_RANGE_RESULT));
    }

    public Response<String> sketchesBatchWrite(ArrayList<CpcArrayMultiData> keys) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("ERR:The key is null");
        }
        for (CpcArrayMultiData key : keys) {
            if (key.getKey() != null) continue;
            throw new IllegalArgumentException("ERR:The key is null");
        }
        CpcMultiArrayUpdateParams keyList = new CpcMultiArrayUpdateParams();
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.SKETCHESBATCHWRITE).addObjects((Object[])keyList.getByteMultiParams(keys)), BuilderFactory.STRING));
    }
}

