/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations.bucket.terms;

import com.aliyun.tair.tairsearch.search.aggregations.bucket.terms.InternalMappedTerms;
import com.aliyun.tair.tairsearch.search.aggregations.bucket.terms.InternalTerms;
import com.google.gson.JsonObject;
import java.util.Objects;

public class StringTerms
extends InternalMappedTerms<StringTerms, Bucket> {
    public static final String NAME = "sterms";

    public StringTerms(String name, JsonObject in) {
        super(name, in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public static class Bucket
    extends InternalTerms.Bucket<Bucket> {
        String termBytes;

        public Bucket(JsonObject in) {
            super(in);
            this.termBytes = in.get("key").getAsString();
        }

        @Override
        public Object getKey() {
            return this.getKeyAsString();
        }

        @Override
        public Number getKeyAsNumber() {
            try {
                return Long.parseLong(this.termBytes);
            }
            catch (NumberFormatException ignored) {
                return Double.parseDouble(this.termBytes);
            }
        }

        @Override
        public String getKeyAsString() {
            return this.termBytes;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.termBytes, ((Bucket)obj).termBytes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.termBytes);
        }
    }
}

