/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations.metrics;

import com.aliyun.tair.tairsearch.search.aggregations.metrics.ExtendedStats;
import com.aliyun.tair.tairsearch.search.aggregations.metrics.InternalStats;
import com.google.gson.JsonObject;
import java.util.Objects;

public class InternalExtendedStats
extends InternalStats
implements ExtendedStats {
    private final double sumOfSqrs;
    protected final double variance;
    protected final double stdDeviation;

    public InternalExtendedStats(String name, JsonObject in) {
        super(name, in);
        this.variance = in.get(Metrics.variance.name()).getAsDouble();
        this.stdDeviation = in.get(Metrics.std_deviation.name()).getAsDouble();
        this.sumOfSqrs = in.get(Metrics.sum_of_squares.name()).getAsDouble();
    }

    @Override
    public String getWriteableName() {
        return "extended_stats";
    }

    @Override
    public double value(String name) {
        if ("sum_of_squares".equals(name)) {
            return this.sumOfSqrs;
        }
        if ("variance".equals(name)) {
            return this.variance;
        }
        if ("std_deviation".equals(name)) {
            return this.stdDeviation;
        }
        return super.value(name);
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSqrs;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getStdDeviation() {
        return this.stdDeviation;
    }

    @Override
    public String getSumOfSquaresAsString() {
        return this.valueAsString(Metrics.sum_of_squares.name());
    }

    @Override
    public String getVarianceAsString() {
        return this.valueAsString(Metrics.variance.name());
    }

    @Override
    public String getStdDeviationAsString() {
        return this.valueAsString(Metrics.std_deviation.name());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sumOfSqrs, this.variance, this.stdDeviation);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalExtendedStats other = (InternalExtendedStats)obj;
        return Double.compare(this.sumOfSqrs, other.sumOfSqrs) == 0 && Double.compare(this.variance, other.variance) == 0 && Double.compare(this.stdDeviation, other.stdDeviation) == 0;
    }

    static enum Metrics {
        count,
        sum,
        min,
        max,
        avg,
        sum_of_squares,
        variance,
        std_deviation;


        public static Metrics resolve(String name) {
            return Metrics.valueOf(name);
        }
    }
}

