/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.core.util.Base64Util;
import com.azure.core.util.BinaryData;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class EmbeddingsUtils {
    public static BinaryData addEncodingFormat(BinaryData inputJson) {
        Map mapJson = (Map)inputJson.toObject(Map.class);
        if (mapJson.containsKey("encoding_format")) {
            return inputJson;
        }
        mapJson.put("encoding_format", "base64");
        return BinaryData.fromObject((Object)mapJson);
    }

    public static List<Float> convertBase64ToFloatList(String embedding) {
        byte[] bytes = Base64Util.decodeString((String)embedding);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        ArrayList<Float> floatList = new ArrayList<Float>(floatBuffer.remaining());
        while (floatBuffer.hasRemaining()) {
            floatList.add(Float.valueOf(floatBuffer.get()));
        }
        return floatList;
    }
}

