/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataContextProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AzureMachineLearningIndexChatExtensionParameters
implements JsonSerializable<AzureMachineLearningIndexChatExtensionParameters> {
    private OnYourDataAuthenticationOptions authentication;
    private Integer topNDocuments;
    private Boolean inScope;
    private Integer strictness;
    private String roleInformation;
    private final String projectResourceId;
    private final String name;
    private final String version;
    private String filter;
    private Integer maxSearchQueries;
    private Boolean allowPartialResult;
    private List<OnYourDataContextProperty> includeContexts;

    public AzureMachineLearningIndexChatExtensionParameters(String projectResourceId, String name, String version) {
        this.projectResourceId = projectResourceId;
        this.name = name;
        this.version = version;
    }

    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    public AzureMachineLearningIndexChatExtensionParameters setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    public AzureMachineLearningIndexChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    public Boolean isInScope() {
        return this.inScope;
    }

    public AzureMachineLearningIndexChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    public Integer getStrictness() {
        return this.strictness;
    }

    public AzureMachineLearningIndexChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    public String getRoleInformation() {
        return this.roleInformation;
    }

    public AzureMachineLearningIndexChatExtensionParameters setRoleInformation(String roleInformation) {
        this.roleInformation = roleInformation;
        return this;
    }

    public String getProjectResourceId() {
        return this.projectResourceId;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFilter() {
        return this.filter;
    }

    public AzureMachineLearningIndexChatExtensionParameters setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("project_resource_id", this.projectResourceId);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
        jsonWriter.writeNumberField("top_n_documents", (Number)this.topNDocuments);
        jsonWriter.writeBooleanField("in_scope", this.inScope);
        jsonWriter.writeNumberField("strictness", (Number)this.strictness);
        jsonWriter.writeStringField("role_information", this.roleInformation);
        jsonWriter.writeNumberField("max_search_queries", (Number)this.maxSearchQueries);
        jsonWriter.writeBooleanField("allow_partial_result", this.allowPartialResult);
        jsonWriter.writeArrayField("include_contexts", this.includeContexts, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("filter", this.filter);
        return jsonWriter.writeEndObject();
    }

    public static AzureMachineLearningIndexChatExtensionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMachineLearningIndexChatExtensionParameters)jsonReader.readObject(reader -> {
            String projectResourceId = null;
            String name = null;
            String version = null;
            OnYourDataAuthenticationOptions authentication = null;
            Integer topNDocuments = null;
            Boolean inScope = null;
            Integer strictness = null;
            String roleInformation = null;
            Integer maxSearchQueries = null;
            Boolean allowPartialResult = null;
            List includeContexts = null;
            String filter = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("project_resource_id".equals(fieldName)) {
                    projectResourceId = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    version = reader.getString();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    authentication = OnYourDataAuthenticationOptions.fromJson(reader);
                    continue;
                }
                if ("top_n_documents".equals(fieldName)) {
                    topNDocuments = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("in_scope".equals(fieldName)) {
                    inScope = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("strictness".equals(fieldName)) {
                    strictness = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("role_information".equals(fieldName)) {
                    roleInformation = reader.getString();
                    continue;
                }
                if ("max_search_queries".equals(fieldName)) {
                    maxSearchQueries = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allow_partial_result".equals(fieldName)) {
                    allowPartialResult = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("include_contexts".equals(fieldName)) {
                    includeContexts = reader.readArray(reader1 -> OnYourDataContextProperty.fromString(reader1.getString()));
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    filter = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            AzureMachineLearningIndexChatExtensionParameters deserializedAzureMachineLearningIndexChatExtensionParameters = new AzureMachineLearningIndexChatExtensionParameters(projectResourceId, name, version);
            deserializedAzureMachineLearningIndexChatExtensionParameters.authentication = authentication;
            deserializedAzureMachineLearningIndexChatExtensionParameters.topNDocuments = topNDocuments;
            deserializedAzureMachineLearningIndexChatExtensionParameters.inScope = inScope;
            deserializedAzureMachineLearningIndexChatExtensionParameters.strictness = strictness;
            deserializedAzureMachineLearningIndexChatExtensionParameters.roleInformation = roleInformation;
            deserializedAzureMachineLearningIndexChatExtensionParameters.maxSearchQueries = maxSearchQueries;
            deserializedAzureMachineLearningIndexChatExtensionParameters.allowPartialResult = allowPartialResult;
            deserializedAzureMachineLearningIndexChatExtensionParameters.includeContexts = includeContexts;
            deserializedAzureMachineLearningIndexChatExtensionParameters.filter = filter;
            return deserializedAzureMachineLearningIndexChatExtensionParameters;
        });
    }

    public Integer getMaxSearchQueries() {
        return this.maxSearchQueries;
    }

    public AzureMachineLearningIndexChatExtensionParameters setMaxSearchQueries(Integer maxSearchQueries) {
        this.maxSearchQueries = maxSearchQueries;
        return this;
    }

    public Boolean isAllowPartialResult() {
        return this.allowPartialResult;
    }

    public AzureMachineLearningIndexChatExtensionParameters setAllowPartialResult(Boolean allowPartialResult) {
        this.allowPartialResult = allowPartialResult;
        return this;
    }

    public List<OnYourDataContextProperty> getIncludeContexts() {
        return this.includeContexts;
    }

    public AzureMachineLearningIndexChatExtensionParameters setIncludeContexts(List<OnYourDataContextProperty> includeContexts) {
        this.includeContexts = includeContexts;
        return this;
    }
}

