/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureChatEnhancements;
import com.azure.ai.openai.models.ChatChoiceLogProbabilityInfo;
import com.azure.ai.openai.models.ChatFinishDetails;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.CompletionsFinishReason;
import com.azure.ai.openai.models.ContentFilterResultsForChoice;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatChoice
implements JsonSerializable<ChatChoice> {
    private ChatResponseMessage message;
    private final int index;
    private final CompletionsFinishReason finishReason;
    private ChatResponseMessage delta;
    private ContentFilterResultsForChoice contentFilterResults;
    private ChatFinishDetails finishDetails;
    private AzureChatEnhancements enhancements;
    private final ChatChoiceLogProbabilityInfo logprobs;

    public ChatResponseMessage getMessage() {
        return this.message;
    }

    public int getIndex() {
        return this.index;
    }

    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }

    public ChatResponseMessage getDelta() {
        return this.delta;
    }

    public ContentFilterResultsForChoice getContentFilterResults() {
        return this.contentFilterResults;
    }

    public ChatFinishDetails getFinishDetails() {
        return this.finishDetails;
    }

    public AzureChatEnhancements getEnhancements() {
        return this.enhancements;
    }

    private ChatChoice(ChatChoiceLogProbabilityInfo logprobs, int index, CompletionsFinishReason finishReason) {
        this.logprobs = logprobs;
        this.index = index;
        this.finishReason = finishReason;
    }

    public ChatChoiceLogProbabilityInfo getLogprobs() {
        return this.logprobs;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("logprobs", (JsonSerializable)this.logprobs);
        jsonWriter.writeIntField("index", this.index);
        jsonWriter.writeStringField("finish_reason", this.finishReason == null ? null : this.finishReason.toString());
        jsonWriter.writeJsonField("message", (JsonSerializable)this.message);
        jsonWriter.writeJsonField("finish_details", (JsonSerializable)this.finishDetails);
        jsonWriter.writeJsonField("delta", (JsonSerializable)this.delta);
        jsonWriter.writeJsonField("content_filter_results", (JsonSerializable)this.contentFilterResults);
        jsonWriter.writeJsonField("enhancements", (JsonSerializable)this.enhancements);
        return jsonWriter.writeEndObject();
    }

    public static ChatChoice fromJson(JsonReader jsonReader) throws IOException {
        return (ChatChoice)jsonReader.readObject(reader -> {
            ChatChoiceLogProbabilityInfo logprobs = null;
            int index = 0;
            CompletionsFinishReason finishReason = null;
            ChatResponseMessage message = null;
            ChatFinishDetails finishDetails = null;
            ChatResponseMessage delta = null;
            ContentFilterResultsForChoice contentFilterResults = null;
            AzureChatEnhancements enhancements = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logprobs".equals(fieldName)) {
                    logprobs = ChatChoiceLogProbabilityInfo.fromJson(reader);
                    continue;
                }
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("finish_reason".equals(fieldName)) {
                    finishReason = CompletionsFinishReason.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = ChatResponseMessage.fromJson(reader);
                    continue;
                }
                if ("finish_details".equals(fieldName)) {
                    finishDetails = ChatFinishDetails.fromJson(reader);
                    continue;
                }
                if ("delta".equals(fieldName)) {
                    delta = ChatResponseMessage.fromJson(reader);
                    continue;
                }
                if ("content_filter_results".equals(fieldName)) {
                    contentFilterResults = ContentFilterResultsForChoice.fromJson(reader);
                    continue;
                }
                if ("enhancements".equals(fieldName)) {
                    enhancements = AzureChatEnhancements.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            ChatChoice deserializedChatChoice = new ChatChoice(logprobs, index, finishReason);
            deserializedChatChoice.message = message;
            deserializedChatChoice.finishDetails = finishDetails;
            deserializedChatChoice.delta = delta;
            deserializedChatChoice.contentFilterResults = contentFilterResults;
            deserializedChatChoice.enhancements = enhancements;
            return deserializedChatChoice;
        });
    }
}

