// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the parameters for audio output.
 */
@Immutable
public final class AudioOutputParameters implements JsonSerializable<AudioOutputParameters> {

    /*
     * Specifies the voice type.
     */
    @Generated
    private final SpeechVoice voice;

    /*
     * Specifies the output audio format.
     */
    @Generated
    private final OutputAudioFormat format;

    /**
     * Creates an instance of AudioOutputParameters class.
     *
     * @param voice the voice value to set.
     * @param format the format value to set.
     */
    @Generated
    public AudioOutputParameters(SpeechVoice voice, OutputAudioFormat format) {
        this.voice = voice;
        this.format = format;
    }

    /**
     * Get the voice property: Specifies the voice type.
     *
     * @return the voice value.
     */
    @Generated
    public SpeechVoice getVoice() {
        return this.voice;
    }

    /**
     * Get the format property: Specifies the output audio format.
     *
     * @return the format value.
     */
    @Generated
    public OutputAudioFormat getFormat() {
        return this.format;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("voice", this.voice == null ? null : this.voice.toString());
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AudioOutputParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AudioOutputParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AudioOutputParameters.
     */
    @Generated
    public static AudioOutputParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SpeechVoice voice = null;
            OutputAudioFormat format = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("voice".equals(fieldName)) {
                    voice = SpeechVoice.fromString(reader.getString());
                } else if ("format".equals(fieldName)) {
                    format = OutputAudioFormat.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return new AudioOutputParameters(voice, format);
        });
    }
}
