// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

/**
 * Object containing audio response data and its metadata.
 */
@Immutable
public final class AudioResponseData implements JsonSerializable<AudioResponseData> {

    /*
     * Unique identifier for this audio response.
     */
    @Generated
    private final String id;

    /*
     * The Unix timestamp (in seconds) for when this audio response
     * will no longer be accessible on the server for use in multi-turn
     * conversations.
     */
    @Generated
    private final long expiresAt;

    /*
     * Base64 encoded audio bytes generated by the model, in the format
     * specified in the request.
     */
    @Generated
    private final String data;

    /*
     * Transcript of the audio generated by the model.
     */
    @Generated
    private final String transcript;

    /**
     * Creates an instance of AudioResponseData class.
     *
     * @param id the id value to set.
     * @param expiresAt the expiresAt value to set.
     * @param data the data value to set.
     * @param transcript the transcript value to set.
     */
    @Generated
    private AudioResponseData(String id, OffsetDateTime expiresAt, String data, String transcript) {
        this.id = id;
        if (expiresAt == null) {
            this.expiresAt = 0L;
        } else {
            this.expiresAt = expiresAt.toEpochSecond();
        }
        this.data = data;
        this.transcript = transcript;
    }

    /**
     * Get the id property: Unique identifier for this audio response.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the expiresAt property: The Unix timestamp (in seconds) for when this audio response
     * will no longer be accessible on the server for use in multi-turn
     * conversations.
     *
     * @return the expiresAt value.
     */
    @Generated
    public OffsetDateTime getExpiresAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiresAt), ZoneOffset.UTC);
    }

    /**
     * Get the data property: Base64 encoded audio bytes generated by the model, in the format
     * specified in the request.
     *
     * @return the data value.
     */
    @Generated
    public String getData() {
        return this.data;
    }

    /**
     * Get the transcript property: Transcript of the audio generated by the model.
     *
     * @return the transcript value.
     */
    @Generated
    public String getTranscript() {
        return this.transcript;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeLongField("expires_at", this.expiresAt);
        jsonWriter.writeStringField("data", this.data);
        jsonWriter.writeStringField("transcript", this.transcript);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AudioResponseData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AudioResponseData if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AudioResponseData.
     */
    @Generated
    public static AudioResponseData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime expiresAt = null;
            String data = null;
            String transcript = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("expires_at".equals(fieldName)) {
                    expiresAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("data".equals(fieldName)) {
                    data = reader.getString();
                } else if ("transcript".equals(fieldName)) {
                    transcript = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new AudioResponseData(id, expiresAt, data, transcript);
        });
    }
}
