// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the output results of Azure enhancements to chat completions, as configured via the matching input
 * provided
 * in the request.
 */
@Immutable
public final class AzureChatEnhancements implements JsonSerializable<AzureChatEnhancements> {

    /*
     * The grounding enhancement that returns the bounding box of the objects detected in the image.
     */
    @Generated
    private AzureGroundingEnhancement grounding;

    /**
     * Creates an instance of AzureChatEnhancements class.
     */
    @Generated
    private AzureChatEnhancements() {
    }

    /**
     * Get the grounding property: The grounding enhancement that returns the bounding box of the objects detected in
     * the image.
     *
     * @return the grounding value.
     */
    @Generated
    public AzureGroundingEnhancement getGrounding() {
        return this.grounding;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("grounding", this.grounding);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureChatEnhancements from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureChatEnhancements if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureChatEnhancements.
     */
    @Generated
    public static AzureChatEnhancements fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureChatEnhancements deserializedAzureChatEnhancements = new AzureChatEnhancements();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("grounding".equals(fieldName)) {
                    deserializedAzureChatEnhancements.grounding = AzureGroundingEnhancement.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAzureChatEnhancements;
        });
    }
}
