// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A representation of configuration data for a single Azure OpenAI chat extension. This will be used by a chat
 * completions request that should use Azure OpenAI chat extensions to augment the response behavior.
 * The use of this configuration is compatible only with Azure OpenAI.
 */
@Immutable
public class AzureChatExtensionConfiguration implements JsonSerializable<AzureChatExtensionConfiguration> {

    /**
     * Creates an instance of AzureChatExtensionConfiguration class.
     */
    @Generated
    public AzureChatExtensionConfiguration() {
    }

    /*
     * The label for the type of an Azure chat extension. This typically corresponds to a matching Azure resource.
     * Azure chat extensions are only compatible with Azure OpenAI.
     */
    @Generated
    private AzureChatExtensionType type = AzureChatExtensionType.fromString("AzureChatExtensionConfiguration");

    /**
     * Get the type property: The label for the type of an Azure chat extension. This typically corresponds to a
     * matching Azure resource.
     * Azure chat extensions are only compatible with Azure OpenAI.
     *
     * @return the type value.
     */
    @Generated
    public AzureChatExtensionType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureChatExtensionConfiguration from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureChatExtensionConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureChatExtensionConfiguration.
     */
    @Generated
    public static AzureChatExtensionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("azure_search".equals(discriminatorValue)) {
                    return AzureSearchChatExtensionConfiguration.fromJson(readerToUse.reset());
                } else if ("azure_cosmos_db".equals(discriminatorValue)) {
                    return AzureCosmosDBChatExtensionConfiguration.fromJson(readerToUse.reset());
                } else if ("elasticsearch".equals(discriminatorValue)) {
                    return ElasticsearchChatExtensionConfiguration.fromJson(readerToUse.reset());
                } else if ("mongo_db".equals(discriminatorValue)) {
                    return MongoDBChatExtensionConfiguration.fromJson(readerToUse.reset());
                } else if ("pinecone".equals(discriminatorValue)) {
                    return PineconeChatExtensionConfiguration.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static AzureChatExtensionConfiguration fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureChatExtensionConfiguration deserializedAzureChatExtensionConfiguration
                = new AzureChatExtensionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedAzureChatExtensionConfiguration.type
                        = AzureChatExtensionType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAzureChatExtensionConfiguration;
        });
    }
}
