// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A content line object consisting of an adjacent sequence of content elements, such as words and selection marks.
 */
@Immutable
public final class AzureGroundingEnhancementLine implements JsonSerializable<AzureGroundingEnhancementLine> {

    /*
     * The text within the line.
     */
    @Generated
    private final String text;

    /*
     * An array of spans that represent detected objects and its bounding box information.
     */
    @Generated
    private final List<AzureGroundingEnhancementLineSpan> spans;

    /**
     * Creates an instance of AzureGroundingEnhancementLine class.
     *
     * @param text the text value to set.
     * @param spans the spans value to set.
     */
    @Generated
    private AzureGroundingEnhancementLine(String text, List<AzureGroundingEnhancementLineSpan> spans) {
        this.text = text;
        this.spans = spans;
    }

    /**
     * Get the text property: The text within the line.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the spans property: An array of spans that represent detected objects and its bounding box information.
     *
     * @return the spans value.
     */
    @Generated
    public List<AzureGroundingEnhancementLineSpan> getSpans() {
        return this.spans;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureGroundingEnhancementLine from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureGroundingEnhancementLine if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureGroundingEnhancementLine.
     */
    @Generated
    public static AzureGroundingEnhancementLine fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            List<AzureGroundingEnhancementLineSpan> spans = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> AzureGroundingEnhancementLineSpan.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            return new AzureGroundingEnhancementLine(text, spans);
        });
    }
}
