// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The BatchRequestCounts model.
 */
@Immutable
public final class BatchRequestCounts implements JsonSerializable<BatchRequestCounts> {

    /*
     * Total number of requests in the batch.
     */
    @Generated
    private Integer total;

    /*
     * Number of requests that have been completed successfully.
     */
    @Generated
    private Integer completed;

    /*
     * Number of requests that have failed.
     */
    @Generated
    private Integer failed;

    /**
     * Get the total property: Total number of requests in the batch.
     *
     * @return the total value.
     */
    @Generated
    public Integer getTotal() {
        return this.total;
    }

    /**
     * Get the completed property: Number of requests that have been completed successfully.
     *
     * @return the completed value.
     */
    @Generated
    public Integer getCompleted() {
        return this.completed;
    }

    /**
     * Get the failed property: Number of requests that have failed.
     *
     * @return the failed value.
     */
    @Generated
    public Integer getFailed() {
        return this.failed;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("total", this.total);
        jsonWriter.writeNumberField("completed", this.completed);
        jsonWriter.writeNumberField("failed", this.failed);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BatchRequestCounts from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BatchRequestCounts if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BatchRequestCounts.
     */
    @Generated
    public static BatchRequestCounts fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BatchRequestCounts deserializedBatchRequestCounts = new BatchRequestCounts();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("total".equals(fieldName)) {
                    deserializedBatchRequestCounts.total = reader.getNullable(JsonReader::getInt);
                } else if ("completed".equals(fieldName)) {
                    deserializedBatchRequestCounts.completed = reader.getNullable(JsonReader::getInt);
                } else if ("failed".equals(fieldName)) {
                    deserializedBatchRequestCounts.failed = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedBatchRequestCounts;
        });
    }

    /**
     * Creates an instance of BatchRequestCounts class.
     */
    @Generated
    private BatchRequestCounts() {
    }
}
