// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Log probability information for a choice, as requested via 'logprobs' and 'top_logprobs'.
 */
@Immutable
public final class ChatChoiceLogProbabilityInfo implements JsonSerializable<ChatChoiceLogProbabilityInfo> {

    /*
     * The list of log probability information entries for the choice's message content tokens, as requested via the
     * 'logprobs' option.
     */
    @Generated
    private final List<ChatTokenLogProbabilityResult> content;

    /**
     * Get the content property: The list of log probability information entries for the choice's message content
     * tokens, as requested via the 'logprobs' option.
     *
     * @return the content value.
     */
    @Generated
    public List<ChatTokenLogProbabilityResult> getContent() {
        return this.content;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("refusal", this.refusal, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatChoiceLogProbabilityInfo from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatChoiceLogProbabilityInfo if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatChoiceLogProbabilityInfo.
     */
    @Generated
    public static ChatChoiceLogProbabilityInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<ChatTokenLogProbabilityResult> content = null;
            List<ChatTokenLogProbabilityResult> refusal = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> ChatTokenLogProbabilityResult.fromJson(reader1));
                } else if ("refusal".equals(fieldName)) {
                    refusal = reader.readArray(reader1 -> ChatTokenLogProbabilityResult.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            return new ChatChoiceLogProbabilityInfo(content, refusal);
        });
    }

    /*
     * The list of log probability information entries for the choice's message refusal message tokens, as requested via
     * the 'logprobs' option.
     */
    @Generated
    private final List<ChatTokenLogProbabilityResult> refusal;

    /**
     * Creates an instance of ChatChoiceLogProbabilityInfo class.
     *
     * @param content the content value to set.
     * @param refusal the refusal value to set.
     */
    @Generated
    private ChatChoiceLogProbabilityInfo(List<ChatTokenLogProbabilityResult> content,
        List<ChatTokenLogProbabilityResult> refusal) {
        this.content = content;
        this.refusal = refusal;
    }

    /**
     * Get the refusal property: The list of log probability information entries for the choice's message refusal
     * message tokens, as requested via the 'logprobs' option.
     *
     * @return the refusal value.
     */
    @Generated
    public List<ChatTokenLogProbabilityResult> getRefusal() {
        return this.refusal;
    }
}
