// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Values to specified the required modality for the model to use.
 */
public final class ChatCompletionModality extends ExpandableStringEnum<ChatCompletionModality> {

    /**
     * The model is to generate text output.
     */
    @Generated
    public static final ChatCompletionModality TEXT = fromString("text");

    /**
     * The model is to generate audio output.
     */
    @Generated
    public static final ChatCompletionModality AUDIO = fromString("audio");

    /**
     * Creates a new instance of ChatCompletionModality value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ChatCompletionModality() {
    }

    /**
     * Creates or finds a ChatCompletionModality from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ChatCompletionModality.
     */
    @Generated
    public static ChatCompletionModality fromString(String name) {
        return fromString(name, ChatCompletionModality.class);
    }

    /**
     * Gets known ChatCompletionModality values.
     *
     * @return known ChatCompletionModality values.
     */
    @Generated
    public static Collection<ChatCompletionModality> values() {
        return values(ChatCompletionModality.class);
    }
}
