// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ChatCompletionsFunctionToolDefinitionFunction model.
 */
@Fluent
public final class ChatCompletionsFunctionToolDefinitionFunction
    implements JsonSerializable<ChatCompletionsFunctionToolDefinitionFunction> {

    /*
     * A description of what the function does, used by the model to choose when and how to call the function.
     */
    @Generated
    private String description;

    /*
     * The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum
     * length of 64.
     */
    @Generated
    private final String name;

    /*
     * The parameters property.
     */
    private BinaryData parameters;

    /*
     * Whether to enable strict schema adherence when generating the function call. If set to true, the model will
     * follow the exact schema defined in the `parameters` field. Only a subset of JSON Schema is supported when
     * `strict` is `true`. Learn more about Structured Outputs in the [function calling
     * guide](docs/guides/function-calling).
     */
    @Generated
    private Boolean strict;

    /**
     * Creates an instance of ChatCompletionsFunctionToolDefinitionFunction class.
     *
     * @param name the name value to set.
     */
    @Generated
    public ChatCompletionsFunctionToolDefinitionFunction(String name) {
        this.name = name;
    }

    /**
     * Get the description property: A description of what the function does, used by the model to choose when and how
     * to call the function.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: A description of what the function does, used by the model to choose when and how
     * to call the function.
     *
     * @param description the description value to set.
     * @return the ChatCompletionsFunctionToolDefinitionFunction object itself.
     */
    @Generated
    public ChatCompletionsFunctionToolDefinitionFunction setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the name property: The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and
     * dashes, with a maximum length of 64.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the parameters property: The parameters property.
     *
     * @return the parameters value.
     */
    public BinaryData getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameters property.
     *
     * @param parameters the parameters value to set.
     * @return the ChatCompletionsFunctionToolDefinitionFunction object itself.
     */
    public ChatCompletionsFunctionToolDefinitionFunction setParameters(BinaryData parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the strict property: Whether to enable strict schema adherence when generating the function call. If set to
     * true, the model will follow the exact schema defined in the `parameters` field. Only a subset of JSON Schema is
     * supported when `strict` is `true`. Learn more about Structured Outputs in the [function calling
     * guide](docs/guides/function-calling).
     *
     * @return the strict value.
     */
    @Generated
    public Boolean isStrict() {
        return this.strict;
    }

    /**
     * Set the strict property: Whether to enable strict schema adherence when generating the function call. If set to
     * true, the model will follow the exact schema defined in the `parameters` field. Only a subset of JSON Schema is
     * supported when `strict` is `true`. Learn more about Structured Outputs in the [function calling
     * guide](docs/guides/function-calling).
     *
     * @param strict the strict value to set.
     * @return the ChatCompletionsFunctionToolDefinitionFunction object itself.
     */
    @Generated
    public ChatCompletionsFunctionToolDefinitionFunction setStrict(Boolean strict) {
        this.strict = strict;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeRawField("parameters", this.parameters.toString());
        jsonWriter.writeBooleanField("strict", this.strict);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsFunctionToolDefinitionFunction from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsFunctionToolDefinitionFunction if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatCompletionsFunctionToolDefinitionFunction.
     */
    public static ChatCompletionsFunctionToolDefinitionFunction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String name = null;
            String description = null;
            BinaryData parameters = null;
            Boolean strict = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("parameters".equals(fieldName)) {
                    parameters = BinaryData.fromObject(reader.readUntyped());
                } else if ("strict".equals(fieldName)) {
                    strict = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            ChatCompletionsFunctionToolDefinitionFunction deserializedChatCompletionsFunctionToolDefinitionFunction
                = new ChatCompletionsFunctionToolDefinitionFunction(name);
            deserializedChatCompletionsFunctionToolDefinitionFunction.description = description;
            deserializedChatCompletionsFunctionToolDefinitionFunction.parameters = parameters;
            deserializedChatCompletionsFunctionToolDefinitionFunction.strict = strict;
            return deserializedChatCompletionsFunctionToolDefinitionFunction;
        });
    }
}
