// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A response format for Chat Completions that restricts responses to emitting valid JSON objects.
 */
@Immutable
public final class ChatCompletionsJsonResponseFormat extends ChatCompletionsResponseFormat {

    /**
     * Creates an instance of ChatCompletionsJsonResponseFormat class.
     */
    @Generated
    public ChatCompletionsJsonResponseFormat() {
    }

    /*
     * The discriminated type for the response format.
     */
    @Generated
    private String type = "json_object";

    /**
     * Get the type property: The discriminated type for the response format.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsJsonResponseFormat from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsJsonResponseFormat if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChatCompletionsJsonResponseFormat.
     */
    @Generated
    public static ChatCompletionsJsonResponseFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionsJsonResponseFormat deserializedChatCompletionsJsonResponseFormat
                = new ChatCompletionsJsonResponseFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedChatCompletionsJsonResponseFormat.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedChatCompletionsJsonResponseFormat;
        });
    }
}
