// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.ai.openai.implementation.accesshelpers.ChatCompletionsOptionsAccessHelper;
import com.azure.ai.openai.implementation.models.FunctionCallPreset;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The configuration information for a chat completions request.
 * Completions support a wide variety of tasks and generate text that continues from or "completes"
 * provided prompt data.
 */
@Fluent
public final class ChatCompletionsOptions implements JsonSerializable<ChatCompletionsOptions> {

    /*
     * The available tool definitions that the chat completions request can use, including caller-defined functions.
     */
    @Generated
    private List<ChatCompletionsToolDefinition> tools;

    /*
     * The collection of context messages associated with this chat completions request.
     * Typical usage begins with a chat message for the System role that provides instructions for
     * the behavior of the assistant, followed by alternating messages between the User and
     * Assistant roles.
     */
    @Generated
    private final List<ChatRequestMessage> messages;

    /*
     * The maximum number of tokens allowed for the generated answer. By default, the number of tokens the model can
     * return will be (4096 - prompt tokens).
     * 
     * This value is now deprecated in favor of `max_completion_tokens`, and is not compatible with o1 series models.
     */
    @Generated
    private Integer maxTokens;

    /*
     * The sampling temperature to use that controls the apparent creativity of generated completions.
     * Higher values will make output more random while lower values will make results more focused
     * and deterministic.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     */
    @Generated
    private Double temperature;

    /*
     * An alternative to sampling with temperature called nucleus sampling. This value causes the
     * model to consider the results of tokens with the provided probability mass. As an example, a
     * value of 0.15 will cause only the tokens comprising the top 15% of probability mass to be
     * considered.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     */
    @Generated
    private Double topP;

    /*
     * A map between GPT token IDs and bias scores that influences the probability of specific tokens
     * appearing in a completions response. Token IDs are computed via external tokenizer tools, while
     * bias scores reside in the range of -100 to 100 with minimum and maximum values corresponding to
     * a full ban or exclusive selection of a token, respectively. The exact behavior of a given bias
     * score varies by model.
     */
    @Generated
    private Map<String, Integer> logitBias;

    /*
     * An identifier for the caller or end user of the operation. This may be used for tracking
     * or rate-limiting purposes.
     */
    @Generated
    private String user;

    /*
     * The number of chat completions choices that should be generated for a chat completions
     * response.
     * Because this setting can generate many completions, it may quickly consume your token quota.
     * Use carefully and ensure reasonable settings for max_tokens and stop.
     */
    @Generated
    private Integer n;

    /*
     * A collection of textual sequences that will end completions generation.
     */
    @Generated
    private List<String> stop;

    /*
     * A value that influences the probability of generated tokens appearing based on their existing
     * presence in generated text.
     * Positive values will make tokens less likely to appear when they already exist and increase the
     * model's likelihood to output new topics.
     */
    @Generated
    private Double presencePenalty;

    /*
     * A value that influences the probability of generated tokens appearing based on their cumulative
     * frequency in generated text.
     * Positive values will make tokens less likely to appear as their frequency increases and
     * decrease the likelihood of the model repeating the same statements verbatim.
     */
    @Generated
    private Double frequencyPenalty;

    /*
     * A value indicating whether chat completions should be streamed for this request.
     */
    @Generated
    private Boolean stream;

    /*
     * The model name to provide as part of this completions request.
     * Not applicable to Azure OpenAI, where deployment information should be included in the Azure
     * resource URI that's connected to.
     */
    @Generated
    private String model;

    /*
     * A list of functions the model may generate JSON inputs for.
     */
    @Generated
    private List<FunctionDefinition> functions;

    /*
     * Controls how the model responds to function calls. "none" means the model does not call a function,
     * and responds to the end-user. "auto" means the model can pick between an end-user or calling a function.
     * Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.
     * "none" is the default when no functions are present. "auto" is the default if functions are present.
     */
    @Generated
    private BinaryData functionCall;

    /*
     * Field not used for serialization. This is a convenience helper field for the serialization of "function_call".
     */
    private FunctionCallConfig functionCallConfig;

    /*
     * The configuration entries for Azure OpenAI chat extensions that use them.
     * This additional specification is only compatible with Azure OpenAI.
     */
    @Generated
    private List<AzureChatExtensionConfiguration> dataSources;

    /*
     * If provided, the configuration options for available Azure OpenAI chat enhancements.
     */
    @Generated
    private AzureChatEnhancementConfiguration enhancements;

    /*
     * If specified, the system will make a best effort to sample deterministically such that repeated requests with the
     * same seed and parameters should return the same result. Determinism is not guaranteed, and you should refer to
     * the
     * system_fingerprint response parameter to monitor changes in the backend."
     */
    @Generated
    private Long seed;

    /*
     * An object specifying the format that the model must output. Used to enable JSON mode.
     */
    @Generated
    private ChatCompletionsResponseFormat responseFormat;

    /*
     * If specified, the model will configure which of the provided tools it can use for the chat completions response.
     */
    @Generated
    private BinaryData toolChoice;

    /*
     * Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each
     * output token returned in the `content` of `message`. This option is currently not available on the
     * `gpt-4-vision-preview` model.
     */
    @Generated
    private Boolean logprobs;

    /*
     * An integer between 0 and 5 specifying the number of most likely tokens to return at each token position, each
     * with an associated log probability. `logprobs` must be set to `true` if this parameter is used.
     */
    @Generated
    private Integer topLogprobs;

    /*
     * An upper bound for the number of tokens that can be generated for a completion, including visible output tokens
     * and reasoning tokens.
     */
    @Generated
    private Integer maxCompletionTokens;

    /*
     * Options for streaming response. Only set this when you set `stream: true`.
     */
    @Generated
    private ChatCompletionStreamOptions streamOptions;

    /*
     * Whether to enable parallel function calling during tool use.
     */
    @Generated
    private Boolean parallelToolCalls;

    /*
     * This field is not available in Azure OpenAI. Specifies the latency tier to use for processing the request.
     */
    private ServiceTierOptions serviceTierOptions;

    /**
     * Creates an instance of ChatCompletionsOptions class.
     *
     * @param messages the messages value to set.
     */
    @Generated
    public ChatCompletionsOptions(List<ChatRequestMessage> messages) {
        this.messages = messages;
    }

    /**
     * Get the messages property: The collection of context messages associated with this chat completions request.
     * Typical usage begins with a chat message for the System role that provides instructions for
     * the behavior of the assistant, followed by alternating messages between the User and
     * Assistant roles.
     *
     * @return the messages value.
     */
    @Generated
    public List<ChatRequestMessage> getMessages() {
        return this.messages;
    }

    /**
     * Get the maxTokens property: The maximum number of tokens allowed for the generated answer. By default, the number
     * of tokens the model can return will be (4096 - prompt tokens).
     *
     * This value is now deprecated in favor of `max_completion_tokens`, and is not compatible with o1 series models.
     *
     * @return the maxTokens value.
     */
    @Generated
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    /**
     * Set the maxTokens property: The maximum number of tokens allowed for the generated answer. By default, the number
     * of tokens the model can return will be (4096 - prompt tokens).
     *
     * This value is now deprecated in favor of `max_completion_tokens`, and is not compatible with o1 series models.
     *
     * @param maxTokens the maxTokens value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    /**
     * Get the temperature property: The sampling temperature to use that controls the apparent creativity of generated
     * completions.
     * Higher values will make output more random while lower values will make results more focused
     * and deterministic.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     *
     * @return the temperature value.
     */
    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    /**
     * Set the temperature property: The sampling temperature to use that controls the apparent creativity of generated
     * completions.
     * Higher values will make output more random while lower values will make results more focused
     * and deterministic.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     *
     * @param temperature the temperature value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    /**
     * Get the topP property: An alternative to sampling with temperature called nucleus sampling. This value causes the
     * model to consider the results of tokens with the provided probability mass. As an example, a
     * value of 0.15 will cause only the tokens comprising the top 15% of probability mass to be
     * considered.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     *
     * @return the topP value.
     */
    @Generated
    public Double getTopP() {
        return this.topP;
    }

    /**
     * Set the topP property: An alternative to sampling with temperature called nucleus sampling. This value causes the
     * model to consider the results of tokens with the provided probability mass. As an example, a
     * value of 0.15 will cause only the tokens comprising the top 15% of probability mass to be
     * considered.
     * It is not recommended to modify temperature and top_p for the same completions request as the
     * interaction of these two settings is difficult to predict.
     *
     * @param topP the topP value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    /**
     * Get the logitBias property: A map between GPT token IDs and bias scores that influences the probability of
     * specific tokens
     * appearing in a completions response. Token IDs are computed via external tokenizer tools, while
     * bias scores reside in the range of -100 to 100 with minimum and maximum values corresponding to
     * a full ban or exclusive selection of a token, respectively. The exact behavior of a given bias
     * score varies by model.
     *
     * @return the logitBias value.
     */
    @Generated
    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    /**
     * Set the logitBias property: A map between GPT token IDs and bias scores that influences the probability of
     * specific tokens
     * appearing in a completions response. Token IDs are computed via external tokenizer tools, while
     * bias scores reside in the range of -100 to 100 with minimum and maximum values corresponding to
     * a full ban or exclusive selection of a token, respectively. The exact behavior of a given bias
     * score varies by model.
     *
     * @param logitBias the logitBias value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
        return this;
    }

    /**
     * Get the user property: An identifier for the caller or end user of the operation. This may be used for tracking
     * or rate-limiting purposes.
     *
     * @return the user value.
     */
    @Generated
    public String getUser() {
        return this.user;
    }

    /**
     * Set the user property: An identifier for the caller or end user of the operation. This may be used for tracking
     * or rate-limiting purposes.
     *
     * @param user the user value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setUser(String user) {
        this.user = user;
        return this;
    }

    /**
     * Get the n property: The number of chat completions choices that should be generated for a chat completions
     * response.
     * Because this setting can generate many completions, it may quickly consume your token quota.
     * Use carefully and ensure reasonable settings for max_tokens and stop.
     *
     * @return the n value.
     */
    @Generated
    public Integer getN() {
        return this.n;
    }

    /**
     * Set the n property: The number of chat completions choices that should be generated for a chat completions
     * response.
     * Because this setting can generate many completions, it may quickly consume your token quota.
     * Use carefully and ensure reasonable settings for max_tokens and stop.
     *
     * @param n the n value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setN(Integer n) {
        this.n = n;
        return this;
    }

    /**
     * Get the stop property: A collection of textual sequences that will end completions generation.
     *
     * @return the stop value.
     */
    @Generated
    public List<String> getStop() {
        return this.stop;
    }

    /**
     * Set the stop property: A collection of textual sequences that will end completions generation.
     *
     * @param stop the stop value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    /**
     * Get the presencePenalty property: A value that influences the probability of generated tokens appearing based on
     * their existing
     * presence in generated text.
     * Positive values will make tokens less likely to appear when they already exist and increase the
     * model's likelihood to output new topics.
     *
     * @return the presencePenalty value.
     */
    @Generated
    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    /**
     * Set the presencePenalty property: A value that influences the probability of generated tokens appearing based on
     * their existing
     * presence in generated text.
     * Positive values will make tokens less likely to appear when they already exist and increase the
     * model's likelihood to output new topics.
     *
     * @param presencePenalty the presencePenalty value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    /**
     * Get the frequencyPenalty property: A value that influences the probability of generated tokens appearing based on
     * their cumulative
     * frequency in generated text.
     * Positive values will make tokens less likely to appear as their frequency increases and
     * decrease the likelihood of the model repeating the same statements verbatim.
     *
     * @return the frequencyPenalty value.
     */
    @Generated
    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    /**
     * Set the frequencyPenalty property: A value that influences the probability of generated tokens appearing based on
     * their cumulative
     * frequency in generated text.
     * Positive values will make tokens less likely to appear as their frequency increases and
     * decrease the likelihood of the model repeating the same statements verbatim.
     *
     * @param frequencyPenalty the frequencyPenalty value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    /**
     * Get the stream property: A value indicating whether chat completions should be streamed for this request.
     *
     * @return the stream value.
     */
    @Generated
    public Boolean isStream() {
        return this.stream;
    }

    /**
     * Set the stream property: A value indicating whether chat completions should be streamed for this request.
     *
     * @param stream the stream value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    private ChatCompletionsOptions setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    /**
     * Get the model property: The model name to provide as part of this completions request.
     * Not applicable to Azure OpenAI, where deployment information should be included in the Azure
     * resource URI that's connected to.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Set the model property: The model name to provide as part of this completions request.
     * Not applicable to Azure OpenAI, where deployment information should be included in the Azure
     * resource URI that's connected to.
     *
     * @param model the model value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the functions property: A list of functions the model may generate JSON inputs for.
     *
     * @return the functions value.
     */
    @Generated
    public List<FunctionDefinition> getFunctions() {
        return this.functions;
    }

    /**
     * Set the functions property: A list of functions the model may generate JSON inputs for.
     *
     * @param functions the functions value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setFunctions(List<FunctionDefinition> functions) {
        this.functions = functions;
        return this;
    }

    /**
     * Get the functionCall property: Controls how the model responds to function calls. "none" means the model does not
     * call a function, and responds to the end-user. "auto" means the model can pick between an end-user or calling a
     * function. Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.
     * "none" is the default when no functions are present. "auto" is the default if functions are present.
     *
     * @return the functionCall value.
     */
    BinaryData getFunctionCallInternal() {
        return this.functionCall;
    }

    /**
     * Set the functionCall property: Controls how the model responds to function calls. "none" means the model does not
     * call a function, and responds to the end-user. "auto" means the model can pick between an end-user or calling a
     * function. Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.
     * "none" is the default when no functions are present. "auto" is the default if functions are present.
     *
     * @param functionCall the functionCall value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    ChatCompletionsOptions setFunctionCallInternal(BinaryData functionCall) {
        this.functionCall = functionCall;
        return this;
    }

    /**
     * Get the functionCall property: Controls how the model responds to function calls. "none" means the model does not
     * call a function, and responds to the end-user. "auto" means the model can pick between an end-user or calling a
     * function. Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.
     * "none" is the default when no functions are present. "auto" is the default if functions are present.
     *
     * @return the functionCall value.
     */
    public FunctionCallConfig getFunctionCall() {
        return this.functionCallConfig;
    }

    /**
     * Set the functionCall property: Controls how the model responds to function calls. "none" means the model does not
     * call a function, and responds to the end-user. "auto" means the model can pick between an end-user or calling a
     * function. Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.
     * "none" is the default when no functions are present. "auto" is the default if functions are present.
     *
     * @param functionCallConfig the functionCall value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    public ChatCompletionsOptions setFunctionCall(FunctionCallConfig functionCallConfig) {
        this.functionCallConfig = functionCallConfig;
        if (FunctionCallPreset.values()
            .stream()
            .anyMatch(preset -> preset.toString().equals(functionCallConfig.getName()))) {
            this.functionCall = BinaryData.fromObject(FunctionCallPreset.fromString(this.functionCallConfig.getName()));
        } else {
            this.functionCall = BinaryData.fromObject(new FunctionName(this.functionCallConfig.getName()));
        }
        return this;
    }

    /**
     * Get the dataSources property: The configuration entries for Azure OpenAI chat extensions that use them.
     * This additional specification is only compatible with Azure OpenAI.
     *
     * @return the dataSources value.
     */
    @Generated
    public List<AzureChatExtensionConfiguration> getDataSources() {
        return this.dataSources;
    }

    /**
     * Set the dataSources property: The configuration entries for Azure OpenAI chat extensions that use them.
     * This additional specification is only compatible with Azure OpenAI.
     *
     * @param dataSources the dataSources value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setDataSources(List<AzureChatExtensionConfiguration> dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    /**
     * Get the enhancements property: If provided, the configuration options for available Azure OpenAI chat
     * enhancements.
     *
     * @return the enhancements value.
     */
    @Generated
    public AzureChatEnhancementConfiguration getEnhancements() {
        return this.enhancements;
    }

    /**
     * Set the enhancements property: If provided, the configuration options for available Azure OpenAI chat
     * enhancements.
     *
     * @param enhancements the enhancements value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setEnhancements(AzureChatEnhancementConfiguration enhancements) {
        this.enhancements = enhancements;
        return this;
    }

    /**
     * Get the seed property: If specified, the system will make a best effort to sample deterministically such that
     * repeated requests with the
     * same seed and parameters should return the same result. Determinism is not guaranteed, and you should refer to
     * the
     * system_fingerprint response parameter to monitor changes in the backend.".
     *
     * @return the seed value.
     */
    @Generated
    public Long getSeed() {
        return this.seed;
    }

    /**
     * Set the seed property: If specified, the system will make a best effort to sample deterministically such that
     * repeated requests with the
     * same seed and parameters should return the same result. Determinism is not guaranteed, and you should refer to
     * the
     * system_fingerprint response parameter to monitor changes in the backend.".
     *
     * @param seed the seed value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setSeed(Long seed) {
        this.seed = seed;
        return this;
    }

    /**
     * Get the responseFormat property: An object specifying the format that the model must output. Used to enable JSON
     * mode.
     *
     * @return the responseFormat value.
     */
    @Generated
    public ChatCompletionsResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    /**
     * Set the responseFormat property: An object specifying the format that the model must output. Used to enable JSON
     * mode.
     *
     * @param responseFormat the responseFormat value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setResponseFormat(ChatCompletionsResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    /**
     * Get the tools property: The available tool definitions that the chat completions request can use, including
     * caller-defined functions.
     *
     * @return the tools value.
     */
    @Generated
    public List<ChatCompletionsToolDefinition> getTools() {
        return this.tools;
    }

    /**
     * Set the tools property: The available tool definitions that the chat completions request can use, including
     * caller-defined functions.
     *
     * @param tools the tools value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setTools(List<ChatCompletionsToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    /**
     * Get the toolChoice property: If specified, the model will configure which of the provided tools it can use for
     * the chat completions response.
     *
     * @return the toolChoice value.
     */
    public ChatCompletionsToolSelection getToolChoice() {
        return ChatCompletionsToolSelection.fromBinaryData(this.toolChoice);
    }

    /**
     * Set the toolChoice property: If specified, the model will configure which of the provided tools it can use for
     * the chat completions response.
     *
     * @param toolChoice the toolChoice value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    public ChatCompletionsOptions setToolChoice(ChatCompletionsToolSelection toolChoice) {
        if (toolChoice.getPreset() != null) {
            this.toolChoice = BinaryData.fromObject(toolChoice.getPreset());
        } else if (toolChoice.getNamedToolSelection() != null) {
            this.toolChoice = BinaryData.fromObject(toolChoice.getNamedToolSelection());
        } else {
            this.toolChoice = null;
        }
        return this;
    }

    /**
     * Get the logprobs property: Whether to return log probabilities of the output tokens or not. If true, returns the
     * log probabilities of each output token returned in the `content` of `message`. This option is currently not
     * available on the `gpt-4-vision-preview` model.
     *
     * @return the logprobs value.
     */
    @Generated
    public Boolean isLogprobs() {
        return this.logprobs;
    }

    /**
     * Set the logprobs property: Whether to return log probabilities of the output tokens or not. If true, returns the
     * log probabilities of each output token returned in the `content` of `message`. This option is currently not
     * available on the `gpt-4-vision-preview` model.
     *
     * @param logprobs the logprobs value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
        return this;
    }

    /**
     * Get the topLogprobs property: An integer between 0 and 5 specifying the number of most likely tokens to return at
     * each token position, each with an associated log probability. `logprobs` must be set to `true` if this parameter
     * is used.
     *
     * @return the topLogprobs value.
     */
    @Generated
    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    /**
     * Set the topLogprobs property: An integer between 0 and 5 specifying the number of most likely tokens to return at
     * each token position, each with an associated log probability. `logprobs` must be set to `true` if this parameter
     * is used.
     *
     * @param topLogprobs the topLogprobs value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
        return this;
    }

    /**
     * Get the maxCompletionTokens property: An upper bound for the number of tokens that can be generated for a
     * completion, including visible output tokens and reasoning tokens.
     *
     * @return the maxCompletionTokens value.
     */
    @Generated
    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    /**
     * Set the maxCompletionTokens property: An upper bound for the number of tokens that can be generated for a
     * completion, including visible output tokens and reasoning tokens.
     *
     * @param maxCompletionTokens the maxCompletionTokens value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
        return this;
    }

    /**
     * Get the streamOptions property: Options for streaming response. Only set this when you set `stream: true`.
     *
     * @return the streamOptions value.
     */
    @Generated
    public ChatCompletionStreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    /**
     * Set the streamOptions property: Options for streaming response. Only set this when you set `stream: true`.
     *
     * @param streamOptions the streamOptions value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    private ChatCompletionsOptions setStreamOptions(ChatCompletionStreamOptions streamOptions) {
        this.streamOptions = streamOptions;
        return this;
    }

    /**
     * Get the parallelToolCalls property: Whether to enable parallel function calling during tool use.
     *
     * @return the parallelToolCalls value.
     */
    @Generated
    public Boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    /**
     * Set the parallelToolCalls property: Whether to enable parallel function calling during tool use.
     *
     * @param parallelToolCalls the parallelToolCalls value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
        return this;
    }

    /**
     * Get the {@link ServiceTierOptions} for this request.
     *
     * @return the {@link ServiceTierOptions} value.
     */
    public ServiceTierOptions getServiceTierOptions() {
        return this.serviceTierOptions;
    }

    /**
     * Set the {@link ServiceTierOptions} for this request.
     *
     * @param serviceTierOptions the {@link ServiceTierOptions} value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    public ChatCompletionsOptions setServiceTierOptions(ServiceTierOptions serviceTierOptions) {
        this.serviceTierOptions = serviceTierOptions;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("functions", this.functions, (writer, element) -> writer.writeJson(element));
        if (this.functionCall != null) {
            jsonWriter.writeFieldName("function_call");
            this.functionCall.writeTo(jsonWriter);
        }
        jsonWriter.writeNumberField("max_tokens", this.maxTokens);
        jsonWriter.writeNumberField("max_completion_tokens", this.maxCompletionTokens);
        jsonWriter.writeNumberField("temperature", this.temperature);
        jsonWriter.writeNumberField("top_p", this.topP);
        jsonWriter.writeMapField("logit_bias", this.logitBias, (writer, element) -> writer.writeInt(element));
        jsonWriter.writeStringField("user", this.user);
        jsonWriter.writeNumberField("n", this.n);
        jsonWriter.writeArrayField("stop", this.stop, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("presence_penalty", this.presencePenalty);
        jsonWriter.writeNumberField("frequency_penalty", this.frequencyPenalty);
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeJsonField("stream_options", this.streamOptions);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeArrayField("data_sources", this.dataSources, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("enhancements", this.enhancements);
        jsonWriter.writeNumberField("seed", this.seed);
        jsonWriter.writeBooleanField("logprobs", this.logprobs);
        jsonWriter.writeNumberField("top_logprobs", this.topLogprobs);
        jsonWriter.writeJsonField("response_format", this.responseFormat);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson(element));
        if (this.toolChoice != null) {
            jsonWriter.writeFieldName("tool_choice");
            this.toolChoice.writeTo(jsonWriter);
        }
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        jsonWriter.writeBooleanField("store", this.store);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("reasoning_effort",
            this.reasoningEffort == null ? null : this.reasoningEffort.toString());
        jsonWriter.writeJsonField("user_security_context", this.userSecurityContext);
        jsonWriter.writeArrayField("modalities", this.modalities,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("prediction", this.prediction);
        jsonWriter.writeJsonField("audio", this.audio);
        if (this.serviceTierOptions != null) {
            jsonWriter.writeStringField("service_tier", this.serviceTierOptions.toString());
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsOptions if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatCompletionsOptions.
     */
    public static ChatCompletionsOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<ChatRequestMessage> messages = null;
            List<FunctionDefinition> functions = null;
            BinaryData functionCall = null;
            Integer maxTokens = null;
            Integer maxCompletionTokens = null;
            Double temperature = null;
            Double topP = null;
            Map<String, Integer> logitBias = null;
            String user = null;
            Integer n = null;
            List<String> stop = null;
            Double presencePenalty = null;
            Double frequencyPenalty = null;
            Boolean stream = null;
            ChatCompletionStreamOptions streamOptions = null;
            String model = null;
            List<AzureChatExtensionConfiguration> dataSources = null;
            AzureChatEnhancementConfiguration enhancements = null;
            Long seed = null;
            Boolean logprobs = null;
            Integer topLogprobs = null;
            ChatCompletionsResponseFormat responseFormat = null;
            List<ChatCompletionsToolDefinition> tools = null;
            BinaryData toolChoice = null;
            Boolean parallelToolCalls = null;
            Boolean store = null;
            Map<String, String> metadata = null;
            ReasoningEffortValue reasoningEffort = null;
            UserSecurityContext userSecurityContext = null;
            List<ChatCompletionModality> modalities = null;
            PredictionContent prediction = null;
            AudioOutputParameters audio = null;
            ServiceTierOptions serviceTierOptions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messages".equals(fieldName)) {
                    messages = reader.readArray(reader1 -> ChatRequestMessage.fromJson(reader1));
                } else if ("functions".equals(fieldName)) {
                    functions = reader.readArray(reader1 -> FunctionDefinition.fromJson(reader1));
                } else if ("function_call".equals(fieldName)) {
                    functionCall
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("max_tokens".equals(fieldName)) {
                    maxTokens = reader.getNullable(JsonReader::getInt);
                } else if ("max_completion_tokens".equals(fieldName)) {
                    maxCompletionTokens = reader.getNullable(JsonReader::getInt);
                } else if ("temperature".equals(fieldName)) {
                    temperature = reader.getNullable(JsonReader::getDouble);
                } else if ("top_p".equals(fieldName)) {
                    topP = reader.getNullable(JsonReader::getDouble);
                } else if ("logit_bias".equals(fieldName)) {
                    logitBias = reader.readMap(reader1 -> reader1.getInt());
                } else if ("user".equals(fieldName)) {
                    user = reader.getString();
                } else if ("n".equals(fieldName)) {
                    n = reader.getNullable(JsonReader::getInt);
                } else if ("stop".equals(fieldName)) {
                    stop = reader.readArray(reader1 -> reader1.getString());
                } else if ("presence_penalty".equals(fieldName)) {
                    presencePenalty = reader.getNullable(JsonReader::getDouble);
                } else if ("frequency_penalty".equals(fieldName)) {
                    frequencyPenalty = reader.getNullable(JsonReader::getDouble);
                } else if ("stream".equals(fieldName)) {
                    stream = reader.getNullable(JsonReader::getBoolean);
                } else if ("stream_options".equals(fieldName)) {
                    streamOptions = ChatCompletionStreamOptions.fromJson(reader);
                } else if ("model".equals(fieldName)) {
                    model = reader.getString();
                } else if ("data_sources".equals(fieldName)) {
                    dataSources = reader.readArray(reader1 -> AzureChatExtensionConfiguration.fromJson(reader1));
                } else if ("enhancements".equals(fieldName)) {
                    enhancements = AzureChatEnhancementConfiguration.fromJson(reader);
                } else if ("seed".equals(fieldName)) {
                    seed = reader.getNullable(JsonReader::getLong);
                } else if ("logprobs".equals(fieldName)) {
                    logprobs = reader.getNullable(JsonReader::getBoolean);
                } else if ("top_logprobs".equals(fieldName)) {
                    topLogprobs = reader.getNullable(JsonReader::getInt);
                } else if ("response_format".equals(fieldName)) {
                    responseFormat = ChatCompletionsResponseFormat.fromJson(reader);
                } else if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ChatCompletionsToolDefinition.fromJson(reader1));
                } else if ("tool_choice".equals(fieldName)) {
                    toolChoice
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = reader.getNullable(JsonReader::getBoolean);
                } else if ("store".equals(fieldName)) {
                    store = reader.getNullable(JsonReader::getBoolean);
                } else if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                } else if ("reasoning_effort".equals(fieldName)) {
                    reasoningEffort = ReasoningEffortValue.fromString(reader.getString());
                } else if ("user_security_context".equals(fieldName)) {
                    userSecurityContext = UserSecurityContext.fromJson(reader);
                } else if ("modalities".equals(fieldName)) {
                    modalities = reader.readArray(reader1 -> ChatCompletionModality.fromString(reader1.getString()));
                } else if ("prediction".equals(fieldName)) {
                    prediction = PredictionContent.fromJson(reader);
                } else if ("audio".equals(fieldName)) {
                    audio = AudioOutputParameters.fromJson(reader);
                } else if ("service_tier".equals(fieldName)) {
                    serviceTierOptions = ServiceTierOptions.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ChatCompletionsOptions deserializedChatCompletionsOptions = new ChatCompletionsOptions(messages);
            deserializedChatCompletionsOptions.functions = functions;
            deserializedChatCompletionsOptions.functionCall = functionCall;
            deserializedChatCompletionsOptions.maxTokens = maxTokens;
            deserializedChatCompletionsOptions.maxCompletionTokens = maxCompletionTokens;
            deserializedChatCompletionsOptions.temperature = temperature;
            deserializedChatCompletionsOptions.topP = topP;
            deserializedChatCompletionsOptions.logitBias = logitBias;
            deserializedChatCompletionsOptions.user = user;
            deserializedChatCompletionsOptions.n = n;
            deserializedChatCompletionsOptions.stop = stop;
            deserializedChatCompletionsOptions.presencePenalty = presencePenalty;
            deserializedChatCompletionsOptions.frequencyPenalty = frequencyPenalty;
            deserializedChatCompletionsOptions.stream = stream;
            deserializedChatCompletionsOptions.streamOptions = streamOptions;
            deserializedChatCompletionsOptions.model = model;
            deserializedChatCompletionsOptions.dataSources = dataSources;
            deserializedChatCompletionsOptions.enhancements = enhancements;
            deserializedChatCompletionsOptions.seed = seed;
            deserializedChatCompletionsOptions.logprobs = logprobs;
            deserializedChatCompletionsOptions.topLogprobs = topLogprobs;
            deserializedChatCompletionsOptions.responseFormat = responseFormat;
            deserializedChatCompletionsOptions.tools = tools;
            deserializedChatCompletionsOptions.toolChoice = toolChoice;
            deserializedChatCompletionsOptions.parallelToolCalls = parallelToolCalls;
            deserializedChatCompletionsOptions.store = store;
            deserializedChatCompletionsOptions.metadata = metadata;
            deserializedChatCompletionsOptions.reasoningEffort = reasoningEffort;
            deserializedChatCompletionsOptions.userSecurityContext = userSecurityContext;
            deserializedChatCompletionsOptions.modalities = modalities;
            deserializedChatCompletionsOptions.prediction = prediction;
            deserializedChatCompletionsOptions.audio = audio;
            deserializedChatCompletionsOptions.serviceTierOptions = serviceTierOptions;
            return deserializedChatCompletionsOptions;
        });
    }

    static {
        ChatCompletionsOptionsAccessHelper
            .setAccessor(new ChatCompletionsOptionsAccessHelper.ChatCompletionsOptionsAccessor() {

                @Override
                public void setStream(ChatCompletionsOptions options, boolean stream) {
                    options.setStream(stream);
                }

                @Override
                public void setStreamOptions(ChatCompletionsOptions options,
                    ChatCompletionStreamOptions streamOptions) {
                    options.setStreamOptions(streamOptions);
                }
            });
    }

    /*
     * Whether or not to store the output of this chat completion request for use in our model distillation or
     * evaluation products.
     */
    @Generated
    private Boolean store;

    /*
     * Developer-defined tags and values used for filtering completions in the stored completions dashboard.
     */
    @Generated
    private Map<String, String> metadata;

    /*
     * This option is only valid for o1 models,
     * 
     * Constrains effort on reasoning for reasoning models (see https://platform.openai.com/docs/guides/reasoning).
     * 
     * Currently supported values are `low`, `medium`, and `high`. Reducing reasoning effort can result in faster
     * responses and fewer tokens used on reasoning in a response.
     */
    @Generated
    private ReasoningEffortValue reasoningEffort;

    /*
     * The security context identifies and authenticates users and applications in your multi-tenant AI system, helping
     * security teams investigate and mitigate incidents.
     */
    @Generated
    private UserSecurityContext userSecurityContext;

    /*
     * Output types that you would like the model to generate for this request.
     * Most models are capable of generating text, which is the default: `["text"]`
     * The `gpt-4o-audio-preview` model can also be used to generate audio. To
     * request that this model generate both text and audio responses, you can
     * use: `["text", "audio"]`
     */
    @Generated
    private List<ChatCompletionModality> modalities;

    /*
     * Configuration for a Predicted Output, which can greatly improve response times
     * when large parts of the model response are known ahead of time. This is most
     * common when you are regenerating a file with only minor changes to most of the content.
     */
    @Generated
    private PredictionContent prediction;

    /*
     * Parameters for audio output. Required when audio output is requested
     * with `modalities: ["audio"]`
     */
    @Generated
    private AudioOutputParameters audio;

    /**
     * Get the store property: Whether or not to store the output of this chat completion request for use in our model
     * distillation or evaluation products.
     *
     * @return the store value.
     */
    @Generated
    public Boolean isStore() {
        return this.store;
    }

    /**
     * Set the store property: Whether or not to store the output of this chat completion request for use in our model
     * distillation or evaluation products.
     *
     * @param store the store value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setStore(Boolean store) {
        this.store = store;
        return this;
    }

    /**
     * Get the metadata property: Developer-defined tags and values used for filtering completions in the stored
     * completions dashboard.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Developer-defined tags and values used for filtering completions in the stored
     * completions dashboard.
     *
     * @param metadata the metadata value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the reasoningEffort property: This option is only valid for o1 models,
     *
     * Constrains effort on reasoning for reasoning models (see https://platform.openai.com/docs/guides/reasoning).
     *
     * Currently supported values are `low`, `medium`, and `high`. Reducing reasoning effort can result in faster
     * responses and fewer tokens used on reasoning in a response.
     *
     * @return the reasoningEffort value.
     */
    @Generated
    public ReasoningEffortValue getReasoningEffort() {
        return this.reasoningEffort;
    }

    /**
     * Set the reasoningEffort property: This option is only valid for o1 models,
     *
     * Constrains effort on reasoning for reasoning models (see https://platform.openai.com/docs/guides/reasoning).
     *
     * Currently supported values are `low`, `medium`, and `high`. Reducing reasoning effort can result in faster
     * responses and fewer tokens used on reasoning in a response.
     *
     * @param reasoningEffort the reasoningEffort value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setReasoningEffort(ReasoningEffortValue reasoningEffort) {
        this.reasoningEffort = reasoningEffort;
        return this;
    }

    /**
     * Get the userSecurityContext property: The security context identifies and authenticates users and applications in
     * your multi-tenant AI system, helping security teams investigate and mitigate incidents.
     *
     * @return the userSecurityContext value.
     */
    @Generated
    public UserSecurityContext getUserSecurityContext() {
        return this.userSecurityContext;
    }

    /**
     * Set the userSecurityContext property: The security context identifies and authenticates users and applications in
     * your multi-tenant AI system, helping security teams investigate and mitigate incidents.
     *
     * @param userSecurityContext the userSecurityContext value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setUserSecurityContext(UserSecurityContext userSecurityContext) {
        this.userSecurityContext = userSecurityContext;
        return this;
    }

    /**
     * Get the modalities property: Output types that you would like the model to generate for this request.
     * Most models are capable of generating text, which is the default: `["text"]`
     * The `gpt-4o-audio-preview` model can also be used to generate audio. To
     * request that this model generate both text and audio responses, you can
     * use: `["text", "audio"]`.
     *
     * @return the modalities value.
     */
    @Generated
    public List<ChatCompletionModality> getModalities() {
        return this.modalities;
    }

    /**
     * Set the modalities property: Output types that you would like the model to generate for this request.
     * Most models are capable of generating text, which is the default: `["text"]`
     * The `gpt-4o-audio-preview` model can also be used to generate audio. To
     * request that this model generate both text and audio responses, you can
     * use: `["text", "audio"]`.
     *
     * @param modalities the modalities value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setModalities(List<ChatCompletionModality> modalities) {
        this.modalities = modalities;
        return this;
    }

    /**
     * Get the prediction property: Configuration for a Predicted Output, which can greatly improve response times
     * when large parts of the model response are known ahead of time. This is most
     * common when you are regenerating a file with only minor changes to most of the content.
     *
     * @return the prediction value.
     */
    @Generated
    public PredictionContent getPrediction() {
        return this.prediction;
    }

    /**
     * Set the prediction property: Configuration for a Predicted Output, which can greatly improve response times
     * when large parts of the model response are known ahead of time. This is most
     * common when you are regenerating a file with only minor changes to most of the content.
     *
     * @param prediction the prediction value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setPrediction(PredictionContent prediction) {
        this.prediction = prediction;
        return this;
    }

    /**
     * Get the audio property: Parameters for audio output. Required when audio output is requested
     * with `modalities: ["audio"]`.
     *
     * @return the audio value.
     */
    @Generated
    public AudioOutputParameters getAudio() {
        return this.audio;
    }

    /**
     * Set the audio property: Parameters for audio output. Required when audio output is requested
     * with `modalities: ["audio"]`.
     *
     * @param audio the audio value to set.
     * @return the ChatCompletionsOptions object itself.
     */
    @Generated
    public ChatCompletionsOptions setAudio(AudioOutputParameters audio) {
        this.audio = audio;
        return this;
    }
}
