// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An abstract representation of a response format configuration usable by Chat Completions. Can be used to enable JSON
 * mode.
 */
@Immutable
public class ChatCompletionsResponseFormat implements JsonSerializable<ChatCompletionsResponseFormat> {

    /**
     * Creates an instance of ChatCompletionsResponseFormat class.
     */
    @Generated
    public ChatCompletionsResponseFormat() {
    }

    /*
     * The discriminated type for the response format.
     */
    @Generated
    private String type = "ChatCompletionsResponseFormat";

    /**
     * Get the type property: The discriminated type for the response format.
     *
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionsResponseFormat from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionsResponseFormat if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChatCompletionsResponseFormat.
     */
    @Generated
    public static ChatCompletionsResponseFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("text".equals(discriminatorValue)) {
                    return ChatCompletionsTextResponseFormat.fromJson(readerToUse.reset());
                } else if ("json_object".equals(discriminatorValue)) {
                    return ChatCompletionsJsonResponseFormat.fromJson(readerToUse.reset());
                } else if ("json_schema".equals(discriminatorValue)) {
                    return ChatCompletionsJsonSchemaResponseFormat.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static ChatCompletionsResponseFormat fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionsResponseFormat deserializedChatCompletionsResponseFormat
                = new ChatCompletionsResponseFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedChatCompletionsResponseFormat.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedChatCompletionsResponseFormat;
        });
    }
}
