// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A structured chat content item containing audio data.
 */
@Immutable
public final class ChatMessageAudioContentItem extends ChatMessageContentItem {

    /*
     * The discriminated object type.
     */
    @Generated
    private String type = "input_audio";

    /*
     * The audio data.
     */
    @Generated
    private final InputAudioContent inputAudio;

    /**
     * Creates an instance of ChatMessageAudioContentItem class.
     *
     * @param inputAudio the inputAudio value to set.
     */
    @Generated
    public ChatMessageAudioContentItem(InputAudioContent inputAudio) {
        this.inputAudio = inputAudio;
    }

    /**
     * Get the type property: The discriminated object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the inputAudio property: The audio data.
     *
     * @return the inputAudio value.
     */
    @Generated
    public InputAudioContent getInputAudio() {
        return this.inputAudio;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("input_audio", this.inputAudio);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatMessageAudioContentItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatMessageAudioContentItem if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatMessageAudioContentItem.
     */
    @Generated
    public static ChatMessageAudioContentItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InputAudioContent inputAudio = null;
            String type = "input_audio";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input_audio".equals(fieldName)) {
                    inputAudio = InputAudioContent.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ChatMessageAudioContentItem deserializedChatMessageAudioContentItem
                = new ChatMessageAudioContentItem(inputAudio);
            deserializedChatMessageAudioContentItem.type = type;
            return deserializedChatMessageAudioContentItem;
        });
    }
}
