// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * A representation of the possible image detail levels for image-based chat completions message content.
 */
public final class ChatMessageImageDetailLevel extends ExpandableStringEnum<ChatMessageImageDetailLevel> {

    /**
     * Specifies that the model should determine which detail level to apply using heuristics like image size.
     */
    @Generated
    public static final ChatMessageImageDetailLevel AUTO = fromString("auto");

    /**
     * Specifies that image evaluation should be constrained to the 'low-res' model that may be faster and consume fewer
     * tokens but may also be less accurate for highly detailed images.
     */
    @Generated
    public static final ChatMessageImageDetailLevel LOW = fromString("low");

    /**
     * Specifies that image evaluation should enable the 'high-res' model that may be more accurate for highly detailed
     * images but may also be slower and consume more tokens.
     */
    @Generated
    public static final ChatMessageImageDetailLevel HIGH = fromString("high");

    /**
     * Creates a new instance of ChatMessageImageDetailLevel value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ChatMessageImageDetailLevel() {
    }

    /**
     * Creates or finds a ChatMessageImageDetailLevel from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ChatMessageImageDetailLevel.
     */
    @Generated
    public static ChatMessageImageDetailLevel fromString(String name) {
        return fromString(name, ChatMessageImageDetailLevel.class);
    }

    /**
     * Gets known ChatMessageImageDetailLevel values.
     *
     * @return known ChatMessageImageDetailLevel values.
     */
    @Generated
    public static Collection<ChatMessageImageDetailLevel> values() {
        return values(ChatMessageImageDetailLevel.class);
    }
}
