// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An internet location from which the model may retrieve an image.
 */
@Fluent
public final class ChatMessageImageUrl implements JsonSerializable<ChatMessageImageUrl> {

    /*
     * The URL of the image.
     */
    @Generated
    private final String url;

    /**
     * Creates an instance of ChatMessageImageUrl class.
     *
     * @param url the url value to set.
     */
    @Generated
    public ChatMessageImageUrl(String url) {
        this.url = url;
    }

    /**
     * Get the url property: The URL of the image.
     *
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /*
     * The evaluation quality setting to use, which controls relative prioritization of speed, token consumption, and
     * accuracy.
     */
    @Generated
    private ChatMessageImageDetailLevel detail;

    /**
     * Get the detail property: The evaluation quality setting to use, which controls relative prioritization of speed,
     * token consumption, and
     * accuracy.
     *
     * @return the detail value.
     */
    @Generated
    public ChatMessageImageDetailLevel getDetail() {
        return this.detail;
    }

    /**
     * Set the detail property: The evaluation quality setting to use, which controls relative prioritization of speed,
     * token consumption, and
     * accuracy.
     *
     * @param detail the detail value to set.
     * @return the ChatMessageImageUrl object itself.
     */
    @Generated
    public ChatMessageImageUrl setDetail(ChatMessageImageDetailLevel detail) {
        this.detail = detail;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("detail", this.detail == null ? null : this.detail.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatMessageImageUrl from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatMessageImageUrl if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatMessageImageUrl.
     */
    @Generated
    public static ChatMessageImageUrl fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String url = null;
            ChatMessageImageDetailLevel detail = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                } else if ("detail".equals(fieldName)) {
                    detail = ChatMessageImageDetailLevel.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ChatMessageImageUrl deserializedChatMessageImageUrl = new ChatMessageImageUrl(url);
            deserializedChatMessageImageUrl.detail = detail;
            return deserializedChatMessageImageUrl;
        });
    }
}
