// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * Developer-provided instructions that the model should follow, regardless of messages sent by the user.
 * With o1 models and newer, `developer` messages replace the previous `system` messages.".
 */
@Fluent
public final class ChatRequestDeveloperMessage extends ChatRequestMessage {

    /*
     * The chat role associated with this message.
     */
    @Generated
    private ChatRole role = ChatRole.DEVELOPER;

    /*
     * An array of content parts with a defined type. For developer messages, only type `text` is supported.
     */
    @Generated
    private final BinaryData content;

    private final String stringContent;

    private final List<ChatMessageContentItem> chatMessageContentItems;

    /*
     * An optional name for the participant. Provides the model information to differentiate between participants of the
     * same role.
     */
    @Generated
    private String name;

    /**
     * Creates an instance of ChatRequestDeveloperMessage class.
     *
     * @param content the content value to set.
     */
    private ChatRequestDeveloperMessage(BinaryData content) {
        this.content = content;
        this.stringContent = null;
        this.chatMessageContentItems = null;
    }

    /**
     * Creates an instance of ChatRequestDeveloperMessage class.
     *
     * @param content the content value to set.
     */
    public ChatRequestDeveloperMessage(String content) {
        this.content = BinaryData.fromString(content);
        this.stringContent = content;
        this.chatMessageContentItems = null;
    }

    /**
     * Creates an instance of ChatRequestDeveloperMessage class.
     *
     * @param content the content value to set.
     */
    public ChatRequestDeveloperMessage(List<ChatMessageContentItem> content) {
        this.content = BinaryData.fromObject(content);
        this.stringContent = null;
        this.chatMessageContentItems = content;
    }

    /**
     * Creates a new instance of ChatRequestDeveloperMessage using a collection of structured content.
     *
     * @param content The collection of structured content associated with the message.
     */
    public ChatRequestDeveloperMessage(ChatMessageContentItem[] content) {
        this.content = BinaryData.fromObject(content);
        this.chatMessageContentItems = Arrays.asList(content);
        this.stringContent = null;
    }

    /**
     * Get the role property: The chat role associated with this message.
     *
     * @return the role value.
     */
    @Generated
    @Override
    public ChatRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: An array of content parts with a defined type. For developer messages, only type `text`
     * is supported.
     *
     * @return the content value.
     */
    @Generated
    public BinaryData getContent() {
        return this.content;
    }

    /**
     * Get the content property: The contents of the user message, with available input types varying by selected model.
     * If the result of this method is `null`, it means that the content could be a String or null altogether.
     *
     * @return the content value if defined as a list
     */
    public List<ChatMessageContentItem> getListContent() {
        return this.chatMessageContentItems;
    }

    /**
     * Get the content property: The contents of the user message, with available input types varying by selected model.
     * If the result of this method is `null`, it means that the content could be a String or null altogether.
     *
     * @return the content value if defined as an array
     */
    public ChatMessageContentItem[] getArrayContent() {
        return this.chatMessageContentItems == null
            ? null
            : this.chatMessageContentItems.toArray(new ChatMessageContentItem[0]);
    }

    /**
     * Get the content property: The contents of the user message, with available input types varying by selected model.
     * If the result of this method is `null`, it means that the content could be a list or null altogether.
     *
     * @return the content value if defined as a string
     */
    public String getStringContent() {
        return this.stringContent;
    }

    /**
     * Get the name property: An optional name for the participant. Provides the model information to differentiate
     * between participants of the same role.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: An optional name for the participant. Provides the model information to differentiate
     * between participants of the same role.
     *
     * @param name the name value to set.
     * @return the ChatRequestDeveloperMessage object itself.
     */
    @Generated
    public ChatRequestDeveloperMessage setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (stringContent != null) {
            jsonWriter.writeStringField("content", stringContent);
        } else if (chatMessageContentItems != null) {
            jsonWriter.writeArrayField("content", chatMessageContentItems, JsonWriter::writeJson);
        } else {
            jsonWriter.writeNullField("content");
        }
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatRequestDeveloperMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatRequestDeveloperMessage if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatRequestDeveloperMessage.
     */
    public static ChatRequestDeveloperMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BinaryData content = null;
            String stringContent = null;
            List<ChatMessageContentItem> chatMessageContentItems = null;
            ChatRole role = ChatRole.DEVELOPER;
            String name = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    if (reader.currentToken() == JsonToken.STRING) {
                        stringContent = reader.getString();
                    } else if (reader.currentToken() == JsonToken.START_ARRAY) {
                        chatMessageContentItems
                            = reader.readArray(arrayReader -> arrayReader.readObject(ChatMessageContentItem::fromJson));
                    } else if (reader.currentToken() == JsonToken.NULL) {
                        content = null;
                    } else {
                        throw new IllegalStateException("Unexpected 'content' type found when deserializing"
                            + " ChatRequestAssistantMessage JSON object: " + reader.currentToken());
                    }
                } else if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ChatRequestDeveloperMessage deserializedChatRequestDeveloperMessage;
            if (CoreUtils.isNullOrEmpty(stringContent) && chatMessageContentItems == null) {
                deserializedChatRequestDeveloperMessage = new ChatRequestDeveloperMessage(content);
            } else {
                deserializedChatRequestDeveloperMessage = CoreUtils.isNullOrEmpty(stringContent)
                    ? new ChatRequestDeveloperMessage(chatMessageContentItems)
                    : new ChatRequestDeveloperMessage(stringContent);
            }
            deserializedChatRequestDeveloperMessage.role = role;
            deserializedChatRequestDeveloperMessage.name = name;
            return deserializedChatRequestDeveloperMessage;
        });
    }
}
