// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about content filtering evaluated against generated model output.
 */
@Immutable
public final class ContentFilterResultsForChoice implements JsonSerializable<ContentFilterResultsForChoice> {

    /*
     * Describes language related to anatomical organs and genitals, romantic relationships,
     * acts portrayed in erotic or affectionate terms, physical sexual acts, including
     * those portrayed as an assault or a forced sexual violent act against one’s will,
     * prostitution, pornography, and abuse.
     */
    @Generated
    private ContentFilterResult sexual;

    /*
     * Describes language related to physical actions intended to hurt, injure, damage, or
     * kill someone or something; describes weapons, etc.
     */
    @Generated
    private ContentFilterResult violence;

    /*
     * Describes language attacks or uses that include pejorative or discriminatory language
     * with reference to a person or identity group on the basis of certain differentiating
     * attributes of these groups including but not limited to race, ethnicity, nationality,
     * gender identity and expression, sexual orientation, religion, immigration status, ability
     * status, personal appearance, and body size.
     */
    @Generated
    private ContentFilterResult hate;

    /*
     * Describes language related to physical actions intended to purposely hurt, injure,
     * or damage one’s body, or kill oneself.
     */
    @Generated
    private ContentFilterResult selfHarm;

    /*
     * Describes whether profanity was detected.
     */
    @Generated
    private ContentFilterDetectionResult profanity;

    /*
     * Describes detection results against configured custom blocklists.
     */
    @Generated
    private ContentFilterDetailedResults customBlocklists;

    /*
     * Describes an error returned if the content filtering system is
     * down or otherwise unable to complete the operation in time.
     */
    @Generated
    private ResponseError error;

    /*
     * Information about detection of protected text material.
     */
    @Generated
    private ContentFilterDetectionResult protectedMaterialText;

    /*
     * Information about detection of protected code material.
     */
    @Generated
    private ContentFilterCitedDetectionResult protectedMaterialCode;

    /**
     * Creates an instance of ContentFilterResultsForChoice class.
     */
    @Generated
    private ContentFilterResultsForChoice() {
    }

    /**
     * Get the sexual property: Describes language related to anatomical organs and genitals, romantic relationships,
     * acts portrayed in erotic or affectionate terms, physical sexual acts, including
     * those portrayed as an assault or a forced sexual violent act against one’s will,
     * prostitution, pornography, and abuse.
     *
     * @return the sexual value.
     */
    @Generated
    public ContentFilterResult getSexual() {
        return this.sexual;
    }

    /**
     * Get the violence property: Describes language related to physical actions intended to hurt, injure, damage, or
     * kill someone or something; describes weapons, etc.
     *
     * @return the violence value.
     */
    @Generated
    public ContentFilterResult getViolence() {
        return this.violence;
    }

    /**
     * Get the hate property: Describes language attacks or uses that include pejorative or discriminatory language
     * with reference to a person or identity group on the basis of certain differentiating
     * attributes of these groups including but not limited to race, ethnicity, nationality,
     * gender identity and expression, sexual orientation, religion, immigration status, ability
     * status, personal appearance, and body size.
     *
     * @return the hate value.
     */
    @Generated
    public ContentFilterResult getHate() {
        return this.hate;
    }

    /**
     * Get the selfHarm property: Describes language related to physical actions intended to purposely hurt, injure,
     * or damage one’s body, or kill oneself.
     *
     * @return the selfHarm value.
     */
    @Generated
    public ContentFilterResult getSelfHarm() {
        return this.selfHarm;
    }

    /**
     * Get the profanity property: Describes whether profanity was detected.
     *
     * @return the profanity value.
     */
    @Generated
    public ContentFilterDetectionResult getProfanity() {
        return this.profanity;
    }

    /**
     * Get the customBlocklists property: Describes detection results against configured custom blocklists.
     *
     * @return the customBlocklists value.
     */
    @Generated
    public ContentFilterDetailedResults getCustomBlocklists() {
        return this.customBlocklists;
    }

    /**
     * Get the error property: Describes an error returned if the content filtering system is
     * down or otherwise unable to complete the operation in time.
     *
     * @return the error value.
     */
    @Generated
    public ResponseError getError() {
        return this.error;
    }

    /**
     * Get the protectedMaterialText property: Information about detection of protected text material.
     *
     * @return the protectedMaterialText value.
     */
    @Generated
    public ContentFilterDetectionResult getProtectedMaterialText() {
        return this.protectedMaterialText;
    }

    /**
     * Get the protectedMaterialCode property: Information about detection of protected code material.
     *
     * @return the protectedMaterialCode value.
     */
    @Generated
    public ContentFilterCitedDetectionResult getProtectedMaterialCode() {
        return this.protectedMaterialCode;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sexual", this.sexual);
        jsonWriter.writeJsonField("violence", this.violence);
        jsonWriter.writeJsonField("hate", this.hate);
        jsonWriter.writeJsonField("self_harm", this.selfHarm);
        jsonWriter.writeJsonField("profanity", this.profanity);
        jsonWriter.writeJsonField("custom_blocklists", this.customBlocklists);
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeJsonField("protected_material_text", this.protectedMaterialText);
        jsonWriter.writeJsonField("protected_material_code", this.protectedMaterialCode);
        jsonWriter.writeJsonField("ungrounded_material", this.ungroundedMaterial);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentFilterResultsForChoice from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentFilterResultsForChoice if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContentFilterResultsForChoice.
     */
    @Generated
    public static ContentFilterResultsForChoice fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContentFilterResultsForChoice deserializedContentFilterResultsForChoice
                = new ContentFilterResultsForChoice();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sexual".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.sexual = ContentFilterResult.fromJson(reader);
                } else if ("violence".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.violence = ContentFilterResult.fromJson(reader);
                } else if ("hate".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.hate = ContentFilterResult.fromJson(reader);
                } else if ("self_harm".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.selfHarm = ContentFilterResult.fromJson(reader);
                } else if ("profanity".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.profanity = ContentFilterDetectionResult.fromJson(reader);
                } else if ("custom_blocklists".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.customBlocklists
                        = ContentFilterDetailedResults.fromJson(reader);
                } else if ("error".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.error = ResponseError.fromJson(reader);
                } else if ("protected_material_text".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.protectedMaterialText
                        = ContentFilterDetectionResult.fromJson(reader);
                } else if ("protected_material_code".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.protectedMaterialCode
                        = ContentFilterCitedDetectionResult.fromJson(reader);
                } else if ("ungrounded_material".equals(fieldName)) {
                    deserializedContentFilterResultsForChoice.ungroundedMaterial
                        = ContentFilterCompletionTextSpanResult.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedContentFilterResultsForChoice;
        });
    }

    /*
     * Information about detection of ungrounded material.
     */
    @Generated
    private ContentFilterCompletionTextSpanResult ungroundedMaterial;

    /**
     * Get the ungroundedMaterial property: Information about detection of ungrounded material.
     *
     * @return the ungroundedMaterial value.
     */
    @Generated
    public ContentFilterCompletionTextSpanResult getUngroundedMaterial() {
        return this.ungroundedMaterial;
    }
}
