// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Values to describe the format of the input audio data.
 */
public final class InputAudioFormat extends ExpandableStringEnum<InputAudioFormat> {

    /**
     * Specifies that the audio data is in the WAV format.
     */
    @Generated
    public static final InputAudioFormat WAV = fromString("wav");

    /**
     * Specifies that the audio data is in the MP3 format.
     */
    @Generated
    public static final InputAudioFormat MP3 = fromString("mp3");

    /**
     * Creates a new instance of InputAudioFormat value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public InputAudioFormat() {
    }

    /**
     * Creates or finds a InputAudioFormat from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding InputAudioFormat.
     */
    @Generated
    public static InputAudioFormat fromString(String name) {
        return fromString(name, InputAudioFormat.class);
    }

    /**
     * Gets known InputAudioFormat values.
     *
     * @return known InputAudioFormat values.
     */
    @Generated
    public static Collection<InputAudioFormat> values() {
        return values(InputAudioFormat.class);
    }
}
