// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for the MongoDB chat extension. The supported authentication types are AccessToken,
 * SystemAssignedManagedIdentity and UserAssignedManagedIdentity.
 */
@Fluent
public final class MongoDBChatExtensionParameters implements JsonSerializable<MongoDBChatExtensionParameters> {

    /*
     * The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     */
    @Generated
    private OnYourDataUsernameAndPasswordAuthenticationOptions authentication;

    /*
     * The configured top number of documents to feature for the configured query.
     */
    @Generated
    private Integer topNDocuments;

    /*
     * Whether queries should be restricted to use of indexed data.
     */
    @Generated
    private Boolean inScope;

    /*
     * The configured strictness of the search relevance filtering. The higher of strictness, the higher of the
     * precision but lower recall of the answer.
     */
    @Generated
    private Integer strictness;

    /*
     * The max number of rewritten queries should be send to search provider for one user message. If not specified,
     * the system will decide the number of queries to send.
     */
    @Generated
    private Integer maxSearchQueries;

    /*
     * If specified as true, the system will allow partial search results to be used and the request fails if all the
     * queries fail.
     * If not specified, or specified as false, the request will fail if any search query fails.
     */
    @Generated
    private Boolean allowPartialResult;

    /*
     * The included properties of the output context. If not specified, the default value is `citations` and `intent`.
     */
    @Generated
    private List<OnYourDataContextProperty> includeContexts;

    /*
     * The endpoint name for MongoDB.
     */
    @Generated
    private final String endpoint;

    /*
     * The collection name for MongoDB.
     */
    @Generated
    private final String collectionName;

    /*
     * The database name for MongoDB.
     */
    @Generated
    private final String databaseName;

    /*
     * The app name for MongoDB.
     */
    @Generated
    private final String appName;

    /*
     * Field mappings to apply to data used by the MongoDB data source.
     * Note that content and vector field mappings are required for MongoDB.
     */
    @Generated
    private final MongoDBChatExtensionParametersFieldsMapping fieldsMapping;

    /*
     * The vectorization source to use with the MongoDB chat extension.
     */
    @Generated
    private final BinaryData embeddingDependency;

    /**
     * Get the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @return the authentication value.
     */
    @Generated
    public OnYourDataUsernameAndPasswordAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    /**
     * Get the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @return the topNDocuments value.
     */
    @Generated
    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    /**
     * Set the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @param topNDocuments the topNDocuments value to set.
     * @return the MongoDBChatExtensionParameters object itself.
     */
    @Generated
    public MongoDBChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    /**
     * Get the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @return the inScope value.
     */
    @Generated
    public Boolean isInScope() {
        return this.inScope;
    }

    /**
     * Set the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @param inScope the inScope value to set.
     * @return the MongoDBChatExtensionParameters object itself.
     */
    @Generated
    public MongoDBChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    /**
     * Get the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @return the strictness value.
     */
    @Generated
    public Integer getStrictness() {
        return this.strictness;
    }

    /**
     * Set the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @param strictness the strictness value to set.
     * @return the MongoDBChatExtensionParameters object itself.
     */
    @Generated
    public MongoDBChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    /**
     * Get the maxSearchQueries property: The max number of rewritten queries should be send to search provider for one
     * user message. If not specified,
     * the system will decide the number of queries to send.
     *
     * @return the maxSearchQueries value.
     */
    @Generated
    public Integer getMaxSearchQueries() {
        return this.maxSearchQueries;
    }

    /**
     * Set the maxSearchQueries property: The max number of rewritten queries should be send to search provider for one
     * user message. If not specified,
     * the system will decide the number of queries to send.
     *
     * @param maxSearchQueries the maxSearchQueries value to set.
     * @return the MongoDBChatExtensionParameters object itself.
     */
    @Generated
    public MongoDBChatExtensionParameters setMaxSearchQueries(Integer maxSearchQueries) {
        this.maxSearchQueries = maxSearchQueries;
        return this;
    }

    /**
     * Get the allowPartialResult property: If specified as true, the system will allow partial search results to be
     * used and the request fails if all the queries fail.
     * If not specified, or specified as false, the request will fail if any search query fails.
     *
     * @return the allowPartialResult value.
     */
    @Generated
    public Boolean isAllowPartialResult() {
        return this.allowPartialResult;
    }

    /**
     * Set the allowPartialResult property: If specified as true, the system will allow partial search results to be
     * used and the request fails if all the queries fail.
     * If not specified, or specified as false, the request will fail if any search query fails.
     *
     * @param allowPartialResult the allowPartialResult value to set.
     * @return the MongoDBChatExtensionParameters object itself.
     */
    @Generated
    public MongoDBChatExtensionParameters setAllowPartialResult(Boolean allowPartialResult) {
        this.allowPartialResult = allowPartialResult;
        return this;
    }

    /**
     * Get the includeContexts property: The included properties of the output context. If not specified, the default
     * value is `citations` and `intent`.
     *
     * @return the includeContexts value.
     */
    @Generated
    public List<OnYourDataContextProperty> getIncludeContexts() {
        return this.includeContexts;
    }

    /**
     * Set the includeContexts property: The included properties of the output context. If not specified, the default
     * value is `citations` and `intent`.
     *
     * @param includeContexts the includeContexts value to set.
     * @return the MongoDBChatExtensionParameters object itself.
     */
    @Generated
    public MongoDBChatExtensionParameters setIncludeContexts(List<OnYourDataContextProperty> includeContexts) {
        this.includeContexts = includeContexts;
        return this;
    }

    /**
     * Get the endpoint property: The endpoint name for MongoDB.
     *
     * @return the endpoint value.
     */
    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Get the collectionName property: The collection name for MongoDB.
     *
     * @return the collectionName value.
     */
    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }

    /**
     * Get the databaseName property: The database name for MongoDB.
     *
     * @return the databaseName value.
     */
    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * Get the appName property: The app name for MongoDB.
     *
     * @return the appName value.
     */
    @Generated
    public String getAppName() {
        return this.appName;
    }

    /**
     * Get the fieldsMapping property: Field mappings to apply to data used by the MongoDB data source.
     * Note that content and vector field mappings are required for MongoDB.
     *
     * @return the fieldsMapping value.
     */
    @Generated
    public MongoDBChatExtensionParametersFieldsMapping getFieldsMapping() {
        return this.fieldsMapping;
    }

    /**
     * Get the embeddingDependency property: The vectorization source to use with the MongoDB chat extension.
     *
     * @return the embeddingDependency value.
     */
    @Generated
    public BinaryData getEmbeddingDependency() {
        return this.embeddingDependency;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeStringField("collection_name", this.collectionName);
        jsonWriter.writeStringField("database_name", this.databaseName);
        jsonWriter.writeStringField("app_name", this.appName);
        jsonWriter.writeStringField("index_name", this.indexName);
        jsonWriter.writeJsonField("fields_mapping", this.fieldsMapping);
        jsonWriter.writeFieldName("embedding_dependency");
        this.embeddingDependency.writeTo(jsonWriter);
        jsonWriter.writeNumberField("top_n_documents", this.topNDocuments);
        jsonWriter.writeBooleanField("in_scope", this.inScope);
        jsonWriter.writeNumberField("strictness", this.strictness);
        jsonWriter.writeNumberField("max_search_queries", this.maxSearchQueries);
        jsonWriter.writeBooleanField("allow_partial_result", this.allowPartialResult);
        jsonWriter.writeArrayField("include_contexts", this.includeContexts,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("authentication", this.authentication);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MongoDBChatExtensionParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MongoDBChatExtensionParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MongoDBChatExtensionParameters.
     */
    @Generated
    public static MongoDBChatExtensionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String endpoint = null;
            String collectionName = null;
            String databaseName = null;
            String appName = null;
            String indexName = null;
            MongoDBChatExtensionParametersFieldsMapping fieldsMapping = null;
            BinaryData embeddingDependency = null;
            Integer topNDocuments = null;
            Boolean inScope = null;
            Integer strictness = null;
            Integer maxSearchQueries = null;
            Boolean allowPartialResult = null;
            List<OnYourDataContextProperty> includeContexts = null;
            OnYourDataUsernameAndPasswordAuthenticationOptions authentication = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    endpoint = reader.getString();
                } else if ("collection_name".equals(fieldName)) {
                    collectionName = reader.getString();
                } else if ("database_name".equals(fieldName)) {
                    databaseName = reader.getString();
                } else if ("app_name".equals(fieldName)) {
                    appName = reader.getString();
                } else if ("index_name".equals(fieldName)) {
                    indexName = reader.getString();
                } else if ("fields_mapping".equals(fieldName)) {
                    fieldsMapping = MongoDBChatExtensionParametersFieldsMapping.fromJson(reader);
                } else if ("embedding_dependency".equals(fieldName)) {
                    embeddingDependency
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("top_n_documents".equals(fieldName)) {
                    topNDocuments = reader.getNullable(JsonReader::getInt);
                } else if ("in_scope".equals(fieldName)) {
                    inScope = reader.getNullable(JsonReader::getBoolean);
                } else if ("strictness".equals(fieldName)) {
                    strictness = reader.getNullable(JsonReader::getInt);
                } else if ("max_search_queries".equals(fieldName)) {
                    maxSearchQueries = reader.getNullable(JsonReader::getInt);
                } else if ("allow_partial_result".equals(fieldName)) {
                    allowPartialResult = reader.getNullable(JsonReader::getBoolean);
                } else if ("include_contexts".equals(fieldName)) {
                    includeContexts
                        = reader.readArray(reader1 -> OnYourDataContextProperty.fromString(reader1.getString()));
                } else if ("authentication".equals(fieldName)) {
                    authentication = OnYourDataUsernameAndPasswordAuthenticationOptions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            MongoDBChatExtensionParameters deserializedMongoDBChatExtensionParameters
                = new MongoDBChatExtensionParameters(endpoint, collectionName, databaseName, appName, indexName,
                    fieldsMapping, embeddingDependency);
            deserializedMongoDBChatExtensionParameters.topNDocuments = topNDocuments;
            deserializedMongoDBChatExtensionParameters.inScope = inScope;
            deserializedMongoDBChatExtensionParameters.strictness = strictness;
            deserializedMongoDBChatExtensionParameters.maxSearchQueries = maxSearchQueries;
            deserializedMongoDBChatExtensionParameters.allowPartialResult = allowPartialResult;
            deserializedMongoDBChatExtensionParameters.includeContexts = includeContexts;
            deserializedMongoDBChatExtensionParameters.authentication = authentication;
            return deserializedMongoDBChatExtensionParameters;
        });
    }

    /*
     * The name of the MongoDB index.
     */
    @Generated
    private final String indexName;

    /**
     * Creates an instance of MongoDBChatExtensionParameters class.
     *
     * @param endpoint the endpoint value to set.
     * @param collectionName the collectionName value to set.
     * @param databaseName the databaseName value to set.
     * @param appName the appName value to set.
     * @param indexName the indexName value to set.
     * @param fieldsMapping the fieldsMapping value to set.
     * @param embeddingDependency the embeddingDependency value to set.
     */
    @Generated
    public MongoDBChatExtensionParameters(String endpoint, String collectionName, String databaseName, String appName,
        String indexName, MongoDBChatExtensionParametersFieldsMapping fieldsMapping, BinaryData embeddingDependency) {
        this.endpoint = endpoint;
        this.collectionName = collectionName;
        this.databaseName = databaseName;
        this.appName = appName;
        this.indexName = indexName;
        this.fieldsMapping = fieldsMapping;
        this.embeddingDependency = embeddingDependency;
    }

    /**
     * Get the indexName property: The name of the MongoDB index.
     *
     * @return the indexName value.
     */
    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    /**
     * Set the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @param authentication the authentication value to set.
     * @return the MongoDBChatExtensionParameters object itself.
     */
    @Generated
    public MongoDBChatExtensionParameters
        setAuthentication(OnYourDataUsernameAndPasswordAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }
}
