// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The MongoDBChatExtensionParametersFieldsMapping model.
 */
@Fluent
public final class MongoDBChatExtensionParametersFieldsMapping
    implements JsonSerializable<MongoDBChatExtensionParametersFieldsMapping> {

    /*
     * The content_fields property.
     */
    @Generated
    private final List<String> contentFields;

    /*
     * The vector_fields property.
     */
    @Generated
    private final List<String> vectorFields;

    /*
     * The title_field property.
     */
    @Generated
    private String titleField;

    /*
     * The url_field property.
     */
    @Generated
    private String urlField;

    /*
     * The filepath_field property.
     */
    @Generated
    private String filepathField;

    /*
     * The content_fields_separator property.
     */
    @Generated
    private String contentFieldsSeparator;

    /**
     * Creates an instance of MongoDBChatExtensionParametersFieldsMapping class.
     *
     * @param contentFields the contentFields value to set.
     * @param vectorFields the vectorFields value to set.
     */
    @Generated
    public MongoDBChatExtensionParametersFieldsMapping(List<String> contentFields, List<String> vectorFields) {
        this.contentFields = contentFields;
        this.vectorFields = vectorFields;
    }

    /**
     * Get the contentFields property: The content_fields property.
     *
     * @return the contentFields value.
     */
    @Generated
    public List<String> getContentFields() {
        return this.contentFields;
    }

    /**
     * Get the vectorFields property: The vector_fields property.
     *
     * @return the vectorFields value.
     */
    @Generated
    public List<String> getVectorFields() {
        return this.vectorFields;
    }

    /**
     * Get the titleField property: The title_field property.
     *
     * @return the titleField value.
     */
    @Generated
    public String getTitleField() {
        return this.titleField;
    }

    /**
     * Set the titleField property: The title_field property.
     *
     * @param titleField the titleField value to set.
     * @return the MongoDBChatExtensionParametersFieldsMapping object itself.
     */
    @Generated
    public MongoDBChatExtensionParametersFieldsMapping setTitleField(String titleField) {
        this.titleField = titleField;
        return this;
    }

    /**
     * Get the urlField property: The url_field property.
     *
     * @return the urlField value.
     */
    @Generated
    public String getUrlField() {
        return this.urlField;
    }

    /**
     * Set the urlField property: The url_field property.
     *
     * @param urlField the urlField value to set.
     * @return the MongoDBChatExtensionParametersFieldsMapping object itself.
     */
    @Generated
    public MongoDBChatExtensionParametersFieldsMapping setUrlField(String urlField) {
        this.urlField = urlField;
        return this;
    }

    /**
     * Get the filepathField property: The filepath_field property.
     *
     * @return the filepathField value.
     */
    @Generated
    public String getFilepathField() {
        return this.filepathField;
    }

    /**
     * Set the filepathField property: The filepath_field property.
     *
     * @param filepathField the filepathField value to set.
     * @return the MongoDBChatExtensionParametersFieldsMapping object itself.
     */
    @Generated
    public MongoDBChatExtensionParametersFieldsMapping setFilepathField(String filepathField) {
        this.filepathField = filepathField;
        return this;
    }

    /**
     * Get the contentFieldsSeparator property: The content_fields_separator property.
     *
     * @return the contentFieldsSeparator value.
     */
    @Generated
    public String getContentFieldsSeparator() {
        return this.contentFieldsSeparator;
    }

    /**
     * Set the contentFieldsSeparator property: The content_fields_separator property.
     *
     * @param contentFieldsSeparator the contentFieldsSeparator value to set.
     * @return the MongoDBChatExtensionParametersFieldsMapping object itself.
     */
    @Generated
    public MongoDBChatExtensionParametersFieldsMapping setContentFieldsSeparator(String contentFieldsSeparator) {
        this.contentFieldsSeparator = contentFieldsSeparator;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("content_fields", this.contentFields,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("vector_fields", this.vectorFields,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("title_field", this.titleField);
        jsonWriter.writeStringField("url_field", this.urlField);
        jsonWriter.writeStringField("filepath_field", this.filepathField);
        jsonWriter.writeStringField("content_fields_separator", this.contentFieldsSeparator);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MongoDBChatExtensionParametersFieldsMapping from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MongoDBChatExtensionParametersFieldsMapping if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MongoDBChatExtensionParametersFieldsMapping.
     */
    @Generated
    public static MongoDBChatExtensionParametersFieldsMapping fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<String> contentFields = null;
            List<String> vectorFields = null;
            String titleField = null;
            String urlField = null;
            String filepathField = null;
            String contentFieldsSeparator = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content_fields".equals(fieldName)) {
                    contentFields = reader.readArray(reader1 -> reader1.getString());
                } else if ("vector_fields".equals(fieldName)) {
                    vectorFields = reader.readArray(reader1 -> reader1.getString());
                } else if ("title_field".equals(fieldName)) {
                    titleField = reader.getString();
                } else if ("url_field".equals(fieldName)) {
                    urlField = reader.getString();
                } else if ("filepath_field".equals(fieldName)) {
                    filepathField = reader.getString();
                } else if ("content_fields_separator".equals(fieldName)) {
                    contentFieldsSeparator = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            MongoDBChatExtensionParametersFieldsMapping deserializedMongoDBChatExtensionParametersFieldsMapping
                = new MongoDBChatExtensionParametersFieldsMapping(contentFields, vectorFields);
            deserializedMongoDBChatExtensionParametersFieldsMapping.titleField = titleField;
            deserializedMongoDBChatExtensionParametersFieldsMapping.urlField = urlField;
            deserializedMongoDBChatExtensionParametersFieldsMapping.filepathField = filepathField;
            deserializedMongoDBChatExtensionParametersFieldsMapping.contentFieldsSeparator = contentFieldsSeparator;
            return deserializedMongoDBChatExtensionParametersFieldsMapping;
        });
    }
}
