// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The output audio format.
 */
public final class OutputAudioFormat extends ExpandableStringEnum<OutputAudioFormat> {

    /**
     * The output audio format is WAV.
     */
    @Generated
    public static final OutputAudioFormat WAV = fromString("wav");

    /**
     * The output audio format is MP3.
     */
    @Generated
    public static final OutputAudioFormat MP3 = fromString("mp3");

    /**
     * The output audio format is FLAC.
     */
    @Generated
    public static final OutputAudioFormat FLAC = fromString("flac");

    /**
     * The output audio format is OPUS.
     */
    @Generated
    public static final OutputAudioFormat OPUS = fromString("opus");

    /**
     * The output audio format is PCM16.
     */
    @Generated
    public static final OutputAudioFormat PCM16 = fromString("pcm16");

    /**
     * Creates a new instance of OutputAudioFormat value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public OutputAudioFormat() {
    }

    /**
     * Creates or finds a OutputAudioFormat from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OutputAudioFormat.
     */
    @Generated
    public static OutputAudioFormat fromString(String name) {
        return fromString(name, OutputAudioFormat.class);
    }

    /**
     * Gets known OutputAudioFormat values.
     *
     * @return known OutputAudioFormat values.
     */
    @Generated
    public static Collection<OutputAudioFormat> values() {
        return values(OutputAudioFormat.class);
    }
}
