// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Static predicted output content, such as the content of a text file that is being regenerated.
 */
@Immutable
public final class PredictionContent implements JsonSerializable<PredictionContent> {

    /*
     * The type of the predicted content you want to provide. This type is
     * currently always `content`.
     */
    @Generated
    private final PredictionContentType type = PredictionContentType.CONTENT;

    /*
     * The content that should be matched when generating a model response.
     * If generated tokens would match this content, the entire model response
     * can be returned much more quickly.
     */
    @Generated
    private final BinaryData content;

    /**
     * Creates an instance of PredictionContent class.
     *
     * @param content the content value to set.
     */
    @Generated
    public PredictionContent(BinaryData content) {
        this.content = content;
    }

    /**
     * Get the type property: The type of the predicted content you want to provide. This type is
     * currently always `content`.
     *
     * @return the type value.
     */
    @Generated
    public PredictionContentType getType() {
        return this.type;
    }

    /**
     * Get the content property: The content that should be matched when generating a model response.
     * If generated tokens would match this content, the entire model response
     * can be returned much more quickly.
     *
     * @return the content value.
     */
    @Generated
    public BinaryData getContent() {
        return this.content;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeFieldName("content");
        this.content.writeTo(jsonWriter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PredictionContent from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PredictionContent if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PredictionContent.
     */
    @Generated
    public static PredictionContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BinaryData content = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else {
                    reader.skipChildren();
                }
            }
            return new PredictionContent(content);
        });
    }
}
