// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Values for the reasoning.
 */
public final class ReasoningEffortValue extends ExpandableStringEnum<ReasoningEffortValue> {

    /**
     * The reasoning effort is low.
     */
    @Generated
    public static final ReasoningEffortValue LOW = fromString("low");

    /**
     * The reasoning effort is medium.
     */
    @Generated
    public static final ReasoningEffortValue MEDIUM = fromString("medium");

    /**
     * The reasoning effort is high.
     */
    @Generated
    public static final ReasoningEffortValue HIGH = fromString("high");

    /**
     * Creates a new instance of ReasoningEffortValue value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ReasoningEffortValue() {
    }

    /**
     * Creates or finds a ReasoningEffortValue from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ReasoningEffortValue.
     */
    @Generated
    public static ReasoningEffortValue fromString(String name) {
        return fromString(name, ReasoningEffortValue.class);
    }

    /**
     * Gets known ReasoningEffortValue values.
     *
     * @return known ReasoningEffortValue values.
     */
    @Generated
    public static Collection<ReasoningEffortValue> values() {
        return values(ReasoningEffortValue.class);
    }
}
