// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

/**
 * The Upload object can accept byte chunks in the form of Parts.
 */
@Immutable
public final class Upload implements JsonSerializable<Upload> {

    /*
     * The Upload unique identifier, which can be referenced in API endpoints.
     */
    @Generated
    private final String id;

    /*
     * The Unix timestamp (in seconds) for when the Upload was created.
     */
    @Generated
    private final long createdAt;

    /*
     * The name of the file to be uploaded.
     */
    @Generated
    private final String filename;

    /*
     * The intended number of bytes to be uploaded.
     */
    @Generated
    private final long bytes;

    /*
     * The intended purpose of the file.
     */
    @Generated
    private final UploadPurpose purpose;

    /*
     * The status of the Upload.
     */
    @Generated
    private final UploadStatus status;

    /*
     * The Unix timestamp (in seconds) for when the Upload was created.
     */
    @Generated
    private final long expiresAt;

    /*
     * The object type, which is always "upload".
     */
    @Generated
    private UploadObject object;

    /*
     * The ready File object after the Upload is completed.
     */
    @Generated
    private OpenAIFile file;

    /**
     * Get the id property: The Upload unique identifier, which can be referenced in API endpoints.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the createdAt property: The Unix timestamp (in seconds) for when the Upload was created.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the filename property: The name of the file to be uploaded.
     *
     * @return the filename value.
     */
    @Generated
    public String getFilename() {
        return this.filename;
    }

    /**
     * Get the bytes property: The intended number of bytes to be uploaded.
     *
     * @return the bytes value.
     */
    @Generated
    public long getBytes() {
        return this.bytes;
    }

    /**
     * Get the purpose property: The intended purpose of the file.
     *
     * @return the purpose value.
     */
    @Generated
    public UploadPurpose getPurpose() {
        return this.purpose;
    }

    /**
     * Get the status property: The status of the Upload.
     *
     * @return the status value.
     */
    @Generated
    public UploadStatus getStatus() {
        return this.status;
    }

    /**
     * Get the expiresAt property: The Unix timestamp (in seconds) for when the Upload was created.
     *
     * @return the expiresAt value.
     */
    @Generated
    public OffsetDateTime getExpiresAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiresAt), ZoneOffset.UTC);
    }

    /**
     * Get the object property: The object type, which is always "upload".
     *
     * @return the object value.
     */
    @Generated
    public UploadObject getObject() {
        return this.object;
    }

    /**
     * Get the file property: The ready File object after the Upload is completed.
     *
     * @return the file value.
     */
    @Generated
    public OpenAIFile getFile() {
        return this.file;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("filename", this.filename);
        jsonWriter.writeLongField("bytes", this.bytes);
        jsonWriter.writeStringField("purpose", this.purpose == null ? null : this.purpose.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeLongField("expires_at", this.expiresAt);
        jsonWriter.writeStringField("object", this.object == null ? null : this.object.toString());
        jsonWriter.writeJsonField("file", this.file);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Upload from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of Upload if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Upload.
     */
    @Generated
    public static Upload fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String filename = null;
            long bytes = 0L;
            UploadPurpose purpose = null;
            UploadStatus status = null;
            OffsetDateTime expiresAt = null;
            UploadObject object = null;
            OpenAIFile file = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("filename".equals(fieldName)) {
                    filename = reader.getString();
                } else if ("bytes".equals(fieldName)) {
                    bytes = reader.getLong();
                } else if ("purpose".equals(fieldName)) {
                    purpose = UploadPurpose.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    status = UploadStatus.fromString(reader.getString());
                } else if ("expires_at".equals(fieldName)) {
                    expiresAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("object".equals(fieldName)) {
                    object = UploadObject.fromString(reader.getString());
                } else if ("file".equals(fieldName)) {
                    file = OpenAIFile.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            Upload deserializedUpload = new Upload(id, createdAt, filename, bytes, purpose, status, expiresAt);
            deserializedUpload.object = object;
            deserializedUpload.file = file;
            return deserializedUpload;
        });
    }

    /**
     * Creates an instance of Upload class.
     *
     * @param id the id value to set.
     * @param createdAt the createdAt value to set.
     * @param filename the filename value to set.
     * @param bytes the bytes value to set.
     * @param purpose the purpose value to set.
     * @param status the status value to set.
     * @param expiresAt the expiresAt value to set.
     */
    @Generated
    private Upload(String id, OffsetDateTime createdAt, String filename, long bytes, UploadPurpose purpose,
        UploadStatus status, OffsetDateTime expiresAt) {
        this.id = id;
        if (createdAt == null) {
            this.createdAt = 0L;
        } else {
            this.createdAt = createdAt.toEpochSecond();
        }
        this.filename = filename;
        this.bytes = bytes;
        this.purpose = purpose;
        this.status = status;
        if (expiresAt == null) {
            this.expiresAt = 0L;
        } else {
            this.expiresAt = expiresAt.toEpochSecond();
        }
    }
}
