// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses;

import com.azure.core.util.ServiceVersion;

/**
 * Service version of AzureResponsesClient.
 */
public enum AzureResponsesServiceVersion implements ServiceVersion {
    /**
     * Enum value 2024-02-15-preview.
     */
    V2024_02_15_PREVIEW("2024-02-15-preview"),

    /**
     * Enum value 2024-04-01-preview.
     */
    V2024_04_01_PREVIEW("2024-04-01-preview"),

    /**
     * Enum value 2024-06-01.
     */
    V2024_06_01("2024-06-01"),

    /**
     * Enum value 2024-08-01-preview.
     */
    V2024_08_01_PREVIEW("2024-08-01-preview"),

    /**
     * Enum value 2024-09-01-preview.
     */
    V2024_09_01_PREVIEW("2024-09-01-preview"),

    /**
     * Enum value 2024-10-01-preview.
     */
    V2024_10_01_PREVIEW("2024-10-01-preview"),

    /**
     * Enum value 2024-10-21.
     */
    V2024_10_21("2024-10-21"),

    /**
     * Enum value 2024-12-01-preview.
     */
    V2024_12_01_PREVIEW("2024-12-01-preview"),

    /**
     * Enum value 2025-01-01-preview.
     */
    V2025_01_01_PREVIEW("2025-01-01-preview"),

    /**
     * Enum value 2025-03-01-preview.
     */
    V2025_03_01_PREVIEW("2025-03-01-preview");

    private final String version;

    AzureResponsesServiceVersion(String version) {
        this.version = version;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getVersion() {
        return this.version;
    }

    /**
     * Gets the latest service version supported by this client library.
     * 
     * @return The latest {@link AzureResponsesServiceVersion}.
     */
    public static AzureResponsesServiceVersion getLatest() {
        return V2025_03_01_PREVIEW;
    }
}
