// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponseTextOptions model.
 */
@Fluent
public final class ResponseTextOptions implements JsonSerializable<ResponseTextOptions> {

    /*
     * The format property.
     */
    @Generated
    private ResponsesTextFormat format;

    /**
     * Creates an instance of ResponseTextOptions class.
     */
    @Generated
    public ResponseTextOptions() {
    }

    /**
     * Get the format property: The format property.
     *
     * @return the format value.
     */
    @Generated
    public ResponsesTextFormat getFormat() {
        return this.format;
    }

    /**
     * Set the format property: The format property.
     *
     * @param format the format value to set.
     * @return the ResponseTextOptions object itself.
     */
    @Generated
    public ResponseTextOptions setFormat(ResponsesTextFormat format) {
        this.format = format;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("format", this.format);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponseTextOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponseTextOptions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResponseTextOptions.
     */
    @Generated
    public static ResponseTextOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponseTextOptions deserializedResponseTextOptions = new ResponseTextOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("format".equals(fieldName)) {
                    deserializedResponseTextOptions.format = ResponsesTextFormat.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedResponseTextOptions;
        });
    }
}
