// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses.models;

/**
 * Defines values for ResponseTruncation.
 */
public enum ResponseTruncation {
    /**
     * Enum value auto.
     */
    AUTO("auto"),

    /**
     * Enum value disabled.
     */
    DISABLED("disabled");

    /**
     * The actual serialized value for a ResponseTruncation instance.
     */
    private final String value;

    ResponseTruncation(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResponseTruncation instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ResponseTruncation object, or null if unable to parse.
     */
    public static ResponseTruncation fromString(String value) {
        if (value == null) {
            return null;
        }
        ResponseTruncation[] items = ResponseTruncation.values();
        for (ResponseTruncation item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
