// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesContent model.
 */
@Immutable
public class ResponsesContent implements JsonSerializable<ResponsesContent> {

    /*
     * The type property.
     */
    @Generated
    private ResponsesContentType type;

    /**
     * Creates an instance of ResponsesContent class.
     */
    @Generated
    public ResponsesContent() {
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    public ResponsesContentType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesContent from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesContent if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResponsesContent.
     */
    @Generated
    public static ResponsesContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("input_text".equals(discriminatorValue)) {
                    return ResponsesInputContentText.fromJson(readerToUse.reset());
                } else if ("input_image".equals(discriminatorValue)) {
                    return ResponsesInputContentImage.fromJson(readerToUse.reset());
                } else if ("input_file".equals(discriminatorValue)) {
                    return ResponsesInputContentFile.fromJson(readerToUse.reset());
                } else if ("output_text".equals(discriminatorValue)) {
                    return ResponsesOutputContentText.fromJson(readerToUse.reset());
                } else if ("refusal".equals(discriminatorValue)) {
                    return ResponsesOutputContentRefusal.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static ResponsesContent fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponsesContent deserializedResponsesContent = new ResponsesContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResponsesContent.type = ResponsesContentType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedResponsesContent;
        });
    }
}
