// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A message item with the `developer` role.
 */
@Immutable
public final class ResponsesDeveloperMessage extends ResponsesMessage {

    /*
     * The type property.
     */
    @Generated
    private ResponsesItemType type = ResponsesItemType.MESSAGE;

    /*
     * The role associated with the message.
     */
    @Generated
    private ResponsesMessageRole role = ResponsesMessageRole.DEVELOPER;

    /*
     * The content associated with the message.
     */
    @Generated
    private final List<ResponsesContent> content;

    /**
     * Creates an instance of ResponsesDeveloperMessage class.
     *
     * @param content the content value to set.
     */
    @Generated
    public ResponsesDeveloperMessage(List<ResponsesContent> content) {
        this.content = content;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    /**
     * Get the role property: The role associated with the message.
     *
     * @return the role value.
     */
    @Generated
    @Override
    public ResponsesMessageRole getRole() {
        return this.role;
    }

    /**
     * Get the content property: The content associated with the message.
     *
     * @return the content value.
     */
    @Generated
    public List<ResponsesContent> getContent() {
        return this.content;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesDeveloperMessage from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesDeveloperMessage if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesDeveloperMessage.
     */
    @Generated
    public static ResponsesDeveloperMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            ResponsesMessageStatus status = null;
            List<ResponsesContent> content = null;
            ResponsesMessageRole role = ResponsesMessageRole.DEVELOPER;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("status".equals(fieldName)) {
                    status = ResponsesMessageStatus.fromString(reader.getString());
                } else if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> ResponsesContent.fromJson(reader1));
                } else if ("role".equals(fieldName)) {
                    role = ResponsesMessageRole.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesDeveloperMessage deserializedResponsesDeveloperMessage = new ResponsesDeveloperMessage(content);
            deserializedResponsesDeveloperMessage.setId(id);
            deserializedResponsesDeveloperMessage.setStatus(status);
            deserializedResponsesDeveloperMessage.role = role;
            return deserializedResponsesDeveloperMessage;
        });
    }
}
